/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.rcptt.core.nature.RcpttNature;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.launching.LaunchConfigurationMigration;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.ui.IStartup;
import org.w3c.dom.Document;

public class ResourceLaunchConfigurationMigration
implements IStartup {
    private static final IPath LOCAL_LOCATION = DebugPlugin.getDefault().getStateLocation().append(".launches");
    private static File tempDir = Files.createTempDir();
    protected final IResourceDeltaVisitor deltaVisitor;
    private final IResourceVisitor resourceVisitor;
    private final IResourceChangeListener resourceListener;

    public ResourceLaunchConfigurationMigration() {
        tempDir.deleteOnExit();
        this.deltaVisitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (delta.getKind() == 2) {
                    return false;
                }
                if (delta.getResource() instanceof IProject) {
                    IProject project = (IProject)delta.getResource();
                    return project.isOpen() && RcpttNature.isRcpttProject((IProject)project);
                }
                if (delta.getResource() instanceof IContainer) {
                    return true;
                }
                if (delta.getResource() instanceof IFile) {
                    IFile file = (IFile)delta.getResource();
                    if (!Strings.nullToEmpty((String)file.getFullPath().getFileExtension()).equalsIgnoreCase("launch")) {
                        return false;
                    }
                    new MigrationJob((IResource)file).schedule();
                }
                return false;
            }
        };
        this.resourceVisitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IContainer) {
                    return resource.isAccessible();
                }
                if (resource instanceof IFile) {
                    try {
                        ResourceLaunchConfigurationMigration.this.migrate((IFile)resource);
                    }
                    catch (Exception e) {
                        Q7UIPlugin.log("Failed to migrate " + resource.getName(), e);
                    }
                }
                return false;
            }
        };
        this.resourceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    if (event.getDelta() != null) {
                        event.getDelta().accept(ResourceLaunchConfigurationMigration.this.deltaVisitor);
                    }
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void migrate(IFile resource) throws CoreException {
        Document document;
        if (!"launch".equalsIgnoreCase(resource.getFileExtension())) {
            return;
        }
        if (!resource.isSynchronized(0)) {
            return;
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(resource.getContents());
            document = LaunchConfigurationMigration.parse(reader);
        }
        catch (Throwable throwable) {
            FileUtil.safeClose(reader);
            throw throwable;
        }
        FileUtil.safeClose((Closeable)reader);
        LaunchConfigurationMigration migration = new LaunchConfigurationMigration();
        if (migration.isMigrationRequired(document) && migration.migrate(document)) {
            StringWriter writer = new StringWriter();
            LaunchConfigurationMigration.write(document, writer);
            resource.setContents((InputStream)new ByteArrayInputStream(((Object)writer).toString().getBytes(Charsets.UTF_8)), 0, null);
        }
    }

    public void migrate(File file) {
        block13: {
            String fileExtension = Path.fromOSString((String)file.getName()).getFileExtension();
            if (!"launch".equalsIgnoreCase(fileExtension)) {
                return;
            }
            FileReader reader = null;
            Document document = null;
            try {
                reader = new FileReader(file);
                document = LaunchConfigurationMigration.parse(reader);
            }
            catch (FileNotFoundException e) {
                FileUtil.safeClose(reader);
            }
            LaunchConfigurationMigration migration = new LaunchConfigurationMigration();
            if (!migration.isMigrationRequired(document)) {
                return;
            }
            File backup = new File(file.getAbsolutePath() + ".q7_backup");
            file.renameTo(backup);
            File temp = null;
            try {
                try {
                    if (!migration.migrate(document)) break block13;
                    temp = new File(tempDir, file.getName());
                    FileWriter writer = new FileWriter(temp);
                    try {
                        LaunchConfigurationMigration.write(document, writer);
                    }
                    finally {
                        FileUtil.safeClose((Closeable)writer);
                    }
                    ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).importConfigurations(new File[]{temp}, null);
                }
                catch (Exception e) {
                    file.delete();
                    backup.renameTo(file);
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (temp != null) {
                    temp.delete();
                }
            }
        }
    }

    public void earlyStartup() {
        this.migrateResources();
        this.migrateLocal();
    }

    private void migrateLocal() {
        new Job("Migrate local Q7 launches"){

            protected IStatus run(IProgressMonitor monitor) {
                IPath containerPath = LOCAL_LOCATION;
                final File directory = containerPath.toFile();
                if (!directory.isDirectory()) {
                    return Status.OK_STATUS;
                }
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return dir.equals(directory) && name.endsWith("launch");
                    }
                };
                File[] files = directory.listFiles(filter);
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                subMonitor.beginTask(this.getName(), files.length);
                int i = 0;
                while (i < files.length) {
                    block7: {
                        SubMonitor childMonitor = subMonitor.newChild(1, 0);
                        childMonitor.beginTask(files[i].getName(), 1);
                        try {
                            try {
                                ResourceLaunchConfigurationMigration.this.migrate(files[i]);
                            }
                            catch (Exception e) {
                                Q7UIPlugin.log("Failed to migrate " + files[i].getName(), e);
                                childMonitor.done();
                                break block7;
                            }
                        }
                        catch (Throwable throwable) {
                            childMonitor.done();
                            throw throwable;
                        }
                        childMonitor.done();
                    }
                    ++i;
                }
                subMonitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void migrateResources() {
        new MigrationJob((IResource)ResourcesPlugin.getWorkspace().getRoot()).schedule();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 1);
    }

    class MigrationJob
    extends Job {
        private final IResource resource;

        public MigrationJob(IResource resource) {
            super("Q7 launch migration: " + resource.getName());
            this.resource = resource;
            this.setRule((ISchedulingRule)resource);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.resource.accept(ResourceLaunchConfigurationMigration.this.resourceVisitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }
    }
}

