/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.hnsw;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.quantization.QuantizedByteVectorValues;
import org.apache.lucene.util.quantization.ScalarQuantizedVectorSimilarity;
import org.apache.lucene.util.quantization.ScalarQuantizer;

public class ScalarQuantizedVectorScorer
implements FlatVectorsScorer {
    private final FlatVectorsScorer nonQuantizedDelegate;

    public static float quantizeQuery(float[] query, byte[] quantizedQuery, VectorSimilarityFunction similarityFunction, ScalarQuantizer scalarQuantizer) {
        float[] processedQuery = switch (similarityFunction) {
            default -> throw new MatchException(null, null);
            case VectorSimilarityFunction.EUCLIDEAN, VectorSimilarityFunction.DOT_PRODUCT, VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT -> query;
            case VectorSimilarityFunction.COSINE -> {
                float[] queryCopy = ArrayUtil.copyArray(query);
                VectorUtil.l2normalize(queryCopy);
                yield queryCopy;
            }
        };
        return scalarQuantizer.quantize(processedQuery, quantizedQuery, similarityFunction);
    }

    public ScalarQuantizedVectorScorer(FlatVectorsScorer flatVectorsScorer) {
        this.nonQuantizedDelegate = flatVectorsScorer;
    }

    @Override
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues) throws IOException {
        if (vectorValues instanceof QuantizedByteVectorValues) {
            QuantizedByteVectorValues quantizedByteVectorValues = (QuantizedByteVectorValues)vectorValues;
            return new ScalarQuantizedRandomVectorScorerSupplier(similarityFunction, quantizedByteVectorValues.getScalarQuantizer(), quantizedByteVectorValues);
        }
        return this.nonQuantizedDelegate.getRandomVectorScorerSupplier(similarityFunction, vectorValues);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, float[] target) throws IOException {
        if (vectorValues instanceof QuantizedByteVectorValues) {
            final QuantizedByteVectorValues quantizedByteVectorValues = (QuantizedByteVectorValues)vectorValues;
            ScalarQuantizer scalarQuantizer = quantizedByteVectorValues.getScalarQuantizer();
            final byte[] targetBytes = new byte[target.length];
            final float offsetCorrection = ScalarQuantizedVectorScorer.quantizeQuery(target, targetBytes, similarityFunction, scalarQuantizer);
            final ScalarQuantizedVectorSimilarity scalarQuantizedVectorSimilarity = ScalarQuantizedVectorSimilarity.fromVectorSimilarity(similarityFunction, scalarQuantizer.getConstantMultiplier(), scalarQuantizer.getBits());
            return new RandomVectorScorer.AbstractRandomVectorScorer(this, quantizedByteVectorValues){

                @Override
                public float score(int node) throws IOException {
                    byte[] nodeVector = quantizedByteVectorValues.vectorValue(node);
                    float nodeOffset = quantizedByteVectorValues.getScoreCorrectionConstant(node);
                    return scalarQuantizedVectorSimilarity.score(targetBytes, offsetCorrection, nodeVector, nodeOffset);
                }
            };
        }
        return this.nonQuantizedDelegate.getRandomVectorScorer(similarityFunction, vectorValues, target);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, byte[] target) throws IOException {
        return this.nonQuantizedDelegate.getRandomVectorScorer(similarityFunction, vectorValues, target);
    }

    public String toString() {
        return "ScalarQuantizedVectorScorer(nonQuantizedDelegate=" + String.valueOf(this.nonQuantizedDelegate) + ")";
    }

    public static class ScalarQuantizedRandomVectorScorerSupplier
    implements RandomVectorScorerSupplier {
        private final QuantizedByteVectorValues values;
        private final ScalarQuantizedVectorSimilarity similarity;
        private final VectorSimilarityFunction vectorSimilarityFunction;

        public ScalarQuantizedRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, ScalarQuantizer scalarQuantizer, QuantizedByteVectorValues values) {
            this.similarity = ScalarQuantizedVectorSimilarity.fromVectorSimilarity(similarityFunction, scalarQuantizer.getConstantMultiplier(), scalarQuantizer.getBits());
            this.values = values;
            this.vectorSimilarityFunction = similarityFunction;
        }

        private ScalarQuantizedRandomVectorScorerSupplier(ScalarQuantizedVectorSimilarity similarity, VectorSimilarityFunction vectorSimilarityFunction, QuantizedByteVectorValues values) {
            this.similarity = similarity;
            this.values = values;
            this.vectorSimilarityFunction = vectorSimilarityFunction;
        }

        @Override
        public RandomVectorScorer scorer(int ord) throws IOException {
            final QuantizedByteVectorValues vectorsCopy = this.values.copy();
            final byte[] queryVector = this.values.vectorValue(ord);
            final float queryOffset = this.values.getScoreCorrectionConstant(ord);
            return new RandomVectorScorer.AbstractRandomVectorScorer(vectorsCopy){

                @Override
                public float score(int node) throws IOException {
                    byte[] nodeVector = vectorsCopy.vectorValue(node);
                    float nodeOffset = vectorsCopy.getScoreCorrectionConstant(node);
                    return similarity.score(queryVector, queryOffset, nodeVector, nodeOffset);
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new ScalarQuantizedRandomVectorScorerSupplier(this.similarity, this.vectorSimilarityFunction, this.values.copy());
        }

        public String toString() {
            return "ScalarQuantizedRandomVectorScorerSupplier(vectorSimilarityFunction=" + String.valueOf((Object)this.vectorSimilarityFunction) + ")";
        }
    }
}

