/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import org.eclipse.egit.ui.internal.history.CommitGraphTable;
import org.eclipse.egit.ui.internal.history.FindToolbar;
import org.eclipse.egit.ui.internal.history.ICommitsProvider;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

abstract class SearchBar
extends ControlContribution {
    protected FindToolbar toolbar;
    protected Object searchContext;
    protected String lastText;
    private ObjectId lastObjectId;
    protected Object lastSearchContext;
    private ICommitsProvider provider;
    protected final CommitGraphTable graph;
    private final Listener selectionListener = new Listener(){

        public void handleEvent(Event evt) {
            RevCommit commit = (RevCommit)evt.data;
            SearchBar.this.lastObjectId = commit.getId();
            SearchBar.this.graph.selectCommit(commit);
        }
    };

    public SearchBar(String id, CommitGraphTable graph) {
        super(id);
        this.graph = graph;
    }

    protected FindToolbar createControl(Composite parent) {
        boolean hasInput;
        this.toolbar = new FindToolbar(parent);
        this.toolbar.setBackground(null);
        this.toolbar.addListener(24, e -> {
            String string = this.lastText = this.toolbar.getText();
        });
        this.toolbar.addSelectionListener(this.selectionListener);
        this.toolbar.addStatusListener(this::showStatus);
        boolean bl = hasInput = this.provider != null;
        if (hasInput) {
            this.setInput(this.provider);
        }
        if (this.lastText != null) {
            if (this.lastSearchContext != null && this.lastSearchContext.equals(this.searchContext)) {
                this.toolbar.setPreselect(this.lastObjectId);
            }
            this.toolbar.setText(this.lastText, hasInput);
        }
        this.lastSearchContext = null;
        this.lastObjectId = null;
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.toolbar);
        return this.toolbar;
    }

    public void setInput(ICommitsProvider provider) {
        this.provider = provider;
        if (this.toolbar != null) {
            this.searchContext = provider.getSearchContext();
            this.toolbar.setInput(provider.getHighlight(), this.graph.getTableView().getTable(), provider.getCommits());
        }
    }

    protected abstract void showStatus(FindToolbar var1, String var2);
}

