/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.ArrayWithCurlyFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class ArrayWithCurlyCleanUpCore
extends AbstractCleanUp {
    public ArrayWithCurlyCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public ArrayWithCurlyCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.array_with_curly");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.array_with_curly")) {
            return null;
        }
        return ArrayWithCurlyFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.array_with_curly")) {
            result.add(MultiFixMessages.ArrayWithCurlyCleanup_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.array_with_curly")) {
            return "double[] doubleArray = { 42.42 };\n";
        }
        return "double[] doubleArray = new double[] { 42.42 };\n";
    }
}

