/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.internal.target;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.PDEExtensionRegistry;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.launching.ext.AUTInformation;
import org.eclipse.rcptt.launching.ext.BundleStart;
import org.eclipse.rcptt.launching.ext.OriginalOrderProperties;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.launching.ext.StartLevelSupport;
import org.eclipse.rcptt.launching.injection.Directory;
import org.eclipse.rcptt.launching.injection.Entry;
import org.eclipse.rcptt.launching.injection.InjectionConfiguration;
import org.eclipse.rcptt.launching.injection.UpdateSite;
import org.eclipse.rcptt.launching.internal.target.PDEHelper;
import org.eclipse.rcptt.launching.internal.target.Q7Target;
import org.eclipse.rcptt.launching.p2utils.P2Utils;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;
import org.osgi.framework.BundleException;

public class TargetPlatformHelper
implements ITargetPlatformHelper {
    private static final boolean DEBUG = "true".equals(Platform.getDebugOption((String)"org.eclipse.rcptt.launching.ext/debug"));
    private static final boolean DEBUG_BUNDLES = "true".equals(Platform.getDebugOption((String)"org.eclipse.rcptt.launching.ext/debug/bundles"));
    public static final String IDE_APPLICATION = "org.eclipse.ui.ide.workbench";
    public static final String APPLICATION_PROPERTY = "eclipse.application";
    public static final String PRODUCT_PROPERTY = "eclipse.product";
    private static final String ID_PROPERTY = "id";
    private static final String OSGI_BUNDLES = "osgi.bundles";
    public static final String SIMPLECONFIGURATOR = "org.eclipse.equinox.simpleconfigurator";
    private static final String SC_BUNDLES_PATH = "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info";
    private MultiStatus status;
    private final ITargetDefinition target;
    private final ArrayList<ITargetLocation> extra = new ArrayList();
    private PDEExtensionRegistry registry;
    private Q7Target q7target = new Q7Target();
    private boolean resolved = false;
    private static final TreeMap<org.osgi.framework.Version, String> OBJECTWEB_INCOMPATIBILITY;
    private IPluginModelBase weavingHook;
    private final Multimap<String, IPluginModelBase> modelIndex = HashMultimap.create();
    private final Multimap<String, TargetBundle> targetBundleIndex = HashMultimap.create();
    private IFileArtifactRepository repository;
    private static final String GTK_VERSION = "--launcher.GTK_version";
    private static final String VMARGS = "-vmargs";
    private static final String VM = "-vm";
    private static final String VMARG_ADD_MODULES = "--add-modules";
    private static final String VMARG_PERMIT_ILLEGAL_ACCESS = "--permit-illegal-access";
    private static final String VMARG_ADD_OPENS = "--add-opens";
    private static final String VMARG_ALL_UNNAMED = "ALL-UNNAMED";
    private static final String INTERNAL_ARCH_I386 = "i386";
    private static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    private static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    private static final String PROP_CONFIG_CASCADED = "osgi.configuration.cascaded";
    public static final String VARIABLE_DELIM_STRING = "$";
    public static final char VARIABLE_DELIM_CHAR = '$';
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String PROP_OS = "osgi.os";
    private static final String PROP_WS = "osgi.ws";
    private static final String PROP_ARCH = "osgi.arch";
    private static final String CONFIG_DIR = "configuration/";
    private static final String CONFIG_FILE = "config.ini";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PROP_USER_DIR = "user.dir";
    private static final String FILE_SCHEME = "file:";

    static {
        TreeMap<org.osgi.framework.Version, String> oi = OBJECTWEB_INCOMPATIBILITY = new TreeMap();
        oi.put(org.osgi.framework.Version.valueOf((String)"9.6.0"), "JavaSE-23");
        oi.put(org.osgi.framework.Version.valueOf((String)"9.7.0"), "JavaSE-24");
        oi.put(org.osgi.framework.Version.valueOf((String)"9.7.1"), "JavaSE-25");
        oi.put(org.osgi.framework.Version.valueOf((String)"9.8.0"), "JavaSE-26");
    }

    public TargetPlatformHelper(ITargetDefinition target) {
        Preconditions.checkNotNull((Object)target);
        this.target = target;
        this.resetIndex();
        this.initialize();
    }

    @Override
    public Q7Target getQ7Target() {
        return this.q7target;
    }

    @Override
    public String getUserArea() {
        Q7Target.AutInstall install = this.getAutInstall();
        if (install == null) {
            return null;
        }
        return install.userArea;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    public boolean isInstanceContainerValid() {
        return this.getInstanceContainer() != null && this.getInstanceContainer().getStatus().isOK();
    }

    @Override
    public IStatus getStatus() {
        if (this.status == null) {
            return new Status(4, "org.eclipse.rcptt.launching.ext", "Target platform is unset");
        }
        return this.status;
    }

    @Override
    public Set<String> getIncompatibleExecutionEnvironments() {
        this.checkResolved();
        return this.modelIndex.get((Object)"org.objectweb.asm").stream().map(base -> base.getPluginBase().getVersion()).map(org.osgi.framework.Version::parseVersion).map(OBJECTWEB_INCOMPATIBILITY::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private IStatus getBundleStatus() {
        ITargetLocation[] containers = this.getBundleContainers();
        if (containers != null) {
            MultiStatus result = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_5, null);
            int i = 0;
            while (i < containers.length) {
                ITargetLocation container = containers[i];
                IStatus containerStatus = container.getStatus();
                if (containerStatus != null && !containerStatus.isOK()) {
                    result.add(containerStatus);
                }
                ++i;
            }
            if (!result.isOK()) {
                return result;
            }
            TargetBundle[] bundles = this.target.getBundles();
            int i2 = 0;
            while (i2 < bundles.length) {
                TargetBundle bundle = bundles[i2];
                if (!bundle.getStatus().isOK()) {
                    File file;
                    BundleInfo info = bundle.getBundleInfo();
                    URI uri = info.getLocation();
                    if (uri != null && !(file = new File(uri)).exists()) {
                        result.add(Status.warning((String)("Skip nonexistent bundle: " + info.getSymbolicName() + ", then resolve configuration.")));
                    } else {
                        result.add(bundle.getStatus());
                    }
                }
                ++i2;
            }
            if (result.isOK()) {
                return Status.OK_STATUS;
            }
            return result;
        }
        return Status.OK_STATUS;
    }

    private void initialize() {
        this.extra.clear();
        this.q7target = new Q7Target();
        if (this.target != null && this.target.getTargetLocations() != null) {
            ITargetLocation[] containers;
            ITargetLocation[] iTargetLocationArray = containers = this.target.getTargetLocations();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation iUBundleContainer = iTargetLocationArray[n2];
                if (iUBundleContainer instanceof ProfileBundleContainer) {
                    this.getQ7Target().setInstall(iUBundleContainer);
                }
                this.extra.add(iUBundleContainer);
                ++n2;
            }
        }
    }

    @Override
    public String getName() {
        if (this.target != null) {
            return this.target.getName();
        }
        return "";
    }

    @Override
    public void save() throws CoreException {
        if (!this.getStatus().isOK()) {
            throw new CoreException(this.getStatus());
        }
        TargetPlatformManager.deleteTargetPlatform(this.target.getName());
        try {
            ITargetPlatformService service = PDEHelper.getTargetService();
            service.saveTargetDefinition(this.target);
        }
        catch (CoreException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
    }

    @Override
    public String getTargetPlatformProfilePath() {
        ProfileBundleContainer container = this.getInstanceContainer();
        if (container == null) {
            return "";
        }
        try {
            return container.getLocation(true).toString();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete() {
        try {
            if (this.target != null && this.target.getHandle() != null) {
                PDEHelper.getTargetService().deleteTarget(this.target.getHandle());
            }
        }
        catch (CoreException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
    }

    public ITargetDefinition getTarget() {
        return this.target;
    }

    private void addLocations(Collection<ITargetLocation> newLocations) throws CoreException {
        this.resetIndex();
        ArrayList<Object> newContainers = new ArrayList<Object>();
        newContainers.addAll(newLocations);
        ITargetLocation[] targetLocations = this.target.getTargetLocations();
        List<Object> existingLocations = targetLocations != null ? Arrays.asList(targetLocations) : Collections.emptyList();
        for (ITargetLocation location : newLocations) {
            if (!existingLocations.contains(location)) continue;
            String str = location.getLocation(false);
            throw new IllegalStateException("Location " + str + " is already present in target platform");
        }
        newContainers.addAll(existingLocations);
        newContainers.addAll(newLocations);
        this.target.setTargetLocations(newContainers.toArray(new ITargetLocation[newContainers.size()]));
    }

    @Override
    public IPluginModelBase getWeavingHook() {
        this.checkResolved();
        return this.weavingHook;
    }

    private void computeModels(IProgressMonitor monitor) {
        this.modelIndex.clear();
        TargetBundle[] bundles = this.getTarget().getBundles();
        URI[] locations = (URI[])Arrays.stream(bundles).map(TargetBundle::getBundleInfo).map(BundleInfo::getLocation).toArray(URI[]::new);
        if (locations.length == 0) {
            throw new IllegalStateException("Target definition can't be empty");
        }
        this.createModels(monitor, locations).forEach(m -> {
            boolean bl = this.modelIndex.put((Object)m.getPluginBase().getId(), m);
        });
        if (DEBUG_BUNDLES) {
            ArrayList<String> targetModelsLocations = new ArrayList<String>();
            for (IPluginModelBase model : this.modelIndex.values()) {
                targetModelsLocations.add(model.getInstallLocation());
            }
            TargetPlatformHelper.debug("Bundles:\n" + String.join((CharSequence)"\n", targetModelsLocations));
        }
        this.weavingHook = null;
    }

    private Stream<IPluginModelBase> createModels(IProgressMonitor monitor, URI[] locations) {
        PDEState state = new PDEState(locations, true, true, monitor);
        return Arrays.stream(state.getTargetModels());
    }

    private void filterHooks() {
        this.weavingHook = null;
        List hooks = this.modelIndex.values().stream().filter(model -> Objects.equals(model.getBundleDescription().getSymbolicName(), "org.eclipse.equinox.weaving.hook")).collect(Collectors.toCollection(ArrayList::new));
        switch (hooks.size()) {
            case 0: {
                return;
            }
            case 1: {
                this.weavingHook = (IPluginModelBase)hooks.get(0);
                return;
            }
        }
        IPluginModelBase maxHook = (IPluginModelBase)hooks.get(0);
        int i = 1;
        while (i < hooks.size()) {
            IPluginModelBase hook = (IPluginModelBase)hooks.get(i);
            if (hook.getBundleDescription().getVersion().compareTo(maxHook.getBundleDescription().getVersion()) > 0) {
                maxHook = hook;
            }
            ++i;
        }
        hooks.remove(maxHook);
        this.modelIndex.values().removeAll(hooks);
        this.weavingHook = maxHook;
    }

    @Override
    public String[] getProducts() {
        PDEExtensionRegistry reg = this.getRegistry();
        TreeSet<String> result = new TreeSet<String>();
        IExtension[] extensions = reg.findExtensions("org.eclipse.core.runtime.products", false);
        int i = 0;
        while (i < extensions.length) {
            String id;
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            if (elements.length == 1 && "product".equals(elements[0].getName()) && (id = extensions[i].getUniqueIdentifier()) != null && id.trim().length() > 0) {
                result.add(id);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private void checkResolved() {
        if (!this.isResolved()) {
            throw new IllegalStateException("Unresolved");
        }
    }

    @Override
    public String[] getApplications() {
        PDEExtensionRegistry reg = this.getRegistry();
        TreeSet<String> result = new TreeSet<String>();
        IExtension[] extensions = reg.findExtensions("org.eclipse.core.runtime.applications", false);
        int i = 0;
        while (i < extensions.length) {
            String id = extensions[i].getUniqueIdentifier();
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            if (elements.length == 1) {
                boolean visible;
                String visiblity = elements[0].getAttribute("visible");
                boolean bl = visible = visiblity == null ? true : Boolean.valueOf(visiblity);
                if (id != null && visible) {
                    result.add(id);
                }
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private PDEExtensionRegistry getRegistry() {
        this.checkResolved();
        if (this.registry == null) {
            if (this.modelIndex.isEmpty()) {
                throw new IllegalStateException("Unresolved");
            }
            this.registry = new PDEExtensionRegistry(this.modelIndex.values().toArray(new IPluginModelBase[0]));
        }
        return this.registry;
    }

    @Override
    public IStatus resolve(IProgressMonitor monitor) {
        this.resetIndex();
        ITargetDefinition target = this.getTarget();
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)("Resolving " + this.getName()), (int)3);
        try {
            this.status.add(target.resolve((IProgressMonitor)m.split(1, 0)));
            if (this.isBad((IStatus)this.status)) {
                MultiStatus multiStatus = this.status;
                return multiStatus;
            }
            this.computeModels((IProgressMonitor)m.split(1, 0));
            this.setStartLevels(m.split(1, 0));
            this.status.add(this.getBundleStatus());
            this.index();
            this.filterHooks();
            this.resolved = target.isResolved();
            if (this.isBad((IStatus)this.status)) {
                MultiStatus multiStatus = this.status;
                return multiStatus;
            }
            if (this.status.isOK()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            MultiStatus multiStatus = this.status;
            return multiStatus;
        }
        catch (OperationCanceledException e) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            target.isResolved();
            this.status.add(Status.error((String)"Failed to resolve  target definition", (Throwable)e));
            MultiStatus multiStatus = this.status;
            return multiStatus;
        }
        finally {
            IProgressMonitor.done((IProgressMonitor)monitor);
        }
    }

    private void index() {
        Arrays.stream(this.target.getBundles()).forEach(bundle -> {
            boolean bl = this.targetBundleIndex.put((Object)bundle.getBundleInfo().getSymbolicName(), bundle);
        });
        this.targetBundleIndex.removeAll(null);
    }

    private void resetIndex() {
        this.status = new MultiStatus(TargetPlatformHelper.class, 0, "Target platform resolution result");
        this.resolved = false;
        this.modelIndex.clear();
        this.targetBundleIndex.clear();
        this.registry = null;
    }

    @Override
    public Stream<ITargetPlatformHelper.Model> getModels() {
        this.checkResolved();
        return this.modelIndex.values().stream().map(this::toModel);
    }

    Q7Target.AutInstall getAutInstall() {
        Q7Target target = this.getQ7Target();
        if (target == null) {
            return null;
        }
        return target.getInstall();
    }

    @Override
    public OriginalOrderProperties getConfigIniProperties() {
        Q7Target.AutInstall autInstall = this.getAutInstall();
        if (autInstall == null) {
            return new OriginalOrderProperties();
        }
        return autInstall.getConfig();
    }

    protected String getEclipseProductFileProperty(String name) {
        Properties props = this.getEclipseProductFileProperties();
        return props == null ? null : props.getProperty(name);
    }

    public Properties getEclipseProductFileProperties() {
        File iniFile = new File(this.getTargetPlatformProfilePath(), PRODUCT_SITE_MARKER);
        if (!iniFile.exists()) {
            return null;
        }
        Properties pini = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream fis = new FileInputStream(iniFile);){
                pini.load(fis);
                fis.close();
                return pini;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
            return null;
        }
    }

    @Override
    public String getDefaultApplication() {
        String app = this.getConfigIniProperty(APPLICATION_PROPERTY);
        TargetPlatformHelper.debug("Application from config.ini: " + app);
        HashSet<String> apps = new HashSet<String>(Arrays.asList(this.getApplications()));
        TargetPlatformHelper.debug("Valid applications: " + String.valueOf(apps));
        return this.isValidId(app, apps) ? app : (this.isValidId(IDE_APPLICATION, apps) ? IDE_APPLICATION : null);
    }

    public String getBundlesList() {
        String bundles = this.getConfigIniProperty(OSGI_BUNDLES);
        return bundles == null ? org.eclipse.pde.internal.core.TargetPlatformHelper.getDefaultBundleList() : org.eclipse.pde.internal.core.TargetPlatformHelper.stripPathInformation((String)bundles);
    }

    protected String getConfigIniProperty(String name) {
        OriginalOrderProperties config = this.getConfigIniProperties();
        if (config == null) {
            return null;
        }
        return config.getProperty(name);
    }

    protected boolean isValidId(String id, Set<String> available) {
        return id == null ? false : available.contains(id);
    }

    @Override
    public String getDefaultProduct() {
        HashSet<String> values = new HashSet<String>(Arrays.asList(this.getProducts()));
        TargetPlatformHelper.debug("Valid products: " + String.valueOf(values));
        String product = null;
        String productProperty = this.getConfigIniProperty(PRODUCT_PROPERTY);
        if (this.isValidId(productProperty, values)) {
            product = productProperty;
        }
        TargetPlatformHelper.debug("eclipse.product from config.ini: " + productProperty);
        productProperty = this.getEclipseProductFileProperty("id");
        if (this.isValidId(productProperty, values)) {
            product = productProperty;
        }
        TargetPlatformHelper.debug("id from config.ini: " + productProperty);
        List<File> iniFiles = this.getAppIniFiles();
        for (File file : iniFiles) {
            productProperty = this.readProductFromIniFile(file);
            if (this.isValidId(productProperty, values)) {
                product = productProperty;
            }
            TargetPlatformHelper.debug("Product from " + String.valueOf(file) + ": " + productProperty);
        }
        return product;
    }

    private ITargetLocation[] getBundleContainers() {
        if (this.target == null) {
            return new ITargetLocation[0];
        }
        ITargetLocation[] bundleContainers = this.target.getTargetLocations();
        if (bundleContainers == null) {
            return new ITargetLocation[0];
        }
        return bundleContainers;
    }

    @Override
    public IStatus applyInjection(InjectionConfiguration configuration, IProgressMonitor monitor) {
        EList entries = configuration.getEntries();
        ArrayList<ITargetLocation> additionalLocations = new ArrayList<ITargetLocation>();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)"Apply injection plugins", (int)(20 + entries.size() * 20));
        for (Entry entry : entries) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Status result = new Status(4, "org.eclipse.rcptt.launching.ext", "Unknown injection type: " + entry.getClass().getName());
            if (entry instanceof UpdateSite) {
                result = TargetPlatformHelper.processUpdateSite((IProgressMonitor)sm.newChild(20), (UpdateSite)entry, additionalLocations::add);
            } else if (entry instanceof Directory) {
                result = TargetPlatformHelper.processDirectory((Directory)entry, additionalLocations::add);
            }
            if (!result.matches(12)) continue;
            return result;
        }
        try {
            this.addLocations(additionalLocations);
        }
        catch (CoreException e1) {
            return e1.getStatus();
        }
        IStatus resolveStatus = this.resolve((IProgressMonitor)sm.split(20, 0));
        if (!resolveStatus.isOK()) {
            return resolveStatus;
        }
        if (this.getWeavingHook() == null) {
            this.status.add(TargetPlatformHelper.createError("No org.eclipse.weaving hook plugin"));
            return this.status;
        }
        try {
            this.save();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private static IStatus processDirectory(Directory entry, Consumer<ITargetLocation> collector) {
        String path = entry.getPath();
        MultiStatus rv = new MultiStatus("org.eclipse.rcptt.launching.ext", 0, "Processing " + path, null);
        if (path.startsWith("platform:///")) {
            try {
                URL resolve = FileLocator.resolve((URL)URI.create(path).toURL());
                path = resolve.getPath();
            }
            catch (MalformedURLException e) {
                rv.add((IStatus)new Status(2, "org.eclipse.rcptt.launching.ext", e.getMessage(), (Throwable)e));
            }
            catch (IOException e) {
                rv.add((IStatus)new Status(2, "org.eclipse.rcptt.launching.ext", e.getMessage(), (Throwable)e));
            }
        }
        ITargetLocation container = PDEHelper.getTargetService().newDirectoryLocation(path);
        collector.accept(container);
        return Status.OK_STATUS;
    }

    private static final IStatus createError(String message) {
        return TargetPlatformHelper.createError(message, null);
    }

    private static final IStatus createError(String message, Throwable error) {
        if (message == null && error != null) {
            message = error.getMessage();
        }
        return new Status(4, "org.eclipse.rcptt.launching.ext", message, error);
    }

    private static IStatus processUpdateSite(IProgressMonitor monitor, UpdateSite site, Consumer<ITargetLocation> collector) {
        try {
            URI uri = URI.create(Platform.getOS().equals("win32") ? site.getUri().replace('\\', '/') : site.getUri());
            IMetadataRepository repository = PDEHelper.safeLoadRepository(uri, monitor);
            IArtifactRepository artifactRepository = PDEHelper.safeLoadArtifactRepository(uri, monitor);
            if (repository == null || artifactRepository == null) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return TargetPlatformHelper.createError("Failed to load update site:" + String.valueOf(uri));
            }
            ArrayList unitsToInstall = new ArrayList();
            IQuery finalQuery = P2Utils.createQuery((UpdateSite)site);
            IQueryResult result = repository.query(finalQuery, monitor);
            Set availableUnits = result.toSet();
            if (site.isAllUnits()) {
                unitsToInstall.addAll(availableUnits);
            } else {
                P2Utils.expandFeatures((IProgressMonitor)monitor, (IMetadataRepository)repository, (Set)availableUnits);
                Set unitIDs = P2Utils.mapUnitsToId((Set)availableUnits);
                HashSet missingUnits = new HashSet(site.getUnits());
                missingUnits.removeAll(unitIDs);
                if (!missingUnits.isEmpty()) {
                    return TargetPlatformHelper.createError("Few units are not available:" + Arrays.toString(missingUnits.toArray()));
                }
                unitsToInstall.addAll(availableUnits);
            }
            if (unitsToInstall.size() > 0) {
                IInstallableUnit[] unitsAsArray = unitsToInstall.toArray(new IInstallableUnit[unitsToInstall.size()]);
                URI[] uriArray = new URI[]{uri};
                ITargetLocation container = PDEHelper.getTargetService().newIULocation(unitsAsArray, uriArray, 2);
                collector.accept(container);
            }
            IFileArtifactRepository filesRepository = P2TargetUtils.getBundlePool();
            ArrayList toInstall = new ArrayList();
            toInstall.addAll(unitsToInstall);
            P2Utils.installUnits((IProgressMonitor)monitor, (IArtifactRepository)artifactRepository, (IFileArtifactRepository)filesRepository, toInstall, (int)10, null, (boolean)false, (IProvisioningAgent)P2Utils.getProvisioningAgent());
            MultiStatus rv = new MultiStatus("org.eclipse.rcptt.launching.ext", 0, "Failed to install next units from repository: " + repository.getName(), null);
            if (toInstall.size() > 0) {
                for (IInstallableUnit u : toInstall) {
                    rv.add(TargetPlatformHelper.createError(u.getId()));
                }
                return rv;
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    @Override
    public Map<String, String> getIniEnvironment() {
        List<File> iniFiles = this.getAppIniFiles();
        HashMap<String, String> result = new HashMap<String, String>();
        for (File file : iniFiles) {
            Map<String, String> envs = this.readEnvironmentFromIniFile(file);
            if (envs == null) continue;
            result.putAll(envs);
        }
        return result;
    }

    @Override
    public String getIniVMArgs() {
        List<File> iniFiles = this.getAppIniFiles();
        for (File file : iniFiles) {
            String vmArgs = this.readVMArgsFromIniFile(file);
            if (vmArgs == null) continue;
            return vmArgs;
        }
        return null;
    }

    private List<File> getAppIniFiles() {
        File eclipseIniFile;
        int n;
        ArrayList<File> iniFiles = new ArrayList<File>();
        if (this.getInstanceContainer() == null) {
            return iniFiles;
        }
        File installDirectory = new File(this.getTargetPlatformProfilePath());
        if (!installDirectory.exists()) {
            return iniFiles;
        }
        if (Platform.getOS().equals("macosx")) {
            File[] listFiles;
            File[] fileArray = listFiles = installDirectory.listFiles();
            n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().contains(".app")) {
                    installDirectory = new File(file, "/Contents/MacOS");
                    break;
                }
                ++n2;
            }
        }
        if ((eclipseIniFile = new File(installDirectory, "eclipse.ini")).exists()) {
            iniFiles.add(eclipseIniFile);
            return iniFiles;
        }
        File[] list = installDirectory.listFiles();
        if (list != null) {
            File[] fileArray = list;
            int n3 = list.length;
            n = 0;
            while (n < n3) {
                File file = fileArray[n];
                if (file.getName().endsWith(".ini")) {
                    iniFiles.add(file);
                }
                ++n;
            }
        }
        return iniFiles;
    }

    private String readProductFromIniFile(File eclipseIniFile) {
        if (!eclipseIniFile.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = new BufferedReader(new FileReader(eclipseIniFile));){
                String str;
                while ((str = in.readLine()) != null) {
                    String product;
                    if (!str.trim().equals("-product") || (product = in.readLine()) == null) continue;
                    return product.trim();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
        return null;
    }

    private List<String> parseIniFile(File eclipseIni) {
        if (eclipseIni == null || !eclipseIni.exists()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Stream<String> lines = Files.lines(eclipseIni.toPath(), StandardCharsets.UTF_8);){
                for (String line : lines::iterator) {
                    if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                    result.add(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
        return result;
    }

    private String getVmArg(File eclipseIniFile) {
        List<String> lines = this.parseIniFile(eclipseIniFile);
        int vmIndex = lines.indexOf(VM) + 1;
        return vmIndex == 0 || vmIndex == lines.size() ? null : lines.get(vmIndex);
    }

    @Override
    public Optional<Path> getJavaHome() {
        for (File iniFile : this.getAppIniFiles()) {
            String result = this.getVmArg(iniFile);
            if (result == null) continue;
            Path iniPath = iniFile.toPath().toAbsolutePath();
            Path vmPath = Paths.get(result, new String[0]);
            if (!vmPath.isAbsolute()) {
                vmPath = iniPath.getParent().resolve(vmPath);
            }
            if (!Files.exists(vmPath, new LinkOption[0])) continue;
            String dirName = vmPath.getParent().getFileName().toString();
            if ("bin".equals(dirName) || "lib".equals(dirName)) {
                vmPath = vmPath.getParent().getParent();
            } else if ("bin".equals(vmPath.getFileName().toString())) {
                vmPath = vmPath.getParent();
            }
            return Optional.of(vmPath);
        }
        return Optional.empty();
    }

    private Map<String, String> readEnvironmentFromIniFile(File eclipseIniFile) {
        if (!eclipseIniFile.exists()) {
            return null;
        }
        List<String> lines = this.parseIniFile(eclipseIniFile);
        HashMap<String, String> envs = new HashMap<String, String>();
        int gtkVersionIdx = lines.indexOf(GTK_VERSION);
        if (gtkVersionIdx != -1 && Platform.getOS().equals("linux")) {
            String gtkVersion = lines.get(gtkVersionIdx + 1);
            if ("2".equals(gtkVersion)) {
                envs.put("SWT_GTK3", "0");
            } else {
                envs.put("SWT_GTK3", "1");
            }
        }
        return envs;
    }

    private String readVMArgsFromIniFile(File eclipseIniFile) {
        if (!eclipseIniFile.exists()) {
            return null;
        }
        List<String> lines = this.parseIniFile(eclipseIniFile);
        int vmargsIndex = lines.indexOf(VMARGS);
        if (vmargsIndex == -1) {
            return null;
        }
        int vmIndex = (lines = lines.subList(vmargsIndex + 1, lines.size())).indexOf(VM);
        if (vmIndex != -1) {
            lines.subList(vmIndex, Math.min(vmIndex + 2, lines.size())).clear();
        }
        if (lines.isEmpty()) {
            return null;
        }
        this.removeUnsupportedVMArgs(lines);
        this.addUnresolvedVMArgs(lines);
        return Q7LaunchDelegateUtils.joinCommandArgs(lines);
    }

    private void removeUnsupportedVMArgs(List<String> lines) {
        String[] javaVersions = TargetPlatformHelper.getJavaVersions();
        if (TargetPlatformHelper.getMajorVersion(javaVersions) == 1 && TargetPlatformHelper.getMinorVersion(javaVersions) < 9 || TargetPlatformHelper.getMajorVersion(javaVersions) < 9) {
            Iterator<String> iterator = lines.iterator();
            while (iterator.hasNext()) {
                String line = iterator.next();
                if (!line.startsWith(VMARG_ADD_MODULES) && !line.startsWith(VMARG_PERMIT_ILLEGAL_ACCESS) && !line.startsWith(VMARG_ADD_OPENS)) continue;
                iterator.remove();
            }
        }
    }

    private void addUnresolvedVMArgs(List<String> lines) {
        int startIndex = lines.indexOf(VMARG_ADD_OPENS);
        if (startIndex != -1) {
            int i = startIndex;
            while (i < lines.size()) {
                if (lines.get(i).contains(VMARG_ALL_UNNAMED) && !lines.get(i - 1).startsWith(VMARG_ADD_OPENS)) {
                    lines.add(i, VMARG_ADD_OPENS);
                }
                ++i;
            }
        }
    }

    private static String[] getJavaVersions() {
        String javaVersion = System.getProperty("java.version");
        return javaVersion.split("\\.|-");
    }

    private static int getMajorVersion(String[] versions) {
        if (versions.length < 1) {
            return 0;
        }
        try {
            return Integer.valueOf(versions[0]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static int getMinorVersion(String[] versions) {
        if (versions.length < 2) {
            return 0;
        }
        try {
            return Integer.valueOf(versions[1]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public String getTemplateConfigLocation() {
        File iniFile = new File(this.getTargetPlatformProfilePath(), "configuration/config.ini");
        if (!iniFile.exists()) {
            return null;
        }
        return iniFile.getAbsolutePath();
    }

    @Override
    public OSArchitecture detectArchitecture(StringBuilder detectMsg) {
        this.checkResolved();
        String architecture = this.target.getArch();
        if (architecture != null) {
            return OSArchitecture.valueOf(architecture);
        }
        String os = Platform.getOS();
        Pattern archPattern = Pattern.compile(("org.eclipse.equinox.launcher.[\\w\\d]+." + os + ".([^.]+)$").replace(".", "\\."));
        Set launcherArchitectures = this.targetBundleIndex.keySet().stream().map(name -> this.getGroup((String)name, archPattern)).flatMap(Optional::stream).collect(Collectors.toSet());
        if (launcherArchitectures.size() != 1) {
            if (detectMsg != null) {
                detectMsg.append("Multiple launcher architectures are found in target platform: " + Joiner.on((String)", ").join(launcherArchitectures));
            }
            return OSArchitecture.Unknown;
        }
        String name2 = (String)launcherArchitectures.iterator().next();
        OSArchitecture result = OSArchitecture.valueOf(name2);
        if (detectMsg != null) {
            detectMsg.append((Object)result).append(" arch detected");
        }
        return result;
    }

    private Map<String, BundleStart> getRunlevelsFromSimpleConfigurator() throws IOException {
        HashMap<String, BundleStart> result = new HashMap<String, BundleStart>();
        if (this.getTargetPlatformProfilePath() == null) {
            return result;
        }
        File infoFile = new File(this.getTargetPlatformProfilePath(), SC_BUNDLES_PATH);
        if (!infoFile.exists()) {
            return result;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream input = new FileInputStream(infoFile);){
            for (org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo bi : SimpleConfiguratorUtils.readConfiguration((InputStream)input, (URI)infoFile.toURI())) {
                String name = bi.getSymbolicName();
                if (name == null) continue;
                result.put(name, BundleStart.fromBundle(new BundleInfo(bi.getLocation(), bi.getStartLevel(), bi.isMarkedAsStarted())));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private Map<String, BundleStart> getRunlevelsMap() throws IOException {
        Q7Target.AutInstall install;
        HashMap<String, BundleStart> result = new HashMap<String, BundleStart>();
        String osgiBundles = this.getConfigIniProperty(OSGI_BUNDLES);
        if (osgiBundles != null) {
            if (osgiBundles.contains(SIMPLECONFIGURATOR)) {
                result.putAll(this.getRunlevelsFromSimpleConfigurator());
            } else {
                StringTokenizer tokenizer = new StringTokenizer(osgiBundles, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    int index = token.indexOf(64);
                    if (index == -1) continue;
                    String id = token.substring(0, index);
                    String tk = token.substring(index + 1);
                    result.put(id, BundleStart.fromOsgiString(tk));
                }
            }
        }
        if ((install = this.getAutInstall()) != null) {
            result.putAll(install.configIniBundles());
        }
        return result;
    }

    @Override
    public String getRuntimeVersion() {
        if (this.target != null && this.target.isResolved()) {
            Object version = "";
            org.osgi.framework.Version runtimeBundle = this.getBundleVersion("org.eclipse.rcptt.tesla.swt");
            if (runtimeBundle != null) {
                version = runtimeBundle.toString();
                if (runtimeBundle.getQualifier().equals("qualifier")) {
                    version = (String)version + System.currentTimeMillis();
                }
            }
            return version;
        }
        return "unknown";
    }

    private org.osgi.framework.Version getBundleVersion(String name) {
        if (this.target != null && this.target.isResolved()) {
            ITargetLocation[] containers;
            ITargetLocation[] iTargetLocationArray = containers = this.target.getTargetLocations();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation iBundleContainer = iTargetLocationArray[n2];
                TargetBundle[] bundles = iBundleContainer.getBundles();
                if (bundles != null) {
                    TargetBundle[] targetBundleArray = bundles;
                    int n3 = bundles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TargetBundle iResolvedBundle = targetBundleArray[n4];
                        BundleInfo info = iResolvedBundle.getBundleInfo();
                        if (Objects.equals(info.getSymbolicName(), name)) {
                            return new org.osgi.framework.Version(info.getVersion());
                        }
                        ++n4;
                    }
                }
                if (iBundleContainer instanceof IUBundleContainer) {
                    IUBundleContainer ct = (IUBundleContainer)iBundleContainer;
                    try {
                        Field ids = IUBundleContainer.class.getDeclaredField("fIds");
                        Field versions = IUBundleContainer.class.getDeclaredField("fVersions");
                        ids.setAccessible(true);
                        versions.setAccessible(true);
                        String[] idsValue = (String[])ids.get(ct);
                        Version[] versionsValue = (Version[])versions.get(ct);
                        int i = 0;
                        while (i < idsValue.length) {
                            String n5 = idsValue[i];
                            if (n5 != null && n5.equals(name)) {
                                return new org.osgi.framework.Version(versionsValue[i].toString());
                            }
                            ++i;
                        }
                    }
                    catch (Throwable e) {
                        Q7ExtLaunchingPlugin.status("Failed to check runtime version", e);
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String getEquinoxStartupPath(String packageName) {
        this.checkResolved();
        for (IPluginModelBase plugin : this.modelIndex.values()) {
            String location;
            if (!plugin.getPluginBase().getId().equals(packageName) || !new File(location = plugin.getInstallLocation()).isFile()) continue;
            return location;
        }
        return null;
    }

    ProfileBundleContainer getInstanceContainer() {
        Q7Target.AutInstall install = this.getAutInstall();
        if (install == null) {
            return null;
        }
        return install.container;
    }

    public void setBundleContainers(ITargetLocation[] containers) {
        this.target.setTargetLocations(containers);
        this.initialize();
    }

    public String toString() {
        return (this.getName() == null ? "No name" : this.getName()) + " " + this.getTargetPlatformProfilePath();
    }

    @Override
    public Map<String, Version> getVersions() throws CoreException {
        this.checkResolved();
        return AUTInformation.getInformationMap(this.target);
    }

    public static OriginalOrderProperties processConfiguration(Q7Target.AutInstall autInstall) {
        URL baseConfigurationLocation = null;
        OriginalOrderProperties baseConfiguration = null;
        String location = null;
        if (baseConfigurationLocation == null) {
            try {
                baseConfigurationLocation = new URL(autInstall.getInstallLocationURL(), CONFIG_DIR);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((baseConfiguration = TargetPlatformHelper.loadConfiguration(baseConfigurationLocation)) != null) {
            location = baseConfiguration.getProperty(PROP_CONFIG_AREA);
        }
        OriginalOrderProperties configuration = baseConfiguration;
        URL configUrl = TargetPlatformHelper.getConfigurationLocation(location, autInstall.getInstallLocation());
        if (configuration == null || !configUrl.equals(baseConfigurationLocation)) {
            configuration = TargetPlatformHelper.loadConfiguration(configUrl);
        }
        if (configuration == null) {
            Q7ExtLaunchingPlugin.getDefault().info("File config.ini from folder \"" + String.valueOf(configUrl) + "\" was not read");
            return baseConfiguration;
        }
        String configurationArea = configUrl.getFile();
        int index = configurationArea.lastIndexOf("/");
        if (index == configurationArea.length() - 1) {
            configurationArea = configurationArea.substring(0, index);
            index = configurationArea.lastIndexOf("/");
        }
        autInstall.userArea = configurationArea.substring(0, index + 1);
        if ("false".equalsIgnoreCase(configuration.getProperty(PROP_CONFIG_CASCADED))) {
            configuration.remove(PROP_SHARED_CONFIG_AREA);
            return configuration;
        }
        URL sharedConfigURL = TargetPlatformHelper.buildLocation(configuration.getProperty(PROP_SHARED_CONFIG_AREA), null, "", autInstall.getInstallLocation().getAbsolutePath());
        if (sharedConfigURL == null) {
            try {
                sharedConfigURL = new URL(autInstall.getInstallLocationURL(), CONFIG_DIR);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (sharedConfigURL != null) {
            if (sharedConfigURL.equals(configUrl)) {
                return configuration;
            }
            OriginalOrderProperties sharedConfiguration = baseConfiguration;
            if (!sharedConfigURL.equals(baseConfigurationLocation)) {
                sharedConfiguration = TargetPlatformHelper.loadConfiguration(sharedConfigURL);
            }
            configuration.remove(PROP_SHARED_CONFIG_AREA);
            return TargetPlatformHelper.mergeProperties(sharedConfiguration, configuration);
        }
        return null;
    }

    private static OriginalOrderProperties loadConfiguration(URL url) {
        OriginalOrderProperties result = null;
        try {
            url = new URL(url, CONFIG_FILE);
        }
        catch (MalformedURLException e) {
            return result;
        }
        try {
            if (url != null) {
                result = OriginalOrderProperties.load(url);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return TargetPlatformHelper.substituteVars(result);
    }

    private static OriginalOrderProperties substituteVars(OriginalOrderProperties result) {
        if (result == null) {
            return null;
        }
        Enumeration<Object> eKeys = result.keys();
        while (eKeys.hasMoreElements()) {
            String value;
            Object key = eKeys.nextElement();
            if (!(key instanceof String) || (value = result.getProperty((String)key)) == null) continue;
            result.put(key, TargetPlatformHelper.substituteVars(value));
        }
        return result;
    }

    private static String substituteVars(String path) {
        StringBuffer buf = new StringBuffer(path.length());
        StringTokenizer st = new StringTokenizer(path, VARIABLE_DELIM_STRING, true);
        boolean varStarted = false;
        String var = null;
        while (st.hasMoreElements()) {
            String tok = st.nextToken();
            if (VARIABLE_DELIM_STRING.equals(tok)) {
                if (!varStarted) {
                    varStarted = true;
                    var = "";
                    continue;
                }
                String prop = null;
                if (var != null && var.length() > 0) {
                    prop = System.getProperty(var);
                }
                if (prop == null) {
                    try {
                        Method getenv = System.class.getMethod("getenv", String.class);
                        prop = (String)getenv.invoke(null, var);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (prop != null) {
                    buf.append(prop);
                } else {
                    buf.append('$');
                    buf.append(var == null ? "" : var);
                    buf.append('$');
                }
                varStarted = false;
                var = null;
                continue;
            }
            if (!varStarted) {
                buf.append(tok);
                continue;
            }
            var = tok;
        }
        if (var != null) {
            buf.append('$').append(var);
        }
        return buf.toString();
    }

    private static URL getConfigurationLocation(String configurationArea, File installLocation) {
        URL configurationLocation = TargetPlatformHelper.buildLocation(configurationArea, null, "", installLocation.getAbsolutePath());
        if (configurationLocation == null) {
            configurationLocation = TargetPlatformHelper.buildURL(TargetPlatformHelper.computeDefaultConfigurationLocation(installLocation), true, installLocation.getAbsolutePath());
        }
        return configurationLocation;
    }

    private static URL buildLocation(String location, URL defaultLocation, String userDefaultAppendage, String installArea) {
        URL result = null;
        if (location == null) {
            result = defaultLocation;
        } else {
            if (location.equalsIgnoreCase(NONE)) {
                return null;
            }
            if (location.equalsIgnoreCase(NO_DEFAULT)) {
                result = TargetPlatformHelper.buildURL(location, true, installArea);
            } else {
                if (location.startsWith(USER_HOME)) {
                    String base = TargetPlatformHelper.substituteVar(location, USER_HOME, PROP_USER_HOME);
                    location = new File(base, userDefaultAppendage).getAbsolutePath();
                } else if (location.startsWith(USER_DIR)) {
                    String base = TargetPlatformHelper.substituteVar(location, USER_DIR, PROP_USER_DIR);
                    location = new File(base, userDefaultAppendage).getAbsolutePath();
                }
                result = TargetPlatformHelper.buildURL(location, true, installArea);
            }
        }
        return result;
    }

    private static String substituteVar(String source, String var, String prop) {
        String value = System.getProperty(prop, "");
        return value + source.substring(var.length());
    }

    public static URL buildURL(String spec, boolean trailingSlash, String installArea) {
        if (spec == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            spec = spec.trim();
        }
        boolean isFile = spec.startsWith(FILE_SCHEME);
        try {
            if (isFile) {
                File toAdjust = new File(spec.substring(5));
                if ((toAdjust = TargetPlatformHelper.resolveFile(toAdjust, installArea)).isDirectory()) {
                    return TargetPlatformHelper.adjustTrailingSlash(toAdjust.toURI().toURL(), trailingSlash);
                }
                return toAdjust.toURI().toURL();
            }
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            if (isFile) {
                return null;
            }
            try {
                File toAdjust = new File(spec);
                if (toAdjust.isDirectory()) {
                    return TargetPlatformHelper.adjustTrailingSlash(toAdjust.toURI().toURL(), trailingSlash);
                }
                return toAdjust.toURI().toURL();
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    private static File resolveFile(File toAdjust, String installArea) {
        if (!toAdjust.isAbsolute() && installArea != null) {
            if (installArea.startsWith(FILE_SCHEME)) {
                toAdjust = new File(installArea.substring(5), toAdjust.getPath());
            } else if (new File(installArea).exists()) {
                toAdjust = new File(installArea, toAdjust.getPath());
            }
        }
        return toAdjust;
    }

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        Object file = url.getFile();
        if (trailingSlash == ((String)file).endsWith("/")) {
            return url;
        }
        file = trailingSlash ? (String)file + "/" : ((String)file).substring(0, ((String)file).length() - 1);
        return new URL(url.getProtocol(), url.getHost(), (String)file);
    }

    private static String computeDefaultConfigurationLocation(File installLocation) {
        String configurationLocation = null;
        configurationLocation = TargetPlatformHelper.canWrite(installLocation) ? installLocation.getAbsolutePath() : TargetPlatformHelper.computeDefaultUserAreaLocation(installLocation);
        return configurationLocation + File.separator + CONFIG_DIR;
    }

    private static boolean canWrite(File installDir) {
        if (!installDir.canWrite()) {
            return false;
        }
        if (!installDir.isDirectory()) {
            return false;
        }
        File fileTest = null;
        try {
            try {
                fileTest = File.createTempFile("writableArea", ".dll", installDir);
            }
            catch (IOException e) {
                if (fileTest != null) {
                    fileTest.delete();
                }
                return false;
            }
        }
        finally {
            if (fileTest != null) {
                fileTest.delete();
            }
        }
        return true;
    }

    private static String computeDefaultUserAreaLocation(File installDir) {
        String installDirHash = TargetPlatformHelper.getInstallDirHash(installDir);
        Object appName = ".eclipse";
        File eclipseProduct = new File(installDir, PRODUCT_SITE_MARKER);
        if (eclipseProduct.exists()) {
            Properties props = new Properties();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream is = new FileInputStream(eclipseProduct);){
                    String appVersion;
                    props.load(is);
                    String appId = props.getProperty("id");
                    if (appId == null || appId.trim().length() == 0) {
                        appId = ECLIPSE;
                    }
                    if ((appVersion = props.getProperty(PRODUCT_SITE_VERSION)) == null || appVersion.trim().length() == 0) {
                        appVersion = "";
                    }
                    appName = (String)appName + File.separator + appId + "_" + appVersion + "_" + installDirHash;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                appName = (String)appName + File.separator + installDirHash;
            }
        } else {
            appName = (String)appName + File.separator + installDirHash;
        }
        appName = (String)appName + "_" + TargetPlatformHelper.OS_WS_ARCHToString();
        String userHome = System.getProperty(PROP_USER_HOME);
        return new File(userHome, (String)appName).getAbsolutePath();
    }

    private static String OS_WS_ARCHToString() {
        return TargetPlatformHelper.getOS() + "_" + TargetPlatformHelper.getWS() + "_" + TargetPlatformHelper.getArch();
    }

    private static String getWS() {
        String osgiWs = System.getProperty(PROP_WS);
        if (osgiWs != null) {
            return osgiWs;
        }
        String osName = TargetPlatformHelper.getOS();
        if (osName.equals("win32")) {
            return "win32";
        }
        if (osName.equals("linux")) {
            return "gtk";
        }
        if (osName.equals("macosx")) {
            return "cocoa";
        }
        if (osName.equals("hpux")) {
            return "gtk";
        }
        if (osName.equals("aix")) {
            return "gtk";
        }
        if (osName.equals("solaris")) {
            return "gtk";
        }
        if (osName.equals("qnx")) {
            return "photon";
        }
        return "unknown";
    }

    private static String getOS() {
        String osgiOs = System.getProperty(PROP_OS);
        if (osgiOs != null) {
            return osgiOs;
        }
        String osName = System.getProperties().getProperty("os.name");
        if (osName.regionMatches(true, 0, "win32", 0, 3)) {
            return "win32";
        }
        if (osName.equalsIgnoreCase("SunOS")) {
            return "solaris";
        }
        if (osName.equalsIgnoreCase("Linux")) {
            return "linux";
        }
        if (osName.equalsIgnoreCase("QNX")) {
            return "qnx";
        }
        if (osName.equalsIgnoreCase("AIX")) {
            return "aix";
        }
        if (osName.equalsIgnoreCase("HP-UX")) {
            return "hpux";
        }
        if (osName.equalsIgnoreCase("OS/400")) {
            return "os/400";
        }
        if (osName.equalsIgnoreCase("OS/390")) {
            return "os/390";
        }
        if (osName.equalsIgnoreCase("z/OS")) {
            return "z/os";
        }
        if (osName.regionMatches(true, 0, "Mac OS", 0, "Mac OS".length())) {
            return "macosx";
        }
        return "unknown";
    }

    private static String getArch() {
        String osgiArch = System.getProperty(PROP_ARCH);
        if (osgiArch != null) {
            return osgiArch;
        }
        String name = System.getProperties().getProperty("os.arch");
        if (name.equalsIgnoreCase(INTERNAL_ARCH_I386)) {
            return "x86";
        }
        if (name.equalsIgnoreCase("amd64")) {
            return "x86_64";
        }
        return name;
    }

    private static String getInstallDirHash(File installDir) {
        int hashCode;
        try {
            hashCode = installDir.getCanonicalPath().hashCode();
        }
        catch (IOException ioe) {
            hashCode = installDir.getAbsolutePath().hashCode();
        }
        if (hashCode < 0) {
            hashCode = -hashCode;
        }
        String installDirHash = String.valueOf(hashCode);
        return installDirHash;
    }

    private static OriginalOrderProperties mergeProperties(OriginalOrderProperties source, OriginalOrderProperties userConfiguration) {
        if (userConfiguration != null) {
            source.setBeginAdd(true);
            source.putAll((Map<?, ?>)userConfiguration);
        }
        return source;
    }

    private static void debug(String message) {
        if (DEBUG) {
            Q7ExtLaunchingPlugin.getDefault().info(message);
        }
    }

    private void setStartLevels(SubMonitor monitor) throws IOException, BundleException {
        Map<String, BundleStart> levelMap = this.getRunlevelsMap();
        if (!this.target.isResolved()) {
            throw new IllegalStateException("Target definition is unresolved");
        }
        TargetBundle[] bundles = this.target.getBundles();
        monitor.beginTask("Setting bundle start levels", bundles.length);
        TargetBundle[] targetBundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            TargetBundle bundle = targetBundleArray[n2];
            BundleInfo bundleInfo = bundle.getBundleInfo();
            String location = bundleInfo.getLocation().toString();
            monitor.subTask(location);
            try {
                BundleStart bundleLevel = levelMap.getOrDefault(bundleInfo.getSymbolicName(), BundleStart.DEFAULT);
                String manifest = bundleInfo.getManifest();
                if (manifest != null) {
                    bundleLevel = StartLevelSupport.getStartInfo(manifest, bundleLevel);
                }
                monitor.split(1);
                if (!bundleLevel.isDefault()) {
                    bundleInfo.setStartLevel(bundleLevel.level);
                    bundleInfo.setMarkedAsStarted(bundleLevel.autoStart);
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new IllegalStateException(String.format("Invalid run level descriptor for bundle %s, %s", bundleInfo.getSymbolicName(), location), e);
            }
            ++n2;
        }
        if (!Arrays.stream(bundles).map(TargetBundle::getBundleInfo).map(BundleStart::fromBundle).anyMatch(Predicate.not(BundleStart::isDefault))) {
            this.warning("No start levels are configured");
        }
    }

    private void warning(String message) {
        this.status.add(Status.warning((String)message));
    }

    private boolean isBad(IStatus status) {
        return status.matches(12);
    }

    @Override
    public int size() {
        this.checkResolved();
        return this.targetBundleIndex.size();
    }

    private ITargetPlatformHelper.Model toModel(IPluginModelBase model) {
        TargetBundle bundle = (TargetBundle)this.targetBundleIndex.get((Object)model.getBundleDescription().getSymbolicName()).iterator().next();
        return new ITargetPlatformHelper.Model(model, BundleStart.fromBundle(bundle.getBundleInfo()));
    }

    private Optional<String> getGroup(String input, Pattern prefix) {
        Matcher matcher = prefix.matcher(input);
        if (matcher.find()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }
}

