/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.aut;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.rcptt.core.launching.events.AutBundleState;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.internal.launching.utils.LogBuilder;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutLaunchListener;
import org.eclipse.rcptt.launching.AutLaunchState;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;

public class ConsoleOutputListener
implements AutLaunchListener {
    private static final int BITE_IN_MEGABITE = 0x100000;
    private final LogBuilder log;
    private AutLaunch launch = null;
    private boolean logStarted = false;
    private IStreamListener listener = new IStreamListener(){

        public void streamAppended(String text, IStreamMonitor monitor) {
            if (!$assertionsDisabled && ConsoleOutputListener.this.launch == null) {
                throw new AssertionError();
            }
            ConsoleOutputListener.this.log.append(text);
        }
    };

    public ConsoleOutputListener() {
        this.log = new LogBuilder(this.getLogSizeOfInitPart(), this.getLogSizeOfRotationPart());
    }

    static Collection<IStreamMonitor> getMonitors(ILaunch launch) {
        if (launch == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        IProcess[] iProcessArray = launch.getProcesses();
        int n = iProcessArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess process = iProcessArray[n2];
            IStreamsProxy proxy = process.getStreamsProxy();
            if (proxy != null) {
                builder.add((Object)proxy.getOutputStreamMonitor());
                builder.add((Object)proxy.getErrorStreamMonitor());
            }
            ++n2;
        }
        return builder.build();
    }

    public void startLogging(AutLaunch launch) {
        this.stopLogging();
        this.log.clear();
        this.launch = launch;
        for (IStreamMonitor sm : ConsoleOutputListener.getMonitors(launch.getLaunch())) {
            sm.addListener(this.listener);
            if (!(sm instanceof IFlushableStreamMonitor)) continue;
            IFlushableStreamMonitor flushable = (IFlushableStreamMonitor)sm;
            this.log.append(sm.getContents());
            flushable.setBuffered(false);
        }
        this.logStarted = true;
    }

    public void stopLogging() {
        this.logStarted = false;
        AutLaunch launch2 = this.launch;
        if (launch2 == null) {
            return;
        }
        for (IStreamMonitor sm : ConsoleOutputListener.getMonitors(launch2.getLaunch())) {
            sm.removeListener(this.listener);
            if (!(sm instanceof IFlushableStreamMonitor)) continue;
            IFlushableStreamMonitor flushable = (IFlushableStreamMonitor)sm;
            flushable.setBuffered(true);
        }
        this.log.clear();
        this.launch = null;
    }

    @Override
    public void stateChanged(AutLaunch launch, AutLaunchState state) {
        if (state.equals((Object)AutLaunchState.TERMINATE)) {
            this.stopLogging();
        }
    }

    public String getLog() {
        if (!this.logStarted) {
            throw new IllegalStateException("Log is not started");
        }
        return this.log.toString();
    }

    @Override
    public void autStarted(AutLaunch baseAutLaunch, int eclPort, int teslaPort) {
    }

    @Override
    public void autInit(AutLaunch baseAutLaunch, List<AutBundleState> bundleState) {
    }

    @Override
    public void autLocationChange(BaseAutLaunch baseAutLaunch, String location) {
    }

    private int getLogSizeOfInitPart() {
        return TeslaFeatures.getInstance().getIntValue("com.xored.reporting.logging.initial.size") * 0x100000;
    }

    private int getLogSizeOfRotationPart() {
        return TeslaFeatures.getInstance().getIntValue("com.xored.reporting.logging.rotation.size") * 0x100000;
    }
}

