/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.jobs.jobs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AsyncEventKind implements Enumerator
{
    STARTING(0, "Starting", "Starting"),
    DONE(1, "Done", "Done"),
    RUNNING(2, "Running", "Running"),
    TIMER_EXEC(3, "TimerExec", "TimerExec");

    public static final int STARTING_VALUE = 0;
    public static final int DONE_VALUE = 1;
    public static final int RUNNING_VALUE = 2;
    public static final int TIMER_EXEC_VALUE = 3;
    private static final AsyncEventKind[] VALUES_ARRAY;
    public static final List<AsyncEventKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AsyncEventKind[]{STARTING, DONE, RUNNING, TIMER_EXEC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AsyncEventKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AsyncEventKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AsyncEventKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AsyncEventKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AsyncEventKind get(int value) {
        switch (value) {
            case 0: {
                return STARTING;
            }
            case 1: {
                return DONE;
            }
            case 2: {
                return RUNNING;
            }
            case 3: {
                return TIMER_EXEC;
            }
        }
        return null;
    }

    private AsyncEventKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

