/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.target;

import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.launching.ext.BundleStart;
import org.eclipse.rcptt.launching.ext.OriginalOrderProperties;
import org.eclipse.rcptt.launching.injection.InjectionConfiguration;
import org.eclipse.rcptt.launching.internal.target.Q7Target;

public interface ITargetPlatformHelper {
    public Q7Target getQ7Target();

    public String getUserArea();

    public boolean isResolved();

    public void save() throws CoreException;

    public String getName();

    public String getTargetPlatformProfilePath();

    public void delete();

    public String[] getApplications();

    public String[] getProducts();

    public String getDefaultApplication();

    public String getDefaultProduct();

    public IStatus applyInjection(InjectionConfiguration var1, IProgressMonitor var2);

    public Map<String, String> getIniEnvironment();

    public String getIniVMArgs();

    public Optional<Path> getJavaHome();

    public String getTemplateConfigLocation();

    public OriginalOrderProperties getConfigIniProperties();

    public OSArchitecture detectArchitecture(StringBuilder var1);

    public String getRuntimeVersion();

    public IStatus resolve(IProgressMonitor var1);

    public String getEquinoxStartupPath(String var1);

    public IPluginModelBase getWeavingHook();

    public IStatus getStatus();

    public Stream<Model> getModels();

    public Map<String, Version> getVersions() throws CoreException;

    public int size();

    public Set<String> getIncompatibleExecutionEnvironments();

    public record Model(IPluginModelBase model, BundleStart startLevel) {
        public Model {
            Objects.requireNonNull(model);
            Objects.requireNonNull(startLevel);
        }
    }
}

