/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj.loadtime;

import java.net.URL;
import java.util.List;
import org.aspectj.weaver.loadtime.DefaultWeavingContext;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.tools.WeavingAdaptor;
import org.eclipse.equinox.weaving.aspectj.AspectJWeavingStarter;
import org.osgi.framework.wiring.BundleRevision;

public class OSGiWeavingContext
extends DefaultWeavingContext {
    private final List<Definition> aspectDefinitions;
    private final BundleRevision bundleRevision;

    public OSGiWeavingContext(ClassLoader loader, BundleRevision bundleRevision, List<Definition> aspectDefinitions) {
        super(loader);
        this.bundleRevision = bundleRevision;
        this.aspectDefinitions = aspectDefinitions;
        if (AspectJWeavingStarter.DEBUG) {
            System.out.println("- WeavingContext.WeavingContext() locader=" + loader + ", bundle=" + bundleRevision.getSymbolicName());
        }
    }

    public String getClassLoaderName() {
        return this.bundleRevision.getSymbolicName();
    }

    public List<Definition> getDefinitions(ClassLoader loader, WeavingAdaptor adaptor) {
        return this.aspectDefinitions;
    }

    public String getFile(URL url) {
        return String.valueOf(this.getBundleIdFromURL(url)) + url.getFile();
    }

    public String getId() {
        return this.bundleRevision.getSymbolicName();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.bundleRevision.getSymbolicName() + "]";
    }
}

