/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.tags.Tag;

public class TagsUtil {
    public static List<String> extractTags(String tagsString) {
        ArrayList<String> tags = new ArrayList<String>(4);
        if (tagsString != null && !"".equals(tagsString.trim())) {
            String[] stringArray = tagsString.split("[,;\\:]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                tags.add(s.trim());
                ++n2;
            }
        }
        return tags;
    }

    public static boolean hasAny(IQ7NamedElement e, List<String> tags) throws ModelException {
        List<String> elementTags = TagsUtil.extractTags(e);
        return TagsUtil.hasAny(tags, elementTags);
    }

    public static boolean hasAny(List<String> tags, List<String> elementTags) {
        for (String tag : tags) {
            if (!elementTags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAny(IQ7NamedElement e, String[] tags) throws ModelException {
        return TagsUtil.hasAny(e, Arrays.asList(tags));
    }

    public static List<String> extractTags(IQ7NamedElement e) throws ModelException {
        return TagsUtil.extractTags(e.getTags());
    }

    public static List<IQ7NamedElement> getDistinctTagRefs(Tag tag) {
        return TagsUtil.getDistinctTagRefs(tag, new ArrayList<IQ7NamedElement>());
    }

    public static int getDistinctTagRefsCount(Tag tag) {
        return TagsUtil.getDistinctTagRefs(tag, new ArrayList<IQ7NamedElement>()).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<IQ7NamedElement> getDistinctTagRefs(Tag tag, List<IQ7NamedElement> considered) {
        Tag tag2 = tag;
        synchronized (tag2) {
            for (IQ7NamedElement element : tag.getRefs()) {
                if (considered.contains(element)) continue;
                considered.add(element);
            }
            for (Tag childTag : tag.getTags()) {
                TagsUtil.getDistinctTagRefs(childTag, considered);
            }
        }
        return considered;
    }

    public static Tag getParentTag(Tag tag) {
        EObject parent = tag.eContainer();
        if (parent instanceof Tag) {
            return (Tag)parent;
        }
        return null;
    }
}

