/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.workspace;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.workspace.WorkspaceSynchronizer;

public class Q7Utils {
    public static String safeGetId(IQ7NamedElement element) {
        try {
            return element == null ? null : element.getID();
        }
        catch (ModelException e) {
            return null;
        }
    }

    public static IFile getLocation(String uri) {
        return Q7Utils.getLocation((Resource)new ResourceImpl(URI.createPlatformResourceURI((String)uri, (boolean)true)));
    }

    public static IFile getLocation(NamedElement executable) {
        if (executable == null) {
            return null;
        }
        return Q7Utils.getLocation(executable.eResource());
    }

    public static IFile getLocation(Resource resource) {
        if (resource == null) {
            return null;
        }
        if (resource.getURI() == null) {
            return null;
        }
        return WorkspaceSynchronizer.getFile(resource);
    }

    public static String serializeToString(EObject eObject) throws IOException {
        XMLResourceImpl resource = new XMLResourceImpl();
        resource.getContents().add((Object)EcoreUtil.copy((EObject)eObject));
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        resource.save((OutputStream)bytes, options);
        return bytes.toString();
    }

    public static EObject deserializeFromstring(String xml) throws IOException {
        XMLResourceImpl resource = new XMLResourceImpl();
        resource.load((InputStream)new ByteArrayInputStream(xml.getBytes()), null);
        EList contents = resource.getContents();
        if (contents.size() == 1) {
            return (EObject)contents.get(0);
        }
        return null;
    }
}

