/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.quickaccess;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.quickaccess.LaunchQuickAccessElement;
import org.eclipse.ui.quickaccess.IQuickAccessComputer;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public abstract class AbstractLaunchQuickAccessComputer
implements IQuickAccessComputer {
    protected final ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
    protected final ILaunchMode launchMode;
    private boolean launchConfigurationsChanged = false;

    public AbstractLaunchQuickAccessComputer(ILaunchMode launchMode) {
        this.launchMode = launchMode;
        this.manager.addLaunchConfigurationListener(new ILaunchConfigurationListener(){

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
                AbstractLaunchQuickAccessComputer.this.launchConfigurationsChanged = true;
            }

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
                AbstractLaunchQuickAccessComputer.this.launchConfigurationsChanged = true;
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
                AbstractLaunchQuickAccessComputer.this.launchConfigurationsChanged = true;
            }
        });
    }

    public QuickAccessElement[] computeElements() {
        try {
            return (QuickAccessElement[])Arrays.stream(this.manager.getLaunchConfigurations()).filter(config -> {
                try {
                    return config.getType().supportsMode(this.launchMode.getIdentifier());
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                    return false;
                }
            }).map(config -> new LaunchQuickAccessElement((ILaunchConfiguration)config, this.launchMode)).toArray(QuickAccessElement[]::new);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
            return new QuickAccessElement[0];
        }
    }

    public void resetState() {
    }

    public boolean needsRefresh() {
        return this.launchConfigurationsChanged;
    }
}

