/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints2;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.AbstractTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeVariable;

public class TTypes {
    private TTypes() {
    }

    public static TType createArrayType(TType elementType, int dimensions) {
        return elementType.getEnvironment().createArrayType(elementType, dimensions);
    }

    public static Iterator<TType> getAllSubTypesIterator(TType type) {
        return new AllSubtypesIterator(type);
    }

    public static Iterator<TType> getAllSuperTypesIterator(TType type) {
        return new AllSupertypesIterator(type);
    }

    public static boolean canAssignTo(TType rhs, TType lhs) {
        if (rhs.isHierarchyType() && lhs.isHierarchyType()) {
            HierarchyType rhsGeneric = (HierarchyType)rhs.getTypeDeclaration();
            HierarchyType lhsGeneric = (HierarchyType)lhs.getTypeDeclaration();
            return lhs.isJavaLangObject() || rhsGeneric.equals(lhsGeneric) || rhsGeneric.isSubType(lhsGeneric);
        }
        if (rhs.isTypeVariable()) {
            if (rhs.canAssignTo(lhs)) {
                return true;
            }
            TType[] tTypeArray = ((TypeVariable)rhs).getBounds();
            int n = tTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TType bound = tTypeArray[n2];
                if (TTypes.canAssignTo(bound, lhs)) {
                    return true;
                }
                ++n2;
            }
            return lhs.isJavaLangObject();
        }
        return rhs.canAssignTo(lhs);
    }

    private static class AllSubtypesIterator
    implements Iterator<TType> {
        private final Stack<TType> fWorklist = new Stack();

        public AllSubtypesIterator(TType type) {
            this.fWorklist.push(type.getTypeDeclaration());
        }

        @Override
        public boolean hasNext() {
            return !this.fWorklist.empty();
        }

        @Override
        public TType next() {
            TType result = this.fWorklist.pop();
            TType[] tTypeArray = result.getSubTypes();
            int n = tTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TType subType = tTypeArray[n2];
                this.fWorklist.push(subType.getTypeDeclaration());
                ++n2;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class AllSupertypesIterator
    implements Iterator<TType> {
        private final Stack<TType> fWorklist = new Stack();

        public AllSupertypesIterator(TType type) {
            this.pushSupertypes(type);
        }

        @Override
        public boolean hasNext() {
            return !this.fWorklist.empty();
        }

        @Override
        public TType next() {
            TType result = this.fWorklist.pop();
            this.pushSupertypes(result);
            return result;
        }

        private void pushSupertypes(TType type) {
            if (type.isJavaLangObject()) {
                return;
            }
            if (type.isTypeVariable() || type.isCaptureType()) {
                TType[] tTypeArray = ((AbstractTypeVariable)type).getBounds();
                int n = tTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TType bound = tTypeArray[n2];
                    this.fWorklist.push(bound.getTypeDeclaration());
                    ++n2;
                }
            } else {
                TType superclass = type.getSuperclass();
                if (superclass == null) {
                    if (type.isInterface()) {
                        this.fWorklist.push(type.getEnvironment().getJavaLangObject());
                    }
                } else {
                    this.fWorklist.push(superclass.getTypeDeclaration());
                }
                TType[] tTypeArray = type.getInterfaces();
                int n = tTypeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    TType intf = tTypeArray[n3];
                    this.fWorklist.push(intf.getTypeDeclaration());
                    ++n3;
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

