/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.Q7ElementLabelProvider;
import org.eclipse.rcptt.ui.commons.ModernElementListSelectionDialog;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public abstract class OpenNamedElementAction {
    IWorkbenchWindow window;

    protected ILabelProvider createLabelProvider() {
        return new Q7ElementLabelProvider();
    }

    public void run(IAction action) {
        final Display display = Display.getCurrent();
        new Job("Looking for elements"){

            protected IStatus run(IProgressMonitor monitor) {
                final HashSet<IQ7NamedElement> allElements = new HashSet<IQ7NamedElement>();
                OpenNamedElementAction.this.fillNamedElements(allElements);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OpenNamedElementAction.this.showDialog(allElements);
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void showDialog(Set<IQ7NamedElement> allElements) {
        ModernElementListSelectionDialog dialog = new ModernElementListSelectionDialog(WorkbenchUtils.getShell(), this.createLabelProvider());
        dialog.setElements(allElements.toArray());
        dialog.setTitle(this.getWindowTitle());
        dialog.setMessage(Messages.OpenNamedElementAction_DialogMsg);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        if (result == 0) {
            Object[] selected = dialog.getResult();
            int i = 0;
            while (i < selected.length) {
                try {
                    IDE.openEditor((IWorkbenchPage)WorkbenchUtils.getPage(), (IFile)((IFile)((IQ7NamedElement)selected[i]).getResource()));
                }
                catch (PartInitException e) {
                    Q7UIPlugin.log(e);
                }
                ++i;
            }
        }
    }

    protected abstract String getWindowTitle();

    protected abstract void fillNamedElements(Set<IQ7NamedElement> var1);

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

