/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rcptt.reporting.util.Q7ReportIterator;
import org.eclipse.rcptt.reporting.util.ReportEntry;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;

class ReportEntryContentProvider
implements IStructuredContentProvider {
    private List<ReportEntry> entries = Collections.emptyList();
    private Viewer viewer = null;

    ReportEntryContentProvider() {
    }

    public void dispose() {
        Job.getJobManager().cancel((Object)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        Job.getJobManager().cancel((Object)this);
        if (newInput instanceof Q7ReportIterator) {
            new UpdateJob((Iterable<Report>)((Q7ReportIterator)newInput)).schedule();
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.entries.toArray();
    }

    private class UpdateJob
    extends Job {
        private final Iterable<Report> reports;

        public boolean belongsTo(Object family) {
            return ReportEntryContentProvider.this == family;
        }

        public UpdateJob(Iterable<Report> reports) {
            super("Building test list for report");
            this.reports = reports;
            Preconditions.checkNotNull(reports);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ArrayList<ReportEntry> entries = new ArrayList<ReportEntry>();
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Iterable<Report> iterable = this.reports;
            synchronized (iterable) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Iterator<Report> iterator = this.reports.iterator();
                while (iterator.hasNext()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Report next = iterator.next();
                    if (next == null) break;
                    entries.add(ReportEntry.create((Report)next));
                }
            }
            ReportEntryContentProvider.this.entries = entries;
            ReportEntryContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!((UpdateJob)UpdateJob.this).ReportEntryContentProvider.this.viewer.getControl().isDisposed()) {
                        ((UpdateJob)UpdateJob.this).ReportEntryContentProvider.this.viewer.refresh();
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

