/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import org.eclipse.core.runtime.Platform;

public class Utilities {
    private static long tmpseed = new Date().getTime();
    private static String dirRoot = null;

    public static synchronized File createWorkingDirectory() throws IOException {
        if (dirRoot == null) {
            dirRoot = System.getProperty("java.io.tmpdir");
            if (!dirRoot.endsWith(File.separator)) {
                dirRoot = String.valueOf(dirRoot) + File.separator;
            }
            if (!Platform.getOS().equals("win32")) {
                String home = System.getProperty("user.home");
                home = Integer.toString(home.hashCode());
                dirRoot = String.valueOf(dirRoot) + home + File.separator;
            }
            dirRoot = String.valueOf(dirRoot) + "eclipse" + File.separator + ".update" + File.separator + Long.toString(tmpseed) + File.separator;
        }
        String tmpName = dirRoot + Long.toString(++tmpseed) + File.separator;
        File tmpDir = new File(tmpName);
        Utilities.verifyPath(tmpDir, false);
        if (!tmpDir.exists()) {
            throw new FileNotFoundException(tmpName);
        }
        return tmpDir;
    }

    public static void shutdown() {
        if (dirRoot == null) {
            return;
        }
        File temp = new File(dirRoot);
        Utilities.cleanupTemp(temp);
        temp.delete();
    }

    private static void cleanupTemp(File root) {
        File[] files = root.listFiles();
        int i = 0;
        while (files != null && i < files.length) {
            if (files[i].isDirectory()) {
                Utilities.cleanupTemp(files[i]);
            }
            files[i].delete();
            ++i;
        }
    }

    private static void verifyPath(File path, boolean isFile) {
        if (isFile && path.getAbsolutePath().endsWith(File.separator)) {
            path = path.getParentFile();
            isFile = false;
        }
        if (path.exists()) {
            return;
        }
        File parent = path.getParentFile();
        Utilities.verifyPath(parent, false);
        if (!isFile) {
            path.mkdir();
        }
        path.deleteOnExit();
    }
}

