/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.limited;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategy;

public class LimitedSizeEvaluationStrategy
extends StrictEvaluationStrategy {
    private final AtomicLong used = new AtomicLong();
    private final long maxSize;

    public LimitedSizeEvaluationStrategy(TripleSource tripleSource, long maxSize, FederatedServiceResolver serviceManager) {
        super(tripleSource, serviceManager);
        this.maxSize = maxSize;
    }

    public LimitedSizeEvaluationStrategy(TripleSource tripleSource, Dataset dataset, int maxCollectionsSize, FederatedServiceResolver serviceManager) {
        super(tripleSource, dataset, serviceManager);
        this.maxSize = maxCollectionsSize;
    }

    public <B> Set<B> makeSet() {
        final Set wrapped = super.makeSet();
        return new Set<B>(){

            @Override
            public boolean add(B e) {
                boolean add = wrapped.add(e);
                if (add && LimitedSizeEvaluationStrategy.this.used.incrementAndGet() > LimitedSizeEvaluationStrategy.this.maxSize) {
                    throw new QueryEvaluationException("Set size is to large");
                }
                return add;
            }

            @Override
            public boolean remove(Object o) {
                boolean removed = wrapped.remove(o);
                if (removed) {
                    LimitedSizeEvaluationStrategy.this.used.decrementAndGet();
                }
                return removed;
            }

            @Override
            public void clear() {
                int size = this.size();
                LimitedSizeEvaluationStrategy.this.used.getAndAdd(-size);
                wrapped.clear();
            }

            @Override
            public int size() {
                return wrapped.size();
            }

            @Override
            public boolean isEmpty() {
                return wrapped.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return wrapped.contains(o);
            }

            @Override
            public Iterator<B> iterator() {
                return wrapped.iterator();
            }

            @Override
            public Object[] toArray() {
                return wrapped.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return wrapped.toArray(a);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return wrapped.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends B> c) {
                boolean all = true;
                for (Object b : c) {
                    boolean added = wrapped.add(b);
                    if (added) continue;
                    all = false;
                }
                return all;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                int prevSize = wrapped.size();
                boolean changed = wrapped.retainAll(c);
                if (changed) {
                    int newSize = wrapped.size();
                    LimitedSizeEvaluationStrategy.this.used.addAndGet(-(prevSize - newSize));
                }
                return changed;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                int prevSize = wrapped.size();
                boolean changed = wrapped.removeAll(c);
                if (changed) {
                    int newSize = wrapped.size();
                    LimitedSizeEvaluationStrategy.this.used.addAndGet(-(prevSize - newSize));
                }
                return changed;
            }
        };
    }
}

