/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.lmdb.MDBVal;

class Pool {
    private final MDBVal[] valPool = new MDBVal[1024];
    private final ByteBuffer[] keyPool = new ByteBuffer[1024];
    private volatile int valPoolIndex = -1;
    private volatile int keyPoolIndex = -1;

    Pool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MDBVal getVal() {
        MDBVal[] mDBValArray = this.valPool;
        synchronized (this.valPool) {
            if (this.valPoolIndex >= 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.valPool[this.valPoolIndex--];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MDBVal.malloc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getKeyBuffer() {
        ByteBuffer[] byteBufferArray = this.keyPool;
        synchronized (this.keyPool) {
            if (this.keyPoolIndex >= 0) {
                ByteBuffer bb = this.keyPool[this.keyPoolIndex--];
                bb.clear();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return bb;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MemoryUtil.memAlloc((int)36);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(MDBVal val) {
        MDBVal[] mDBValArray = this.valPool;
        synchronized (this.valPool) {
            if (this.valPoolIndex < this.valPool.length - 1) {
                this.valPool[++this.valPoolIndex] = val;
            } else {
                val.close();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(ByteBuffer bb) {
        ByteBuffer[] byteBufferArray = this.keyPool;
        synchronized (this.keyPool) {
            if (this.keyPoolIndex < this.keyPool.length - 1) {
                this.keyPool[++this.keyPoolIndex] = bb;
            } else {
                MemoryUtil.memFree((Buffer)bb);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object[] objectArray = this.valPool;
        synchronized (this.valPool) {
            while (this.valPoolIndex >= 0) {
                this.valPool[this.valPoolIndex--].close();
            }
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            objectArray = this.keyPool;
            synchronized (this.keyPool) {
                while (this.keyPoolIndex >= 0) {
                    MemoryUtil.memFree((Buffer)this.keyPool[this.keyPoolIndex--]);
                }
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                return;
            }
        }
    }
}

