/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint.provider;

import org.eclipse.rdf4j.federated.endpoint.EndpointType;
import org.eclipse.rdf4j.federated.endpoint.SparqlEndpointConfiguration;
import org.eclipse.rdf4j.federated.endpoint.provider.RepositoryInformation;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.federated.util.Vocabulary;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

public class SPARQLRepositoryInformation
extends RepositoryInformation {
    public SPARQLRepositoryInformation(String name, String endpoint) {
        super(SPARQLRepositoryInformation.endpointToID(endpoint), name, endpoint, EndpointType.SparqlEndpoint);
    }

    public SPARQLRepositoryInformation(Model graph, Resource repNode) {
        super(EndpointType.SparqlEndpoint);
        this.initialize(graph, repNode);
    }

    protected void initialize(Model graph, Resource repNode) {
        this.setProperty("name", repNode.stringValue());
        Model location = graph.filter(repNode, Vocabulary.SD.ENDPOINT, null, new Resource[0]);
        String repoLocation = ((Statement)location.iterator().next()).getObject().stringValue();
        this.setProperty("location", repoLocation);
        Object id = repNode.stringValue().replace("http://", "");
        id = "sparql_" + ((String)id).replace("/", "_");
        this.setProperty("id", (String)id);
        if (this.hasAdditionalSettings(graph, repNode)) {
            SparqlEndpointConfiguration c = new SparqlEndpointConfiguration();
            if (graph.contains(repNode, Vocabulary.FEDX.SUPPORTS_ASK_QUERIES, (Value)FedXUtil.literal("false"), new Resource[0]) || graph.contains(repNode, Vocabulary.FEDX.SUPPORTS_ASK_QUERIES, (Value)FedXUtil.valueFactory().createLiteral(false), new Resource[0])) {
                c.setSupportsASKQueries(false);
            }
            this.setEndpointConfiguration(c);
        }
    }

    protected boolean hasAdditionalSettings(Model graph, Resource repNode) {
        return graph.contains(repNode, Vocabulary.FEDX.SUPPORTS_ASK_QUERIES, null, new Resource[0]);
    }

    static String endpointToID(String endpoint) {
        return "sparql_" + endpoint.replace("http://", "").replace("/", "_");
    }
}

