/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.common.io.UncloseableOutputStream;
import org.eclipse.rdf4j.console.Util;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.console.command.TupleAndGraphQueryEvaluator;
import org.eclipse.rdf4j.console.setting.ConsoleWidth;
import org.eclipse.rdf4j.console.setting.Prefixes;
import org.eclipse.rdf4j.console.setting.QueryPrefix;
import org.eclipse.rdf4j.console.setting.ShowPrefix;
import org.eclipse.rdf4j.console.setting.WorkDir;
import org.eclipse.rdf4j.console.util.ConsoleQueryResultWriter;
import org.eclipse.rdf4j.console.util.ConsoleRDFWriter;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.QueryResultWriter;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;

public abstract class QueryEvaluator
extends ConsoleCommand {
    private final TupleAndGraphQueryEvaluator evaluator;
    private final List<String> sparqlQueryStart = Arrays.asList("select", "construct", "describe", "ask", "prefix", "base");
    private final long MAX_INPUT = 1000000L;
    private static final Pattern PATTERN_IO = Pattern.compile("^(?<in>INFILE=\"(?<i>[^\"]+)\",?(?<enc>\\w[\\w-]+)?)? ?(?<out>OUTFILE=\"(?<o>[^\"]+)\")?", 2);

    public QueryEvaluator(TupleAndGraphQueryEvaluator evaluator) {
        super(evaluator.getConsoleIO(), evaluator.getConsoleState(), evaluator.getConsoleSettings());
        this.evaluator = evaluator;
    }

    protected abstract boolean hasQueryPrefixes(String var1);

    protected abstract void addQueryPrefixes(StringBuffer var1, Collection<Namespace> var2);

    @Override
    public String[] usesSettings() {
        return new String[]{"width", "prefixes", "queryprefix", "showprefix", "workdir"};
    }

    private int getConsoleWidth() {
        return (Integer)((ConsoleWidth)this.settings.get("width")).get();
    }

    private boolean getQueryPrefix() {
        return (Boolean)((QueryPrefix)this.settings.get("queryprefix")).get();
    }

    private boolean getShowPrefix() {
        return (Boolean)((ShowPrefix)this.settings.get("showprefix")).get();
    }

    private Set<Namespace> getPrefixes() {
        return (Set)((Prefixes)this.settings.get("prefixes")).get();
    }

    private Path getWorkDir() {
        return (Path)((WorkDir)this.settings.get("workdir")).get();
    }

    public void executeQuery(String command, String operation) {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.writeUnopenedError();
            return;
        }
        if (this.sparqlQueryStart.contains(operation)) {
            this.parseAndEvaluateQuery(QueryLanguage.SPARQL, command);
        } else if ("sparql".equals(operation)) {
            this.parseAndEvaluateQuery(QueryLanguage.SPARQL, command.substring("sparql".length()));
        } else {
            this.writeError("Unknown command");
        }
    }

    private String readFile(String filename, String cset) throws IllegalArgumentException, IOException {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("Empty file name");
        }
        Charset charset = cset == null || cset.isEmpty() ? StandardCharsets.UTF_8 : Charset.forName(cset);
        Path p = Util.getNormalizedPath(this.getWorkDir(), filename);
        if (!p.toFile().canRead()) {
            throw new IOException("Cannot read file " + p);
        }
        if (p.toFile().length() > 1000000L) {
            throw new IOException("File larger than 1000000 bytes");
        }
        byte[] bytes = Files.readAllBytes(p);
        return new String(bytes, charset);
    }

    private Path getPathForOutput(String filename) throws IllegalArgumentException, IOException {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("Empty file name");
        }
        Path p = Util.getNormalizedPath(this.getWorkDir(), filename);
        if (!p.toFile().exists() || this.askProceed("File exists, continue ?", false)) {
            return p;
        }
        throw new IOException("Could not open file for output");
    }

    private String readMultiline(QueryLanguage queryLn, String queryText) {
        String str = queryText.trim();
        if (!str.isEmpty()) {
            return str;
        }
        this.writeln("Enter multi-line " + queryLn.getName() + " query (terminate with line containing single '.')");
        return this.consoleIO.readMultiLineInput();
    }

    private void parseAndEvaluateQuery(QueryLanguage queryLn, String queryText) {
        String str = this.readMultiline(queryLn, queryText);
        if (str == null || str.isEmpty()) {
            this.writeError("Empty query string");
            return;
        }
        Path path = null;
        Matcher m = PATTERN_IO.matcher(str);
        if (m.lookingAt()) {
            try {
                String infile;
                String outfile = m.group("o");
                if (outfile != null && !outfile.isEmpty()) {
                    path = this.getPathForOutput(outfile);
                    str = str.substring(m.group(0).length());
                }
                if ((infile = m.group("i")) != null && !infile.isEmpty()) {
                    str = this.readFile(infile, m.group("enc"));
                }
            }
            catch (IOException | IllegalArgumentException ex) {
                this.writeError(ex.getMessage());
                return;
            }
        }
        String queryString = this.addQueryPrefixes(str);
        try {
            ParsedOperation query = QueryParserUtil.parseOperation((QueryLanguage)queryLn, (String)queryString, null);
            this.evaluateQuery(queryLn, query, path);
        }
        catch (UnsupportedQueryLanguageException e) {
            this.writeError("Unsupported query language: " + queryLn.getName());
        }
        catch (MalformedQueryException e) {
            this.writeError("Malformed query", (Exception)((Object)e));
        }
        catch (QueryInterruptedException e) {
            this.writeError("Query interrupted", (Exception)((Object)e));
        }
        catch (QueryEvaluationException e) {
            this.writeError("Query evaluation error", (Exception)((Object)e));
        }
        catch (RepositoryException e) {
            this.writeError("Failed to evaluate query", (Exception)((Object)e));
        }
        catch (UpdateExecutionException e) {
            this.writeError("Failed to execute update", (Exception)((Object)e));
        }
    }

    private QueryResultWriter getQueryResultWriter(Path path, OutputStream out) throws IllegalArgumentException {
        ConsoleQueryResultWriter w;
        if (path == null) {
            w = new ConsoleQueryResultWriter(this.consoleIO, this.getConsoleWidth());
        } else {
            Optional fmt = QueryResultIO.getWriterFormatForFileName((String)path.toFile().toString());
            if (fmt.isEmpty()) {
                throw new IllegalArgumentException("No suitable result writer found");
            }
            w = QueryResultIO.createWriter((QueryResultFormat)((QueryResultFormat)fmt.get()), (OutputStream)out);
        }
        if (this.getShowPrefix()) {
            this.getPrefixes().stream().forEach(arg_0 -> QueryEvaluator.lambda$getQueryResultWriter$0((QueryResultWriter)w, arg_0));
        }
        return w;
    }

    private RDFWriter getRDFWriter(Path path, OutputStream out) throws IllegalArgumentException {
        ConsoleRDFWriter w;
        if (path == null) {
            w = new ConsoleRDFWriter(this.consoleIO, this.getConsoleWidth());
        } else {
            Optional fmt = Rio.getWriterFormatForFileName((String)path.toFile().toString());
            if (fmt.isEmpty()) {
                throw new IllegalArgumentException("No suitable result writer found");
            }
            w = Rio.createWriter((RDFFormat)((RDFFormat)fmt.get()), (OutputStream)out);
        }
        return w;
    }

    private OutputStream getOutputStream(Path path) throws IOException {
        return path != null ? Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE) : new UncloseableOutputStream(this.consoleIO.getOutputStream());
    }

    private void evaluateQuery(QueryLanguage queryLn, ParsedOperation query, Path path) throws MalformedQueryException, QueryEvaluationException, UpdateExecutionException {
        String queryString = query.getSourceString();
        try (OutputStream os = this.getOutputStream(path);){
            if (query instanceof ParsedTupleQuery) {
                QueryResultWriter writer = this.getQueryResultWriter(path, os);
                this.evaluator.evaluateTupleQuery(queryLn, queryString, writer);
            } else if (query instanceof ParsedBooleanQuery) {
                QueryResultWriter writer = this.getQueryResultWriter(path, os);
                this.evaluator.evaluateBooleanQuery(queryLn, queryString, writer);
            } else if (query instanceof ParsedGraphQuery) {
                RDFWriter writer = this.getRDFWriter(path, os);
                this.evaluator.evaluateGraphQuery(queryLn, queryString, writer, this.getShowPrefix() ? this.getPrefixes() : Collections.emptySet());
            } else if (query instanceof ParsedUpdate) {
                if (path != null) {
                    throw new IllegalArgumentException("Update query does not produce output");
                }
                this.evaluator.executeUpdate(queryLn, queryString);
            } else {
                this.writeError("Unexpected query type");
            }
        }
        catch (IOException | IllegalArgumentException ioe) {
            this.writeError(ioe.getMessage());
        }
    }

    private String addQueryPrefixes(String queryString) {
        StringBuffer result = new StringBuffer(queryString.length() + 512);
        result.append(queryString);
        String upperCaseQuery = queryString.toUpperCase(Locale.ENGLISH);
        if (this.getQueryPrefix() && !this.hasQueryPrefixes(upperCaseQuery)) {
            this.addQueryPrefixes(result, this.getPrefixes());
        }
        return result.toString();
    }

    private static /* synthetic */ void lambda$getQueryResultWriter$0(QueryResultWriter w, Namespace ns) {
        w.handleNamespace(ns.getPrefix(), ns.getName());
    }
}

