/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.algebra.AggregateFunctionCall;
import org.eclipse.rdf4j.query.algebra.AggregateOperator;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.Avg;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Coalesce;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.DescribeOperator;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.GroupConcat;
import org.eclipse.rdf4j.query.algebra.GroupElem;
import org.eclipse.rdf4j.query.algebra.IRIFunction;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsNumeric;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LangMatches;
import org.eclipse.rdf4j.query.algebra.ListMemberOperator;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.Sample;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.Sum;
import org.eclipse.rdf4j.query.algebra.TripleRef;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.ValueExprTripleRef;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.VariableScopeChange;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;
import org.eclipse.rdf4j.query.algebra.helpers.collectors.StatementPatternCollector;
import org.eclipse.rdf4j.query.algebra.helpers.collectors.VarNameCollector;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.parser.sparql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.sparql.ConstructorBuilder;
import org.eclipse.rdf4j.query.parser.sparql.GraphPattern;
import org.eclipse.rdf4j.query.parser.sparql.PropertySetElem;
import org.eclipse.rdf4j.query.parser.sparql.TripleRefCollector;
import org.eclipse.rdf4j.query.parser.sparql.aggregate.CustomAggregateFunctionRegistry;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTAbs;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTAnd;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTAskQuery;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTAvg;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBNodeFunc;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBind;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBindingSet;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBindingValue;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBindingsClause;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBlankNode;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBlankNodePropertyList;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBound;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTCeil;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTCoalesce;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTCollection;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTCompare;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTConcat;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTConstTripleRef;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTConstraint;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTConstruct;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTConstructQuery;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTContains;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTCount;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDatatype;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDay;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDescribe;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDescribeQuery;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTEncodeForURI;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTExistsFunc;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTFalse;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTFloor;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTFunctionCall;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTGraphGraphPattern;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTGraphPatternGroup;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTGroupClause;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTGroupConcat;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTGroupCondition;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTHavingClause;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTHours;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIRI;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIRIFunc;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIf;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIn;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTInfix;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTInlineData;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIsBlank;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIsIRI;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIsLiteral;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIsNumeric;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTLang;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTLangMatches;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTLimit;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTLowerCase;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTMD5;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTMath;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTMax;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTMin;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTMinusGraphPattern;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTMinutes;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTMonth;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTNot;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTNotExistsFunc;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTNotIn;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTNow;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTNumericLiteral;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTObjectList;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOffset;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOptionalGraphPattern;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOr;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOrderClause;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOrderCondition;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTPathAlternative;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTPathElt;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTPathMod;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTPathNegatedPropertySet;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTPathOneInPropertySet;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTPathSequence;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTProjectionElem;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTPropertyList;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTPropertyListPath;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTQName;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTQueryContainer;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTRDFLiteral;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTRand;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTRegexExpression;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTReplace;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTRound;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSHA1;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSHA224;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSHA256;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSHA384;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSHA512;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSTRUUID;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSameTerm;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSample;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSeconds;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSelect;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSelectQuery;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTServiceGraphPattern;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTStr;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTStrAfter;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTStrBefore;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTStrDt;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTStrEnds;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTStrLang;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTStrLen;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTStrStarts;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTString;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSubstr;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSum;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTTimezone;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTTripleRef;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTTriplesSameSubjectPath;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTTrue;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTTz;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTUUID;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTUnionGraphPattern;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTUpperCase;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTVar;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTYear;
import org.eclipse.rdf4j.query.parser.sparql.ast.Node;
import org.eclipse.rdf4j.query.parser.sparql.ast.SimpleNode;
import org.eclipse.rdf4j.query.parser.sparql.ast.VisitorException;

@InternalUseOnly
public class TupleExprBuilder
extends AbstractASTVisitor {
    private static final String uniqueIdPrefix = UUID.randomUUID().toString().replace("-", "");
    private static final AtomicLong uniqueIdSuffix = new AtomicLong();
    protected ValueFactory valueFactory;
    GraphPattern graphPattern = new GraphPattern();

    public TupleExprBuilder(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    protected Var mapValueExprToVar(Object valueExpr) {
        if (valueExpr instanceof Var) {
            return ((Var)valueExpr).clone();
        }
        if (valueExpr instanceof ValueConstant) {
            return TupleExprs.createConstVar((Value)((ValueConstant)valueExpr).getValue());
        }
        if (valueExpr instanceof TripleRef) {
            return ((TripleRef)valueExpr).getExprVar().clone();
        }
        if (valueExpr == null) {
            throw new IllegalArgumentException("valueExpr is null");
        }
        throw new IllegalArgumentException("valueExpr is a: " + String.valueOf(valueExpr.getClass()));
    }

    protected Value getValueForExpr(ValueExpr valueExpr) {
        if (valueExpr instanceof Var) {
            return ((Var)valueExpr).getValue();
        }
        if (valueExpr instanceof ValueConstant) {
            ValueConstant vc = (ValueConstant)valueExpr;
            return vc.getValue();
        }
        if (valueExpr == null) {
            throw new IllegalArgumentException("valueExpr is null");
        }
        throw new IllegalArgumentException("valueExpr is a: " + String.valueOf(valueExpr.getClass()));
    }

    protected Var createAnonVar() {
        return new Var("_anon_" + uniqueIdPrefix + uniqueIdSuffix.incrementAndGet(), true);
    }

    private FunctionCall createFunctionCall(String uri, SimpleNode node, int minArgs, int maxArgs) throws VisitorException {
        FunctionCall functionCall = new FunctionCall(uri, new ValueExpr[0]);
        int noOfArguments = node.jjtGetNumChildren();
        if (noOfArguments > maxArgs || noOfArguments < minArgs) {
            throw new VisitorException("unexpected number of arguments (" + noOfArguments + ") for function " + uri);
        }
        for (int i = 0; i < noOfArguments; ++i) {
            Node argNode = node.jjtGetChild(i);
            functionCall.addArg((ValueExpr)argNode.jjtAccept(this, null));
        }
        return functionCall;
    }

    public TupleExpr visit(ASTQueryContainer node, Object data) throws VisitorException {
        return (TupleExpr)node.getQuery().jjtAccept(this, null);
    }

    public TupleExpr visit(ASTSelectQuery node, Object data) throws VisitorException {
        ASTOrderClause orderClause;
        ASTBindingsClause bindingsClause;
        ASTHavingClause havingClause;
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        node.getWhereClause().jjtAccept(this, null);
        TupleExpr tupleExpr = this.graphPattern.buildTupleExpr();
        Group group = null;
        ASTGroupClause groupNode = node.getGroupClause();
        if (groupNode != null) {
            tupleExpr = (TupleExpr)groupNode.jjtAccept(this, tupleExpr);
            group = (Group)tupleExpr;
        }
        if ((havingClause = node.getHavingClause()) != null) {
            if (group == null) {
                group = new Group(tupleExpr);
            }
            tupleExpr = this.processHavingClause(havingClause, tupleExpr, group);
        }
        if ((bindingsClause = node.getBindingsClause()) != null) {
            ((VariableScopeChange)tupleExpr).setVariableScopeChange(false);
            tupleExpr = new Join((TupleExpr)((BindingSetAssignment)bindingsClause.jjtAccept(this, null)), tupleExpr);
        }
        if ((orderClause = node.getOrderClause()) != null) {
            if (group == null) {
                group = new Group(tupleExpr);
            }
            tupleExpr = this.processOrderClause(node.getOrderClause(), tupleExpr, group);
        }
        tupleExpr = (TupleExpr)node.getSelect().jjtAccept(this, tupleExpr);
        ASTLimit limitNode = node.getLimit();
        long limit = -1L;
        if (limitNode != null) {
            limit = (Long)limitNode.jjtAccept(this, null);
        }
        ASTOffset offsetNode = node.getOffset();
        long offset = -1L;
        if (offsetNode != null) {
            offset = (Long)offsetNode.jjtAccept(this, null);
        }
        if (offset >= 1L || limit >= 0L) {
            tupleExpr = new Slice(tupleExpr, offset, limit);
        }
        parentGP.addRequiredTE(tupleExpr);
        this.graphPattern = parentGP;
        return tupleExpr;
    }

    private TupleExpr processHavingClause(ASTHavingClause havingNode, TupleExpr tupleExpr, Group group) throws VisitorException {
        if (havingNode != null) {
            if (group == null) {
                group = new Group(tupleExpr);
            }
            ValueExpr expr = (ValueExpr)havingNode.jjtGetChild(0).jjtAccept(this, tupleExpr);
            AggregateCollector collector = new AggregateCollector();
            collector.meetOther((QueryModelNode)expr);
            Extension extension = new Extension();
            for (AggregateOperator operator : collector.getOperators()) {
                Var var = this.createAnonVar();
                AggregateOperatorReplacer replacer = new AggregateOperatorReplacer(operator, var);
                replacer.meetOther((QueryModelNode)expr);
                String alias = var.getName();
                ExtensionElem pe = new ExtensionElem((ValueExpr)operator, alias);
                extension.addElement(pe);
                GroupElem ge = new GroupElem(alias, operator);
                group.addGroupElement(ge);
            }
            extension.setArg((TupleExpr)group);
            tupleExpr = new Filter((TupleExpr)extension, expr);
        }
        return tupleExpr;
    }

    private TupleExpr processOrderClause(ASTOrderClause orderNode, TupleExpr tupleExpr, Group group) throws VisitorException {
        if (orderNode != null) {
            List orderElements = (List)orderNode.jjtAccept(this, null);
            for (OrderElem orderElem : orderElements) {
                AggregateCollector collector = new AggregateCollector();
                collector.meet(orderElem);
                Extension extension = new Extension();
                for (AggregateOperator operator : collector.getOperators()) {
                    Var var = this.createAnonVar();
                    AggregateOperatorReplacer replacer = new AggregateOperatorReplacer(operator, var);
                    replacer.meet(orderElem);
                    String alias = var.getName();
                    ExtensionElem pe = new ExtensionElem((ValueExpr)operator, alias);
                    extension.addElement(pe);
                    GroupElem ge = new GroupElem(alias, operator);
                    group.addGroupElement(ge);
                }
                if (extension.getElements().isEmpty()) continue;
                extension.setArg(tupleExpr);
                tupleExpr = extension;
            }
            tupleExpr = new Order(tupleExpr, (Iterable)orderElements);
        }
        return tupleExpr;
    }

    public TupleExpr visit(ASTSelect node, Object data) throws VisitorException {
        TupleExpr result = (TupleExpr)data;
        Order orderClause = result instanceof Order ? (Order)result : null;
        Extension extension = new Extension();
        ProjectionElemList projElemList = new ProjectionElemList();
        GroupFinder groupFinder = new GroupFinder();
        result.visit((QueryModelVisitor)groupFinder);
        Group group = groupFinder.getGroup();
        boolean isExistingGroup = group != null;
        ArrayList<String> aliasesInProjection = new ArrayList<String>();
        for (ASTProjectionElem projElemNode : node.getProjectionElemList()) {
            ProjectionElem elem;
            Node child = projElemNode.jjtGetChild(0);
            String alias = projElemNode.getAlias();
            if (alias != null) {
                if (aliasesInProjection.contains(alias)) {
                    throw new VisitorException("duplicate use of alias '" + alias + "' in projection.");
                }
                if (result.getBindingNames().contains(alias)) {
                    throw new VisitorException("projection alias '" + alias + "' was previously used");
                }
                aliasesInProjection.add(alias);
                ValueExpr valueExpr = this.castToValueExpr(child.jjtAccept(this, null));
                if (valueExpr == null) {
                    throw new VisitorException("Either TripleRef or Expression expected in projection.");
                }
                elem = new ProjectionElem(alias);
                projElemList.addElement(elem);
                AggregateCollector collector = new AggregateCollector();
                valueExpr.visit((QueryModelVisitor)collector);
                if (!collector.getOperators().isEmpty()) {
                    elem.setAggregateOperatorInExpression(true);
                    for (AggregateOperator operator : collector.getOperators()) {
                        if (group == null) {
                            group = new Group(orderClause != null ? orderClause.getArg() : result);
                        }
                        if (operator.equals((Object)valueExpr)) {
                            group.addGroupElement(new GroupElem(alias, operator));
                            extension.setArg((TupleExpr)group);
                        } else {
                            ValueExpr expr = (ValueExpr)operator.getParentNode();
                            Extension anonymousExtension = new Extension();
                            Var anonVar = this.createAnonVar();
                            expr.replaceChildNode((QueryModelNode)operator, (QueryModelNode)anonVar);
                            anonymousExtension.addElement(new ExtensionElem((ValueExpr)operator, anonVar.getName()));
                            anonymousExtension.setArg(result);
                            result = anonymousExtension;
                            group.addGroupElement(new GroupElem(anonVar.getName(), operator));
                        }
                        if (isExistingGroup) continue;
                        result = group;
                    }
                }
                ExtensionElem extElem = new ExtensionElem(valueExpr, alias);
                extension.addElement(extElem);
                elem.setSourceExpression(extElem);
                continue;
            }
            if (child instanceof ASTVar) {
                Var projVar = (Var)child.jjtAccept(this, null);
                elem = new ProjectionElem(projVar.getName());
                projElemList.addElement(elem);
                continue;
            }
            throw new IllegalStateException("required alias for non-Var projection elements not found");
        }
        if (!extension.getElements().isEmpty()) {
            if (orderClause != null) {
                if (group != null && !isExistingGroup) {
                    extension.setArg((TupleExpr)group);
                } else {
                    extension.setArg(orderClause.getArg());
                }
                orderClause.setArg((TupleExpr)extension);
                result = orderClause;
            } else {
                extension.setArg(result);
                result = extension;
            }
        }
        result = new Projection(result, projElemList);
        if (group != null) {
            Set groupNames = group.getBindingNames();
            List elements = projElemList.getElements();
            for (ProjectionElem elem : elements) {
                if (elem.hasAggregateOperatorInExpression()) continue;
                ExtensionElem extElem = elem.getSourceExpression();
                if (extElem != null) {
                    ValueExpr expr = extElem.getExpr();
                    if (!TupleExprBuilder.isIllegalCombinedWithGroupByExpression(expr, (List<ProjectionElem>)elements, (Set<String>)groupNames)) continue;
                    throw new VisitorException("non-aggregate expression '" + String.valueOf(expr) + "' not allowed in projection when using GROUP BY.");
                }
                if (groupNames.contains(elem.getName())) continue;
                throw new VisitorException("variable '" + elem.getName() + "' in projection not present in GROUP BY.");
            }
        }
        if (node.isSubSelect()) {
            ((Projection)result).setProjectionContext(this.graphPattern.getContextVar());
        }
        if (node.isDistinct()) {
            result = new Distinct(result);
        } else if (node.isReduced()) {
            result = new Reduced(result);
        }
        return result;
    }

    private static boolean isIllegalCombinedWithGroupByExpression(ValueExpr expr, List<ProjectionElem> elements, Set<String> groupNames) {
        if (expr instanceof ValueConstant) {
            return false;
        }
        VarNameCollector varNameCollector = new VarNameCollector();
        expr.visit((QueryModelVisitor)varNameCollector);
        Set varNames = varNameCollector.getVarNames();
        for (String varName : varNames) {
            if (!TupleExprBuilder.isIllegalCombinedWithGroupByExpression(varName, elements, groupNames)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIllegalCombinedWithGroupByExpression(String varName, List<ProjectionElem> elements, Set<String> groupNames) {
        if (groupNames.contains(varName)) {
            return false;
        }
        do {
            String prev = varName;
            for (ProjectionElem element : elements) {
                if (!element.getName().equals(varName)) continue;
                if (element.hasAggregateOperatorInExpression()) {
                    return false;
                }
                ExtensionElem sourceExpression = element.getSourceExpression();
                if (sourceExpression != null && sourceExpression.getExpr() != null) {
                    return TupleExprBuilder.isIllegalCombinedWithGroupByExpression(sourceExpression.getExpr(), elements, groupNames);
                }
                varName = element.getName();
                break;
            }
            if (!prev.equals(varName)) continue;
            return true;
        } while (!groupNames.contains(varName));
        return false;
    }

    public TupleExpr visit(ASTConstructQuery node, Object data) throws VisitorException {
        ASTConstruct constructNode;
        this.graphPattern = new GraphPattern();
        node.getWhereClause().jjtAccept(this, null);
        TupleExpr tupleExpr = this.graphPattern.buildTupleExpr();
        ASTGroupClause groupNode = node.getGroupClause();
        if (groupNode != null) {
            tupleExpr = (TupleExpr)groupNode.jjtAccept(this, tupleExpr);
        }
        Group group = tupleExpr instanceof Group ? (Group)tupleExpr : new Group(tupleExpr);
        tupleExpr = this.processHavingClause(node.getHavingClause(), tupleExpr, group);
        ASTBindingsClause bindingsClause = node.getBindingsClause();
        if (bindingsClause != null) {
            tupleExpr = new Join((TupleExpr)((BindingSetAssignment)bindingsClause.jjtAccept(this, null)), tupleExpr);
        }
        tupleExpr = this.processOrderClause(node.getOrderClause(), tupleExpr, null);
        ASTLimit limitNode = node.getLimit();
        long limit = -1L;
        if (limitNode != null) {
            limit = (Long)limitNode.jjtAccept(this, null);
        }
        ASTOffset offsetNode = node.getOffset();
        long offset = -1L;
        if (offsetNode != null) {
            offset = (Long)offsetNode.jjtAccept(this, null);
        }
        if (offset >= 1L || limit >= 0L) {
            tupleExpr = new Slice(tupleExpr, offset, limit);
        }
        if (!(constructNode = node.getConstruct()).isWildcard()) {
            tupleExpr = (TupleExpr)constructNode.jjtAccept(this, tupleExpr);
        } else {
            ConstructorBuilder cb = new ConstructorBuilder();
            try {
                tupleExpr = cb.buildConstructor(tupleExpr, false, false);
            }
            catch (MalformedQueryException e) {
                throw new VisitorException(e.getMessage());
            }
        }
        return tupleExpr;
    }

    public TupleExpr visit(ASTConstruct node, Object data) throws VisitorException {
        if (TupleExprBuilder.isInvalidConstructQueryTemplate(node, true)) {
            throw new MalformedQueryException("Invalid construct clause.");
        }
        Object result = (TupleExpr)data;
        this.graphPattern = new GraphPattern();
        super.visit(node, null);
        TupleExpr constructExpr = this.graphPattern.buildTupleExpr();
        Map<String, Object> tripleRefs = TripleRefCollector.process((QueryModelNode)constructExpr);
        List<StatementPattern> statementPatterns = StatementPatternCollector.process((QueryModelNode)constructExpr);
        SameTermCollector collector = new SameTermCollector();
        constructExpr.visit((QueryModelVisitor)collector);
        if (!collector.getCollectedSameTerms().isEmpty()) {
            Set<SameTerm> sameTermConstraints = collector.getCollectedSameTerms();
            statementPatterns = this.replaceSameTermVars(statementPatterns, sameTermConstraints);
        }
        Set<Var> constructVars = this.getConstructVars((Collection<StatementPattern>)statementPatterns);
        VarCollector whereClauseVarCollector = new VarCollector();
        result.visit((QueryModelVisitor)whereClauseVarCollector);
        LinkedHashMap<Var, ExtensionElem> extElemMap = new LinkedHashMap<Var, ExtensionElem>();
        for (Var var : constructVars) {
            if (var.isAnonymous() && !extElemMap.containsKey(var)) {
                Object valueExpr = var.hasValue() ? new ValueConstant(var.getValue()) : (tripleRefs.containsKey(var.getName()) ? this.castToValueExpr(tripleRefs.get(var.getName())) : new BNodeGenerator());
                extElemMap.put(var, new ExtensionElem((ValueExpr)valueExpr, var.getName()));
                continue;
            }
            if (whereClauseVarCollector.collectedVars.contains(var) || extElemMap.containsKey(var)) continue;
            extElemMap.put(var, new ExtensionElem((ValueExpr)var.clone(), var.getName()));
        }
        if (!extElemMap.isEmpty()) {
            result = new Extension(result, extElemMap.values());
        }
        ArrayList<ProjectionElemList> projList = new ArrayList<ProjectionElemList>();
        for (StatementPattern sp : statementPatterns) {
            ProjectionElemList projElemList = new ProjectionElemList();
            projElemList.addElement(new ProjectionElem(sp.getSubjectVar().getName(), "subject"));
            projElemList.addElement(new ProjectionElem(sp.getPredicateVar().getName(), "predicate"));
            projElemList.addElement(new ProjectionElem(sp.getObjectVar().getName(), "object"));
            if (sp.getContextVar() != null) {
                projElemList.addElement(new ProjectionElem(sp.getContextVar().getName(), "context"));
            }
            projList.add(projElemList);
        }
        result = projList.size() == 1 ? new Projection(result, (ProjectionElemList)projList.get(0)) : (projList.size() > 1 ? new MultiProjection(result, projList) : new EmptySet());
        return new Reduced(result);
    }

    private static boolean isInvalidConstructQueryTemplate(Node node, boolean isInConstructTemplate) {
        if (isInConstructTemplate && TupleExprBuilder.isInvalidConstructNode(node)) {
            return true;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!TupleExprBuilder.isInvalidConstructQueryTemplate(node.jjtGetChild(i), isInConstructTemplate)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInvalidConstructNode(Node node) {
        return node instanceof ASTPathMod || node instanceof ASTPathNegatedPropertySet || node instanceof ASTPathOneInPropertySet || node instanceof ASTPathAlternative && node.jjtGetNumChildren() > 1;
    }

    private Set<Var> getConstructVars(Collection<StatementPattern> statementPatterns) {
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>(statementPatterns.size() * 2);
        for (StatementPattern sp : statementPatterns) {
            vars.add(sp.getSubjectVar());
            vars.add(sp.getPredicateVar());
            vars.add(sp.getObjectVar());
        }
        return vars;
    }

    private List<StatementPattern> replaceSameTermVars(List<StatementPattern> statementPatterns, Set<SameTerm> sameTermConstraints) {
        if (sameTermConstraints != null) {
            for (SameTerm st : sameTermConstraints) {
                Var left = (Var)st.getLeftArg();
                Var right = (Var)st.getRightArg();
                for (StatementPattern sp : statementPatterns) {
                    Var subj = sp.getSubjectVar();
                    Var obj = sp.getObjectVar();
                    if (!subj.equals((Object)left) && !subj.equals((Object)right) || !obj.equals((Object)left) && !obj.equals((Object)right)) continue;
                    sp.replaceChildNode((QueryModelNode)sp.getObjectVar(), (QueryModelNode)subj.clone());
                }
            }
        }
        return statementPatterns;
    }

    public TupleExpr visit(ASTDescribeQuery node, Object data) throws VisitorException {
        TupleExpr tupleExpr = null;
        if (node.getWhereClause() != null) {
            this.graphPattern = new GraphPattern();
            node.getWhereClause().jjtAccept(this, null);
            tupleExpr = this.graphPattern.buildTupleExpr();
            Group group = null;
            ASTGroupClause groupNode = node.getGroupClause();
            if (groupNode != null) {
                tupleExpr = (TupleExpr)groupNode.jjtAccept(this, tupleExpr);
                group = (Group)tupleExpr;
            }
            if (node.getHavingClause() != null) {
                if (group == null) {
                    group = new Group(tupleExpr);
                }
                tupleExpr = this.processHavingClause(node.getHavingClause(), tupleExpr, group);
            }
            if (node.getOrderClause() != null) {
                if (group == null) {
                    group = new Group(tupleExpr);
                }
                tupleExpr = this.processOrderClause(node.getOrderClause(), tupleExpr, group);
            }
            ASTLimit limitNode = node.getLimit();
            long limit = -1L;
            if (limitNode != null) {
                limit = (Long)limitNode.jjtAccept(this, null);
            }
            ASTOffset offsetNode = node.getOffset();
            long offset = -1L;
            if (offsetNode != null) {
                offset = (Long)offsetNode.jjtAccept(this, null);
            }
            if (offset >= 1L || limit >= 0L) {
                tupleExpr = new Slice(tupleExpr, offset, limit);
            }
        }
        return (TupleExpr)node.getDescribe().jjtAccept(this, tupleExpr);
    }

    public TupleExpr visit(ASTDescribe node, Object data) throws VisitorException {
        TupleExpr tupleExpr = (TupleExpr)data;
        if (tupleExpr == null) {
            tupleExpr = new SingletonSet();
        }
        Extension e = new Extension();
        ProjectionElemList projectionElements = new ProjectionElemList();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ValueExpr resource = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, null);
            if (resource instanceof Var) {
                projectionElements.addElement(new ProjectionElem(((Var)resource).getName()));
                continue;
            }
            String alias = "_describe_" + uniqueIdPrefix + uniqueIdSuffix.incrementAndGet();
            ExtensionElem elem = new ExtensionElem(resource, alias);
            e.addElement(elem);
            projectionElements.addElement(new ProjectionElem(alias));
        }
        if (!e.getElements().isEmpty()) {
            e.setArg(tupleExpr);
            tupleExpr = e;
        }
        Projection p = new Projection(tupleExpr, projectionElements);
        return new DescribeOperator((TupleExpr)p);
    }

    public TupleExpr visit(ASTAskQuery node, Object data) throws VisitorException {
        ASTOrderClause orderClause;
        ASTBindingsClause bindingsClause;
        ASTHavingClause havingClause;
        this.graphPattern = new GraphPattern();
        super.visit(node, null);
        TupleExpr tupleExpr = this.graphPattern.buildTupleExpr();
        tupleExpr = new Slice(tupleExpr, 0L, 1L);
        Group group = null;
        ASTGroupClause groupNode = node.getGroupClause();
        if (groupNode != null) {
            tupleExpr = (TupleExpr)groupNode.jjtAccept(this, tupleExpr);
            group = (Group)tupleExpr;
        }
        if ((havingClause = node.getHavingClause()) != null) {
            if (group == null) {
                group = new Group(tupleExpr);
            }
            tupleExpr = this.processHavingClause(havingClause, tupleExpr, group);
        }
        if ((bindingsClause = node.getBindingsClause()) != null) {
            tupleExpr = new Join((TupleExpr)((BindingSetAssignment)bindingsClause.jjtAccept(this, null)), tupleExpr);
        }
        if ((orderClause = node.getOrderClause()) != null) {
            if (group == null) {
                group = new Group(tupleExpr);
            }
            tupleExpr = this.processOrderClause(node.getOrderClause(), tupleExpr, group);
        }
        return tupleExpr;
    }

    protected ValueExpr castToValueExpr(Object node) {
        if (node instanceof ValueExpr) {
            return (ValueExpr)node;
        }
        if (node instanceof TripleRef) {
            TripleRef t = (TripleRef)node;
            return new ValueExprTripleRef(t.getExprVar().getName(), t.getSubjectVar().clone(), t.getPredicateVar().clone(), t.getObjectVar().clone());
        }
        throw new IllegalArgumentException("could not cast " + node.getClass().getName() + " to ValueExpr");
    }

    public Group visit(ASTGroupClause node, Object data) throws VisitorException {
        TupleExpr tupleExpr = (TupleExpr)data;
        Group g = new Group(tupleExpr);
        int childCount = node.jjtGetNumChildren();
        ArrayList<String> groupBindingNames = new ArrayList<String>();
        for (int i = 0; i < childCount; ++i) {
            String name = (String)node.jjtGetChild(i).jjtAccept(this, g);
            groupBindingNames.add(name);
        }
        g.setGroupBindingNames(groupBindingNames);
        return g;
    }

    @Override
    public String visit(ASTGroupCondition node, Object data) throws VisitorException {
        String name;
        Var v;
        Group group = (Group)data;
        TupleExpr arg = group.getArg();
        Extension extension = arg instanceof Extension ? (Extension)arg : new Extension();
        ValueExpr ve = this.castToValueExpr(node.jjtGetChild(0).jjtAccept(this, data));
        boolean aliased = false;
        if (node.jjtGetNumChildren() > 1) {
            aliased = true;
            v = (Var)node.jjtGetChild(1).jjtAccept(this, data);
            name = v.getName();
        } else if (ve instanceof Var) {
            name = ((Var)ve).getName();
        } else {
            aliased = true;
            v = this.createAnonVar();
            name = v.getName();
        }
        if (aliased) {
            ExtensionElem elem = new ExtensionElem(ve, name);
            extension.addElement(elem);
        }
        if (!extension.getElements().isEmpty() && !(arg instanceof Extension)) {
            extension.setArg(arg);
            group.setArg((TupleExpr)extension);
        }
        return name;
    }

    @Override
    public List<OrderElem> visit(ASTOrderClause node, Object data) throws VisitorException {
        int childCount = node.jjtGetNumChildren();
        ArrayList<OrderElem> elements = new ArrayList<OrderElem>(childCount);
        for (int i = 0; i < childCount; ++i) {
            elements.add((OrderElem)node.jjtGetChild(i).jjtAccept(this, null));
        }
        return elements;
    }

    public OrderElem visit(ASTOrderCondition node, Object data) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new OrderElem(valueExpr, node.isAscending());
    }

    @Override
    public Long visit(ASTLimit node, Object data) throws VisitorException {
        return node.getValue();
    }

    @Override
    public Long visit(ASTOffset node, Object data) throws VisitorException {
        return node.getValue();
    }

    public TupleExpr visit(ASTGraphPatternGroup node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        boolean optionalPatternInGroup = false;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (optionalPatternInGroup) {
                TupleExpr te = this.graphPattern.buildTupleExpr();
                this.graphPattern = new GraphPattern(parentGP);
                this.graphPattern.addRequiredTE(te);
                optionalPatternInGroup = false;
            }
            Node childNode = node.jjtGetChild(i);
            data = childNode.jjtAccept(this, data);
            if (!(childNode instanceof ASTOptionalGraphPattern)) continue;
            optionalPatternInGroup = true;
        }
        TupleExpr te = this.graphPattern.buildTupleExpr();
        if (node.isScopeChange()) {
            ((VariableScopeChange)te).setVariableScopeChange(true);
        }
        parentGP.addRequiredTE(te);
        this.graphPattern = parentGP;
        return te;
    }

    @Override
    public Object visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        ValueExpr serviceRef = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        this.graphPattern = new GraphPattern(parentGP);
        node.jjtGetChild(1).jjtAccept(this, null);
        TupleExpr serviceExpr = this.graphPattern.buildTupleExpr();
        if (serviceExpr instanceof SingletonSet) {
            return null;
        }
        String serviceExpressionString = node.getPatternString();
        parentGP.addRequiredTE((TupleExpr)new Service(this.mapValueExprToVar(serviceRef), serviceExpr, serviceExpressionString, node.getPrefixDeclarations(), node.getBaseURI(), node.isSilent()));
        this.graphPattern = parentGP;
        return null;
    }

    @Override
    public Object visit(ASTOptionalGraphPattern node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        super.visit(node, null);
        List<ValueExpr> optionalConstraints = this.graphPattern.removeAllConstraints();
        TupleExpr optional = this.graphPattern.buildTupleExpr();
        this.graphPattern = parentGP;
        this.graphPattern.addOptionalTE(optional, optionalConstraints);
        return null;
    }

    @Override
    public Object visit(ASTGraphGraphPattern node, Object data) throws VisitorException {
        Var oldContext = this.graphPattern.getContextVar();
        StatementPattern.Scope oldScope = this.graphPattern.getStatementPatternScope();
        ValueExpr newContext = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        this.graphPattern.setContextVar(this.mapValueExprToVar(newContext));
        this.graphPattern.setStatementPatternScope(StatementPattern.Scope.NAMED_CONTEXTS);
        node.jjtGetChild(1).jjtAccept(this, null);
        this.graphPattern.setContextVar(oldContext);
        this.graphPattern.setStatementPatternScope(oldScope);
        return null;
    }

    @Override
    public Object visit(ASTUnionGraphPattern node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        node.jjtGetChild(0).jjtAccept(this, null);
        TupleExpr leftArg = this.graphPattern.buildTupleExpr();
        this.graphPattern = new GraphPattern(parentGP);
        node.jjtGetChild(1).jjtAccept(this, null);
        TupleExpr rightArg = this.graphPattern.buildTupleExpr();
        Union union = new Union(leftArg, rightArg);
        union.setVariableScopeChange(true);
        parentGP.addRequiredTE((TupleExpr)union);
        this.graphPattern = parentGP;
        return null;
    }

    @Override
    public Object visit(ASTMinusGraphPattern node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        TupleExpr leftArg = this.graphPattern.buildTupleExpr();
        this.graphPattern = new GraphPattern(parentGP);
        node.jjtGetChild(0).jjtAccept(this, null);
        TupleExpr rightArg = this.graphPattern.buildTupleExpr();
        parentGP = new GraphPattern();
        parentGP.addRequiredTE((TupleExpr)new Difference(leftArg, rightArg));
        this.graphPattern = parentGP;
        return null;
    }

    @Override
    public Object visit(ASTPropertyList propListNode, Object data) throws VisitorException {
        Var subjVar = this.mapValueExprToVar(data);
        ValueExpr predicate = (ValueExpr)propListNode.getVerb().jjtAccept(this, null);
        List objectList = (List)propListNode.getObjectList().jjtAccept(this, null);
        Var predVar = this.mapValueExprToVar(predicate);
        for (ValueExpr object : objectList) {
            Var objVar = this.mapValueExprToVar(object);
            this.graphPattern.addRequiredSP(subjVar.clone(), predVar.clone(), objVar);
        }
        ASTPropertyList nextPropList = propListNode.getNextPropertyList();
        if (nextPropList != null) {
            nextPropList.jjtAccept(this, data);
        }
        return this.graphPattern.buildTupleExpr();
    }

    public TupleExpr visit(ASTPathAlternative pathAltNode, Object data) throws VisitorException {
        int altCount = pathAltNode.jjtGetNumChildren();
        if (altCount > 1) {
            Union union;
            Union currentUnion = union = new Union();
            for (int i = 0; i < altCount - 1; ++i) {
                TupleExpr arg = (TupleExpr)pathAltNode.jjtGetChild(i).jjtAccept(this, data);
                currentUnion.setLeftArg(arg);
                if (i == altCount - 2) {
                    arg = (TupleExpr)pathAltNode.jjtGetChild(i + 1).jjtAccept(this, data);
                    currentUnion.setRightArg(arg);
                    continue;
                }
                Union newUnion = new Union();
                currentUnion.setRightArg((TupleExpr)newUnion);
                currentUnion = newUnion;
            }
            union.setVariableScopeChange(false);
            return union;
        }
        return (TupleExpr)pathAltNode.jjtGetChild(0).jjtAccept(this, data);
    }

    @Override
    public PropertySetElem visit(ASTPathOneInPropertySet node, Object data) throws VisitorException {
        PropertySetElem result = new PropertySetElem();
        result.setInverse(node.isInverse());
        ValueConstant predicate = (ValueConstant)node.jjtGetChild(0).jjtAccept(this, data);
        result.setPredicate(predicate);
        return result;
    }

    private ASTObjectList getObjectList(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ASTPropertyListPath) {
            return ((ASTPropertyListPath)node).getObjectList();
        }
        return this.getObjectList(node.jjtGetParent());
    }

    public TupleExpr visit(ASTPathSequence pathSeqNode, Object data) throws VisitorException {
        Var subjVar;
        PathSequenceContext pathSequenceContext;
        Var parentEndVar = null;
        if (data instanceof PathSequenceContext) {
            pathSequenceContext = new PathSequenceContext((PathSequenceContext)data);
            subjVar = pathSequenceContext.startVar;
            parentEndVar = pathSequenceContext.endVar;
        } else {
            pathSequenceContext = new PathSequenceContext();
            subjVar = this.mapValueExprToVar(data);
        }
        List<ASTPathElt> pathElements = pathSeqNode.getPathElements();
        int pathLength = pathElements.size();
        GraphPattern pathSequencePattern = new GraphPattern(this.graphPattern);
        pathSequenceContext.scope = pathSequencePattern.getStatementPatternScope();
        pathSequenceContext.contextVar = pathSequencePattern.getContextVar();
        for (int i = 0; i < pathLength; ++i) {
            ASTPathElt pathElement = pathElements.get(i);
            pathSequenceContext.startVar = i == 0 ? subjVar : this.mapValueExprToVar(pathSequenceContext.endVar);
            pathSequenceContext.endVar = this.createAnonVar();
            TupleExpr elementExpresion = (TupleExpr)pathElement.jjtAccept(this, pathSequenceContext);
            if (i == pathLength - 1) {
                if (parentEndVar == null) {
                    List objectList = (List)this.getObjectList(pathSeqNode).jjtAccept(this, null);
                    for (ValueExpr objectItem : objectList) {
                        Var objectVar;
                        Var replacement = objectVar = this.mapValueExprToVar(objectItem);
                        if (objectVar.equals((Object)subjVar)) {
                            replacement = this.createAnonVar();
                        }
                        TupleExpr copy = elementExpresion.clone();
                        copy.visit((QueryModelVisitor)new VarReplacer(pathSequenceContext.endVar, replacement));
                        if (!replacement.equals((Object)objectVar)) {
                            SameTerm condition = new SameTerm((ValueExpr)objectVar, (ValueExpr)replacement);
                            pathSequencePattern.addConstraint((ValueExpr)condition);
                        }
                        pathSequencePattern.addRequiredTE(copy);
                    }
                    continue;
                }
                Var replacement = parentEndVar;
                if (parentEndVar.equals((Object)subjVar)) {
                    replacement = this.createAnonVar();
                }
                TupleExpr copy = elementExpresion.clone();
                copy.visit((QueryModelVisitor)new VarReplacer(pathSequenceContext.endVar, replacement));
                if (!replacement.equals((Object)parentEndVar)) {
                    SameTerm condition = new SameTerm((ValueExpr)parentEndVar, (ValueExpr)replacement);
                    pathSequencePattern.addConstraint((ValueExpr)condition);
                }
                pathSequencePattern.addRequiredTE(copy);
                continue;
            }
            pathSequencePattern.addRequiredTE(elementExpresion);
        }
        return pathSequencePattern.buildTupleExpr();
    }

    public TupleExpr visit(ASTPathElt pathElement, Object data) throws VisitorException {
        TupleExpr pathElementExpression;
        Var endVar;
        PathSequenceContext pathSequenceContext = (PathSequenceContext)data;
        Var startVar = pathElement.isInverse() ? pathSequenceContext.endVar : pathSequenceContext.startVar;
        Var var = endVar = pathElement.isInverse() ? pathSequenceContext.startVar : pathSequenceContext.endVar;
        if (pathElement.isNestedPath()) {
            PathSequenceContext nestedContext = new PathSequenceContext(pathSequenceContext);
            nestedContext.startVar = startVar;
            nestedContext.endVar = endVar;
            pathElementExpression = (TupleExpr)pathElement.jjtGetChild(0).jjtAccept(this, nestedContext);
        } else if (pathElement.isNegatedPropertySet()) {
            ArrayList<PropertySetElem> psElems = new ArrayList<PropertySetElem>();
            for (Node child : pathElement.jjtGetChildren()) {
                if (child instanceof ASTPathMod) continue;
                psElems.add((PropertySetElem)child.jjtAccept(this, pathSequenceContext));
            }
            pathElementExpression = this.createTupleExprForNegatedPropertySets(psElems, pathSequenceContext);
        } else {
            Var predVar = this.mapValueExprToVar(pathElement.jjtGetChild(0).jjtAccept(this, pathSequenceContext));
            pathElementExpression = new StatementPattern(pathSequenceContext.scope, startVar.clone(), predVar, endVar.clone(), pathSequenceContext.contextVar != null ? pathSequenceContext.contextVar.clone() : null);
        }
        ASTPathMod pathMod = pathElement.getPathMod();
        if (pathMod != null) {
            long lowerBound = pathMod.getLowerBound();
            long upperBound = pathMod.getUpperBound();
            if (upperBound == Long.MIN_VALUE) {
                upperBound = lowerBound;
            } else if (lowerBound == Long.MIN_VALUE) {
                lowerBound = upperBound;
            }
            pathElementExpression = this.handlePathModifiers(pathSequenceContext.scope, startVar, pathElementExpression, endVar, pathSequenceContext.contextVar != null ? pathSequenceContext.contextVar.clone() : null, lowerBound, upperBound);
        }
        return pathElementExpression;
    }

    private TupleExpr createTupleExprForNegatedPropertySets(List<PropertySetElem> nps, PathSequenceContext pathSequenceContext) {
        Var subjVar = pathSequenceContext.startVar;
        Var predVar = this.createAnonVar();
        Var endVar = pathSequenceContext.endVar;
        Compare filterCondition = null;
        Compare filterConditionInverse = null;
        for (PropertySetElem elem : nps) {
            Compare compare;
            ValueConstant predicate = elem.getPredicate();
            if (elem.isInverse()) {
                compare = new Compare((ValueExpr)predVar.clone(), (ValueExpr)predicate, Compare.CompareOp.NE);
                if (filterConditionInverse == null) {
                    filterConditionInverse = compare;
                    continue;
                }
                filterConditionInverse = new And((ValueExpr)compare, (ValueExpr)filterConditionInverse);
                continue;
            }
            compare = new Compare((ValueExpr)predVar.clone(), (ValueExpr)predicate, Compare.CompareOp.NE);
            if (filterCondition == null) {
                filterCondition = compare;
                continue;
            }
            filterCondition = new And((ValueExpr)compare, (ValueExpr)filterCondition);
        }
        StatementPattern patternMatch = new StatementPattern(pathSequenceContext.scope, subjVar.clone(), predVar.clone(), endVar.clone(), pathSequenceContext.contextVar != null ? pathSequenceContext.contextVar.clone() : null);
        StatementPattern patternMatchInverse = null;
        if (filterConditionInverse != null) {
            patternMatchInverse = new StatementPattern(pathSequenceContext.scope, endVar.clone(), predVar.clone(), subjVar.clone(), pathSequenceContext.contextVar != null ? pathSequenceContext.contextVar.clone() : null);
        }
        Object completeMatch = null;
        if (filterCondition != null) {
            completeMatch = new Filter((TupleExpr)patternMatch, (ValueExpr)filterCondition);
        }
        if (patternMatchInverse != null) {
            completeMatch = completeMatch == null ? new Filter(patternMatchInverse, (ValueExpr)filterConditionInverse) : new Union((TupleExpr)new Filter(patternMatchInverse, (ValueExpr)filterConditionInverse), (TupleExpr)completeMatch);
        }
        return completeMatch;
    }

    private TupleExpr handlePathModifiers(StatementPattern.Scope scope, Var subjVar, TupleExpr te, Var endVar, Var contextVar, long lowerBound, long upperBound) {
        if (upperBound == Long.MAX_VALUE) {
            return new ArbitraryLengthPath(scope, subjVar.clone(), te, endVar.clone(), contextVar != null ? contextVar.clone() : null, lowerBound);
        }
        if (lowerBound == 0L && upperBound == 1L) {
            Union zeroOne = new Union();
            zeroOne.setVariableScopeChange(false);
            zeroOne.setLeftArg((TupleExpr)new ZeroLengthPath(scope, subjVar.clone(), endVar.clone(), contextVar != null ? contextVar.clone() : null));
            zeroOne.setRightArg(te);
            ProjectionElemList pelist = new ProjectionElemList();
            for (String name : zeroOne.getAssuredBindingNames()) {
                ProjectionElem pe = new ProjectionElem(name);
                pelist.addElement(pe);
            }
            return new Distinct((TupleExpr)new Projection((TupleExpr)zeroOne, pelist, false));
        }
        return te;
    }

    @Override
    public Object visit(ASTPropertyListPath propListNode, Object data) throws VisitorException {
        ASTPropertyListPath nextPropList;
        Object verbPath = propListNode.getVerb().jjtAccept(this, data);
        if (verbPath instanceof Var) {
            List objectList = (List)propListNode.getObjectList().jjtAccept(this, null);
            Var subjVar = this.mapValueExprToVar(data);
            Var predVar = this.mapValueExprToVar(verbPath);
            for (ValueExpr object : objectList) {
                Var objVar = this.mapValueExprToVar(object);
                this.graphPattern.addRequiredSP(subjVar.clone(), predVar.clone(), objVar);
            }
        } else if (verbPath instanceof TupleExpr) {
            this.graphPattern.addRequiredTE((TupleExpr)verbPath);
        }
        if ((nextPropList = propListNode.getNextPropertyList()) != null) {
            nextPropList.jjtAccept(this, data);
        }
        return null;
    }

    @Override
    public List<ValueExpr> visit(ASTObjectList node, Object data) throws VisitorException {
        int childCount = node.jjtGetNumChildren();
        ArrayList<ValueExpr> result = new ArrayList<ValueExpr>(childCount);
        for (int i = 0; i < childCount; ++i) {
            Object obj = node.jjtGetChild(i).jjtAccept(this, null);
            if (obj instanceof ValueExpr) {
                result.add((ValueExpr)obj);
                continue;
            }
            if (!(obj instanceof TripleRef)) continue;
            result.add((ValueExpr)((TripleRef)obj).getExprVar());
        }
        return result;
    }

    public Var visit(ASTBlankNodePropertyList node, Object data) throws VisitorException {
        Var bnodeVar = this.createAnonVar();
        super.visit(node, (Object)bnodeVar);
        return bnodeVar;
    }

    public Var visit(ASTCollection node, Object data) throws VisitorException {
        Var rootListVar;
        Var listVar = rootListVar = this.createAnonVar();
        int childCount = node.jjtGetNumChildren();
        for (int i = 0; i < childCount; ++i) {
            ValueExpr childValue = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, null);
            this.graphPattern.addRequiredSP(listVar.clone(), TupleExprs.createConstVar((Value)RDF.FIRST), this.mapValueExprToVar(childValue));
            Var nextListVar = i == childCount - 1 ? TupleExprs.createConstVar((Value)RDF.NIL) : this.createAnonVar();
            this.graphPattern.addRequiredSP(listVar.clone(), TupleExprs.createConstVar((Value)RDF.REST), nextListVar);
            listVar = nextListVar;
        }
        return rootListVar;
    }

    @Override
    public Object visit(ASTConstraint node, Object data) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)super.visit(node, null);
        this.graphPattern.addConstraint(valueExpr);
        return valueExpr;
    }

    public Or visit(ASTOr node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new Or(leftArg, rightArg);
    }

    @Override
    public Object visit(ASTAnd node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new And(leftArg, rightArg);
    }

    public Not visit(ASTNot node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)super.visit(node, null);
        return new Not(arg);
    }

    public Coalesce visit(ASTCoalesce node, Object data) throws VisitorException {
        Coalesce coalesce = new Coalesce();
        int noOfArgs = node.jjtGetNumChildren();
        for (int i = 0; i < noOfArgs; ++i) {
            ValueExpr arg = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, data);
            coalesce.addArgument(arg);
        }
        return coalesce;
    }

    public Compare visit(ASTCompare node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new Compare(leftArg, rightArg, node.getOperator());
    }

    public FunctionCall visit(ASTSubstr node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.SUBSTRING.stringValue(), node, 2, 3);
    }

    public FunctionCall visit(ASTConcat node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.CONCAT.stringValue(), node, 1, Integer.MAX_VALUE);
    }

    public FunctionCall visit(ASTAbs node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.NUMERIC_ABS.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTCeil node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.NUMERIC_CEIL.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTContains node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.CONTAINS.stringValue(), node, 2, 2);
    }

    public FunctionCall visit(ASTFloor node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.NUMERIC_FLOOR.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTRound node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.NUMERIC_ROUND.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTRand node, Object data) throws VisitorException {
        return this.createFunctionCall("RAND", node, 0, 0);
    }

    public SameTerm visit(ASTSameTerm node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new SameTerm(leftArg, rightArg);
    }

    public Sample visit(ASTSample node, Object data) throws VisitorException {
        ValueExpr ve = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        return new Sample(ve, node.isDistinct());
    }

    public MathExpr visit(ASTMath node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new MathExpr(leftArg, rightArg, node.getOperator());
    }

    @Override
    public Object visit(ASTFunctionCall node, Object data) throws VisitorException {
        ValueConstant uriNode = (ValueConstant)node.jjtGetChild(0).jjtAccept(this, null);
        IRI functionURI = (IRI)uriNode.getValue();
        if (CustomAggregateFunctionRegistry.getInstance().has(functionURI.stringValue()) || node.isDistinct()) {
            AggregateFunctionCall aggregateCall = new AggregateFunctionCall(functionURI.stringValue(), node.isDistinct());
            if (node.jjtGetNumChildren() > 2) {
                throw new IllegalArgumentException("Custom aggregate functions cannot have more than one argument");
            }
            Node argNode = node.jjtGetChild(1);
            aggregateCall.setArg(this.castToValueExpr(argNode.jjtAccept(this, null)));
            return aggregateCall;
        }
        if (node.isDistinct()) {
            throw new IllegalArgumentException("Custom function calls cannot apply distinct iteration to args");
        }
        FunctionCall functionCall = new FunctionCall(functionURI.stringValue(), new ValueExpr[0]);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            Node argNode = node.jjtGetChild(i);
            functionCall.addArg(this.castToValueExpr(argNode.jjtAccept(this, null)));
        }
        return functionCall;
    }

    public FunctionCall visit(ASTEncodeForURI node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.ENCODE_FOR_URI.stringValue(), node, 1, 1);
    }

    @Override
    public Object visit(ASTStr node, Object data) throws VisitorException {
        ValueExpr arg = this.castToValueExpr(node.jjtGetChild(0).jjtAccept(this, null));
        return new Str(arg);
    }

    public FunctionCall visit(ASTStrDt node, Object data) throws VisitorException {
        return this.createFunctionCall("STRDT", node, 2, 2);
    }

    public FunctionCall visit(ASTStrStarts node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.STARTS_WITH.stringValue(), node, 2, 2);
    }

    public FunctionCall visit(ASTStrEnds node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.ENDS_WITH.stringValue(), node, 2, 2);
    }

    public FunctionCall visit(ASTStrLen node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.STRING_LENGTH.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTStrAfter node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.SUBSTRING_AFTER.stringValue(), node, 2, 2);
    }

    public FunctionCall visit(ASTStrBefore node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.SUBSTRING_BEFORE.stringValue(), node, 2, 2);
    }

    public FunctionCall visit(ASTUpperCase node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.UPPER_CASE.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTLowerCase node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.LOWER_CASE.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTStrLang node, Object data) throws VisitorException {
        return this.createFunctionCall("STRLANG", node, 2, 2);
    }

    public FunctionCall visit(ASTNow node, Object data) throws VisitorException {
        return this.createFunctionCall("NOW", node, 0, 0);
    }

    public FunctionCall visit(ASTYear node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.YEAR_FROM_DATETIME.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTMonth node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.MONTH_FROM_DATETIME.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTDay node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.DAY_FROM_DATETIME.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTHours node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.HOURS_FROM_DATETIME.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTMinutes node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.MINUTES_FROM_DATETIME.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTSeconds node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.SECONDS_FROM_DATETIME.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTTimezone node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.TIMEZONE_FROM_DATETIME.stringValue(), node, 1, 1);
    }

    public FunctionCall visit(ASTTz node, Object data) throws VisitorException {
        return this.createFunctionCall("TZ", node, 1, 1);
    }

    public FunctionCall visit(ASTMD5 node, Object data) throws VisitorException {
        return this.createFunctionCall("MD5", node, 1, 1);
    }

    public FunctionCall visit(ASTSHA1 node, Object data) throws VisitorException {
        return this.createFunctionCall("SHA1", node, 1, 1);
    }

    public FunctionCall visit(ASTSHA224 node, Object data) throws VisitorException {
        throw new VisitorException("hash function SHA-224 is currently not supported");
    }

    public FunctionCall visit(ASTSHA256 node, Object data) throws VisitorException {
        return this.createFunctionCall("SHA256", node, 1, 1);
    }

    public FunctionCall visit(ASTSHA384 node, Object data) throws VisitorException {
        return this.createFunctionCall("SHA384", node, 1, 1);
    }

    public FunctionCall visit(ASTSHA512 node, Object data) throws VisitorException {
        return this.createFunctionCall("SHA512", node, 1, 1);
    }

    public FunctionCall visit(ASTUUID node, Object data) throws VisitorException {
        return this.createFunctionCall("UUID", node, 0, 0);
    }

    public FunctionCall visit(ASTSTRUUID node, Object data) throws VisitorException {
        return this.createFunctionCall("STRUUID", node, 0, 0);
    }

    public IRIFunction visit(ASTIRIFunc node, Object data) throws VisitorException {
        ValueExpr expr = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        IRIFunction fn = new IRIFunction(expr);
        fn.setBaseURI(node.getBaseURI());
        return fn;
    }

    public Lang visit(ASTLang node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new Lang(arg);
    }

    public Datatype visit(ASTDatatype node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new Datatype(arg);
    }

    @Override
    public Object visit(ASTLangMatches node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new LangMatches(leftArg, rightArg);
    }

    public BindingSetAssignment visit(ASTInlineData node, Object data) throws VisitorException {
        BindingSetAssignment bsa = new BindingSetAssignment();
        List<ASTVar> varNodes = node.jjtGetChildren(ASTVar.class);
        ArrayList<Var> vars = new ArrayList<Var>(varNodes.size());
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>(varNodes.size());
        for (ASTVar varNode : varNodes) {
            Var var = (Var)varNode.jjtAccept(this, data);
            vars.add(var);
            bindingNames.add(var.getName());
        }
        bsa.setBindingNames(bindingNames);
        List<ASTBindingSet> bindingNodes = node.jjtGetChildren(ASTBindingSet.class);
        ArrayList<BindingSet> bindingSets = new ArrayList<BindingSet>(bindingNodes.size());
        for (ASTBindingSet bindingNode : bindingNodes) {
            BindingSet bindingSet = (BindingSet)bindingNode.jjtAccept(this, vars);
            bindingSets.add(bindingSet);
        }
        bsa.setBindingSets(bindingSets);
        this.graphPattern.addRequiredTE((TupleExpr)bsa);
        return bsa;
    }

    public BindingSetAssignment visit(ASTBindingsClause node, Object data) throws VisitorException {
        BindingSetAssignment bsa = new BindingSetAssignment();
        List<ASTVar> varNodes = node.jjtGetChildren(ASTVar.class);
        ArrayList<Var> vars = new ArrayList<Var>(varNodes.size());
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>(varNodes.size());
        for (ASTVar varNode : varNodes) {
            Var var = (Var)varNode.jjtAccept(this, data);
            vars.add(var);
            bindingNames.add(var.getName());
        }
        bsa.setBindingNames(bindingNames);
        List<ASTBindingSet> bindingNodes = node.jjtGetChildren(ASTBindingSet.class);
        ArrayList<BindingSet> bindingSets = new ArrayList<BindingSet>(bindingNodes.size());
        for (ASTBindingSet bindingNode : bindingNodes) {
            BindingSet bindingSet = (BindingSet)bindingNode.jjtAccept(this, vars);
            bindingSets.add(bindingSet);
        }
        bsa.setBindingSets(bindingSets);
        return bsa;
    }

    public BindingSet visit(ASTBindingSet node, Object data) throws VisitorException {
        List vars = (List)data;
        ArrayList<String> names = new ArrayList<String>(vars.size());
        for (Var var : vars) {
            names.add(var.getName());
        }
        int numberOfBindingValues = node.jjtGetNumChildren();
        if (numberOfBindingValues != vars.size()) {
            throw new VisitorException("number of values in bindingset does not match variables in BINDINGS clause");
        }
        Value[] values = new Value[numberOfBindingValues];
        for (int i = 0; i < numberOfBindingValues; ++i) {
            Value v;
            ValueExpr ve = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, null);
            if (ve == null) continue;
            values[i] = v = this.getValueForExpr(ve);
        }
        return new ListBindingSet(names, values);
    }

    public ValueExpr visit(ASTBindingValue node, Object data) throws VisitorException {
        if (node.jjtGetNumChildren() > 0) {
            return (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        }
        return null;
    }

    public ValueExpr visit(ASTBound node, Object data) throws VisitorException {
        Var var = (Var)node.getArg().jjtAccept(this, null);
        return new Bound(var);
    }

    public IsURI visit(ASTIsIRI node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new IsURI(arg);
    }

    public IsBNode visit(ASTIsBlank node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new IsBNode(arg);
    }

    public IsLiteral visit(ASTIsLiteral node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new IsLiteral(arg);
    }

    public IsNumeric visit(ASTIsNumeric node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new IsNumeric(arg);
    }

    @Override
    public Object visit(ASTBNodeFunc node, Object data) throws VisitorException {
        BNodeGenerator generator = new BNodeGenerator();
        if (node.jjtGetNumChildren() > 0) {
            ValueExpr nodeIdExpr = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
            generator.setNodeIdExpr(nodeIdExpr);
        }
        return generator;
    }

    @Override
    public Object visit(ASTRegexExpression node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr pattern = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        ValueExpr flags = null;
        if (node.jjtGetNumChildren() > 2) {
            flags = (ValueExpr)node.jjtGetChild(2).jjtAccept(this, null);
        }
        return new Regex(arg, pattern, flags);
    }

    public FunctionCall visit(ASTReplace node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.REPLACE.stringValue(), node, 3, 4);
    }

    public Exists visit(ASTExistsFunc node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        Exists e = new Exists();
        node.jjtGetChild(0).jjtAccept(this, e);
        TupleExpr te = this.graphPattern.buildTupleExpr();
        e.setSubQuery(te);
        this.graphPattern = parentGP;
        return e;
    }

    public Not visit(ASTNotExistsFunc node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        Exists e = new Exists();
        node.jjtGetChild(0).jjtAccept(this, e);
        TupleExpr te = this.graphPattern.buildTupleExpr();
        e.setSubQuery(te);
        this.graphPattern = parentGP;
        return new Not((ValueExpr)e);
    }

    public If visit(ASTIf node, Object data) throws VisitorException {
        if (node.jjtGetNumChildren() < 3) {
            throw new VisitorException("IF construction missing required number of arguments");
        }
        ValueExpr condition = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr resultExpr = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        ValueExpr alternative = (ValueExpr)node.jjtGetChild(2).jjtAccept(this, null);
        If result = new If(condition, resultExpr, alternative);
        return result;
    }

    public ValueExpr visit(ASTInfix node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, leftArg);
        return rightArg;
    }

    public ValueExpr visit(ASTIn node, Object data) throws VisitorException {
        ValueConstant result;
        ValueExpr leftArg = (ValueExpr)data;
        int listItemCount = node.jjtGetNumChildren();
        if (listItemCount == 0) {
            result = new ValueConstant((Value)BooleanLiteral.FALSE);
        } else if (listItemCount == 1) {
            ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
            result = new Compare(leftArg, arg, Compare.CompareOp.EQ);
        } else {
            ListMemberOperator listMemberOperator = new ListMemberOperator();
            listMemberOperator.addArgument(leftArg);
            for (int i = 0; i < listItemCount; ++i) {
                ValueExpr arg = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, null);
                listMemberOperator.addArgument(arg);
            }
            result = listMemberOperator;
        }
        return result;
    }

    public ValueExpr visit(ASTNotIn node, Object data) throws VisitorException {
        ValueConstant result;
        ValueExpr leftArg = (ValueExpr)data;
        int listItemCount = node.jjtGetNumChildren();
        if (listItemCount == 0) {
            result = new ValueConstant((Value)BooleanLiteral.TRUE);
        } else if (listItemCount == 1) {
            ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
            result = new Compare(leftArg, arg, Compare.CompareOp.NE);
        } else {
            And and;
            And currentAnd = and = new And();
            for (int i = 0; i < listItemCount - 1; ++i) {
                ValueExpr arg = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, null);
                currentAnd.setLeftArg((ValueExpr)new Compare(leftArg.clone(), arg, Compare.CompareOp.NE));
                if (i == listItemCount - 2) {
                    arg = (ValueExpr)node.jjtGetChild(i + 1).jjtAccept(this, null);
                    currentAnd.setRightArg((ValueExpr)new Compare(leftArg.clone(), arg, Compare.CompareOp.NE));
                    continue;
                }
                And newAnd = new And();
                currentAnd.setRightArg((ValueExpr)newAnd);
                currentAnd = newAnd;
            }
            result = and;
        }
        return result;
    }

    public Var visit(ASTVar node, Object data) throws VisitorException {
        return new Var(node.getName(), node.isAnonymous());
    }

    public ValueConstant visit(ASTIRI node, Object data) throws VisitorException {
        IRI uri;
        try {
            uri = this.valueFactory.createIRI(node.getValue());
        }
        catch (IllegalArgumentException e) {
            throw new VisitorException(e.getMessage());
        }
        return new ValueConstant((Value)uri);
    }

    @Override
    public Object visit(ASTQName node, Object data) throws VisitorException {
        throw new VisitorException("QNames must be resolved before building the query model");
    }

    @Override
    public Object visit(ASTBind node, Object data) throws VisitorException {
        ValueExpr ve;
        Object child0 = node.jjtGetChild(0).jjtAccept(this, data);
        Object object = child0 instanceof ValueExpr ? (ValueExpr)child0 : (ve = child0 instanceof TripleRef ? ((TripleRef)child0).getExprVar() : null);
        if (ve == null) {
            throw new IllegalArgumentException("Unexpected expression on bind");
        }
        Node aliasNode = node.jjtGetChild(1);
        String alias = ((ASTVar)aliasNode).getName();
        Extension extension = new Extension();
        extension.addElement(new ExtensionElem(ve.clone(), alias));
        TupleExpr arg = this.graphPattern.buildJoinFromRequiredTEs();
        arg = this.graphPattern.buildOptionalTE(arg);
        if (arg.getBindingNames().contains(alias)) {
            VarCollector collector = new VarCollector();
            arg.visit((QueryModelVisitor)collector);
            for (Var v : collector.getCollectedVars()) {
                if (!alias.equals(v.getName())) continue;
                if (v.isConstant() || v.isAnonymous()) break;
                throw new VisitorException(String.format("BIND clause alias '%s' was previously used", alias));
            }
        }
        extension.setArg(arg);
        Extension result = extension;
        this.graphPattern.clearRequiredTEs();
        this.graphPattern.addRequiredTE((TupleExpr)result);
        return result;
    }

    @Override
    public Object visit(ASTBlankNode node, Object data) throws VisitorException {
        throw new VisitorException("Blank nodes must be replaced with variables before building the query model");
    }

    public ValueConstant visit(ASTRDFLiteral node, Object data) throws VisitorException {
        Literal literal;
        String label = (String)node.getLabel().jjtAccept(this, null);
        String lang = node.getLang();
        ASTIRI datatypeNode = node.getDatatype();
        if (datatypeNode != null) {
            IRI datatype;
            try {
                datatype = this.valueFactory.createIRI(datatypeNode.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new VisitorException(e.getMessage());
            }
            literal = this.valueFactory.createLiteral(label, datatype);
        } else {
            literal = lang != null ? this.valueFactory.createLiteral(label, lang) : this.valueFactory.createLiteral(label);
        }
        return new ValueConstant((Value)literal);
    }

    public ValueConstant visit(ASTNumericLiteral node, Object data) throws VisitorException {
        Literal literal = this.valueFactory.createLiteral(node.getValue(), node.getDatatype());
        return new ValueConstant((Value)literal);
    }

    public ValueConstant visit(ASTTrue node, Object data) throws VisitorException {
        return new ValueConstant((Value)this.valueFactory.createLiteral(true));
    }

    public ValueConstant visit(ASTFalse node, Object data) throws VisitorException {
        return new ValueConstant((Value)this.valueFactory.createLiteral(false));
    }

    @Override
    public String visit(ASTString node, Object data) throws VisitorException {
        return node.getValue();
    }

    @Override
    public Object visit(ASTCount node, Object data) throws VisitorException {
        ValueExpr ve = null;
        if (node.jjtGetNumChildren() > 0) {
            ve = this.castToValueExpr(node.jjtGetChild(0).jjtAccept(this, data));
        }
        return new Count(ve, node.isDistinct());
    }

    @Override
    public Object visit(ASTGroupConcat node, Object data) throws VisitorException {
        ValueExpr ve = this.castToValueExpr(node.jjtGetChild(0).jjtAccept(this, data));
        GroupConcat gc = new GroupConcat(ve, node.isDistinct());
        if (node.jjtGetNumChildren() > 1) {
            ValueExpr separator = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, data);
            gc.setSeparator(separator);
        }
        return gc;
    }

    @Override
    public Object visit(ASTMax node, Object data) throws VisitorException {
        ValueExpr ve = this.castToValueExpr(node.jjtGetChild(0).jjtAccept(this, data));
        return new Max(ve, node.isDistinct());
    }

    @Override
    public Object visit(ASTMin node, Object data) throws VisitorException {
        ValueExpr ve = this.castToValueExpr(node.jjtGetChild(0).jjtAccept(this, data));
        return new Min(ve, node.isDistinct());
    }

    @Override
    public Object visit(ASTSum node, Object data) throws VisitorException {
        ValueExpr ve = this.castToValueExpr(node.jjtGetChild(0).jjtAccept(this, data));
        return new Sum(ve, node.isDistinct());
    }

    @Override
    public Object visit(ASTAvg node, Object data) throws VisitorException {
        ValueExpr ve = this.castToValueExpr(node.jjtGetChild(0).jjtAccept(this, data));
        return new Avg(ve, node.isDistinct());
    }

    public TupleExpr visit(ASTTripleRef node, Object data) throws VisitorException {
        TripleRef ret = new TripleRef();
        ret.setSubjectVar(this.mapValueExprToVar(node.getSubj().jjtAccept(this, ret)));
        ret.setPredicateVar(this.mapValueExprToVar(node.getPred().jjtAccept(this, ret)));
        ret.setObjectVar(this.mapValueExprToVar(node.getObj().jjtAccept(this, ret)));
        ret.setExprVar(this.createAnonVar());
        this.graphPattern.addRequiredTE((TupleExpr)ret);
        return ret;
    }

    @Override
    public Object visit(ASTTriplesSameSubjectPath node, Object data) throws VisitorException {
        return super.visit(node, data);
    }

    public ValueConstant visit(ASTConstTripleRef node, Object data) throws VisitorException {
        Triple triple;
        Resource subject = (Resource)((ValueConstant)node.getSubj().jjtAccept(this, data)).getValue();
        IRI predicate = (IRI)((ValueConstant)node.getPred().jjtAccept(this, data)).getValue();
        Value object = ((ValueConstant)node.getObj().jjtAccept(this, data)).getValue();
        try {
            triple = this.valueFactory.createTriple(subject, predicate, object);
        }
        catch (IllegalArgumentException e) {
            throw new VisitorException(e.getMessage());
        }
        return new ValueConstant((Value)triple);
    }

    static class AggregateCollector
    extends AbstractQueryModelVisitor<VisitorException> {
        private final Collection<AggregateOperator> operators = new ArrayList<AggregateOperator>();

        AggregateCollector() {
        }

        public Collection<AggregateOperator> getOperators() {
            return this.operators;
        }

        public void meet(Avg node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(Count node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(GroupConcat node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(Max node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(Min node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(Sample node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(Sum node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(AggregateFunctionCall node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        private void meetAggregate(AggregateOperator node) {
            this.operators.add(node);
        }
    }

    static class AggregateOperatorReplacer
    extends AbstractQueryModelVisitor<VisitorException> {
        private final Var replacement;
        private final AggregateOperator operator;

        public AggregateOperatorReplacer(AggregateOperator operator, Var replacement) {
            this.operator = operator;
            this.replacement = replacement;
        }

        public void meet(Avg node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(Count node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(GroupConcat node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(Max node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(Min node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(Sample node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(Sum node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        public void meet(AggregateFunctionCall node) throws VisitorException {
            super.meet(node);
            this.meetAggregate((AggregateOperator)node);
        }

        private void meetAggregate(AggregateOperator node) {
            if (node.equals((Object)this.operator)) {
                node.getParentNode().replaceChildNode((QueryModelNode)node, (QueryModelNode)this.replacement.clone());
            }
        }
    }

    private static class GroupFinder
    extends AbstractQueryModelVisitor<VisitorException> {
        private Group group;

        private GroupFinder() {
        }

        public void meet(Projection projection) {
        }

        public void meet(Group group) {
            this.group = group;
        }

        public Group getGroup() {
            return this.group;
        }
    }

    protected class SameTermCollector
    extends AbstractQueryModelVisitor<VisitorException> {
        private final Set<SameTerm> collectedSameTerms = new HashSet<SameTerm>();

        protected SameTermCollector() {
        }

        public void meet(SameTerm st) {
            this.collectedSameTerms.add(st);
        }

        public Set<SameTerm> getCollectedSameTerms() {
            return this.collectedSameTerms;
        }
    }

    protected class VarCollector
    extends AbstractQueryModelVisitor<VisitorException> {
        private final Set<Var> collectedVars = new HashSet<Var>();

        protected VarCollector() {
        }

        public void meet(Var var) {
            this.collectedVars.add(var);
        }

        public Set<Var> getCollectedVars() {
            return this.collectedVars;
        }
    }

    private static class PathSequenceContext {
        public StatementPattern.Scope scope;
        public Var contextVar;
        public Var startVar;
        public Var endVar;

        public PathSequenceContext(PathSequenceContext pathSequenceContext) {
            this.scope = pathSequenceContext.scope;
            this.contextVar = pathSequenceContext.contextVar;
            this.startVar = pathSequenceContext.startVar;
            this.endVar = pathSequenceContext.endVar;
        }

        public PathSequenceContext() {
        }
    }

    private static class VarReplacer
    extends AbstractQueryModelVisitor<VisitorException> {
        private final Var toBeReplaced;
        private final Var replacement;

        public VarReplacer(Var toBeReplaced, Var replacement) {
            this.toBeReplaced = toBeReplaced;
            this.replacement = replacement;
        }

        public void meet(Var var) {
            if (this.toBeReplaced.equals((Object)var)) {
                QueryModelNode parent = var.getParentNode();
                parent.replaceChildNode((QueryModelNode)var, (QueryModelNode)this.replacement.clone());
            }
        }

        public void meet(ProjectionElem node) throws VisitorException {
            if (node.getName().equals(this.toBeReplaced.getName())) {
                node.setName(this.replacement.getName());
            }
        }
    }
}

