/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0012\b\u0016\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0010\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/mapdb/DBException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "(Ljava/lang/String;)V", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "DataCorruption", "FileLocked", "GetVoid", "Interrupted", "NewMapDBFormat", "NotSorted", "OutOfMemory", "PointerChecksumBroken", "SerializationError", "VolumeClosed", "VolumeClosedByInterrupt", "VolumeEOF", "VolumeIOError", "VolumeMaxSizeExceeded", "WrongConfiguration", "WrongFormat", "mapdb"})
public class DBException
extends RuntimeException {
    public DBException(@Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
    }

    public DBException(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this(message, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/mapdb/DBException$DataCorruption;", "Lorg/mapdb/DBException;", "msg", "", "(Ljava/lang/String;)V", "mapdb"})
    public static class DataCorruption
    extends DBException {
        public DataCorruption(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/mapdb/DBException$FileLocked;", "Lorg/mapdb/DBException;", "path", "Ljava/nio/file/Path;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/nio/file/Path;Ljava/lang/Exception;)V", "mapdb"})
    public static final class FileLocked
    extends DBException {
        public FileLocked(@NotNull Path path, @Nullable Exception exception) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super("File is already opened and is locked: " + path, exception);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/mapdb/DBException$GetVoid;", "Lorg/mapdb/DBException;", "recid", "", "(J)V", "mapdb"})
    public static final class GetVoid
    extends DBException {
        public GetVoid(long recid2) {
            super("Record does not exist, recid=" + recid2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/mapdb/DBException$Interrupted;", "Lorg/mapdb/DBException;", "e", "Ljava/lang/InterruptedException;", "(Ljava/lang/InterruptedException;)V", "mapdb"})
    public static final class Interrupted
    extends DBException {
        public Interrupted(@NotNull InterruptedException e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super("One of threads was interrupted while accessing store", e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/mapdb/DBException$NewMapDBFormat;", "Lorg/mapdb/DBException;", "message", "", "(Ljava/lang/String;)V", "mapdb"})
    public static final class NewMapDBFormat
    extends DBException {
        public NewMapDBFormat(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }

        public /* synthetic */ NewMapDBFormat(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "Store uses feature from newer version of MapDB, this MapDB version is old does not support new feature";
            }
            this(string);
        }

        public NewMapDBFormat() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/mapdb/DBException$NotSorted;", "Lorg/mapdb/DBException;", "()V", "mapdb"})
    public static final class NotSorted
    extends DBException {
        public NotSorted() {
            super("Keys are not sorted");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/mapdb/DBException$OutOfMemory;", "Lorg/mapdb/DBException$VolumeIOError;", "e", "", "(Ljava/lang/Throwable;)V", "mapdb"})
    public static final class OutOfMemory
    extends VolumeIOError {
        public OutOfMemory(@NotNull Throwable e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super(Intrinsics.areEqual((Object)"Direct buffer memory", (Object)e.getMessage()) ? "Out of Direct buffer memory. Increase it with JVM option '-XX:MaxDirectMemorySize=10G'" : e.getMessage(), e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/mapdb/DBException$PointerChecksumBroken;", "Lorg/mapdb/DBException$DataCorruption;", "()V", "mapdb"})
    public static final class PointerChecksumBroken
    extends DataCorruption {
        public PointerChecksumBroken() {
            super("Broken bit parity");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/mapdb/DBException$SerializationError;", "Lorg/mapdb/DBException;", "e", "", "(Ljava/lang/Throwable;)V", "msg", "", "(Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "mapdb"})
    public static class SerializationError
    extends DBException {
        public SerializationError(@Nullable String msg, @Nullable Throwable e) {
            super(msg, e);
        }

        public SerializationError(@NotNull Throwable e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this(null, e);
        }

        public SerializationError(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this(msg, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/mapdb/DBException$VolumeClosed;", "Lorg/mapdb/DBException;", "e", "", "(Ljava/lang/Throwable;)V", "msg", "", "(Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "mapdb"})
    public static class VolumeClosed
    extends DBException {
        public VolumeClosed(@Nullable String msg, @Nullable Throwable e) {
            super(msg, e);
        }

        public VolumeClosed(@NotNull Throwable e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this(null, e);
        }

        public VolumeClosed(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this(msg, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/mapdb/DBException$VolumeClosedByInterrupt;", "Lorg/mapdb/DBException;", "e", "", "(Ljava/lang/Throwable;)V", "mapdb"})
    public static class VolumeClosedByInterrupt
    extends DBException {
        public VolumeClosedByInterrupt(@Nullable Throwable e) {
            super("Thread was interrupted during IO, FileChannel closed in result", e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/mapdb/DBException$VolumeEOF;", "Lorg/mapdb/DBException$VolumeIOError;", "e", "Ljava/io/IOException;", "(Ljava/io/IOException;)V", "msg", "", "(Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/io/IOException;)V", "mapdb"})
    public static class VolumeEOF
    extends VolumeIOError {
        public VolumeEOF(@Nullable String msg, @Nullable IOException e) {
            super(msg, e);
        }

        public VolumeEOF(@NotNull IOException e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this(null, e);
        }

        public VolumeEOF(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this(msg, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/mapdb/DBException$VolumeIOError;", "Lorg/mapdb/DBException;", "e", "Ljava/io/IOException;", "(Ljava/io/IOException;)V", "msg", "", "(Ljava/lang/String;)V", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "mapdb"})
    public static class VolumeIOError
    extends DBException {
        public VolumeIOError(@Nullable String msg, @Nullable Throwable e) {
            super(msg, e);
        }

        public VolumeIOError(@NotNull IOException e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this(null, e);
        }

        public VolumeIOError(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this(msg, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/mapdb/DBException$VolumeMaxSizeExceeded;", "Lorg/mapdb/DBException;", "length", "", "requestedLength", "(JJ)V", "mapdb"})
    public static final class VolumeMaxSizeExceeded
    extends DBException {
        public VolumeMaxSizeExceeded(long length, long requestedLength) {
            super("Could not expand store. Maximal store size: " + length + ", new requested size: " + requestedLength);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/mapdb/DBException$WrongConfiguration;", "Lorg/mapdb/DBException;", "message", "", "(Ljava/lang/String;)V", "mapdb"})
    public static final class WrongConfiguration
    extends DBException {
        public WrongConfiguration(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/mapdb/DBException$WrongFormat;", "Lorg/mapdb/DBException;", "msg", "", "(Ljava/lang/String;)V", "mapdb"})
    public static final class WrongFormat
    extends DBException {
        public WrongFormat(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg);
        }
    }
}

