/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks;

import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.StampedLock;

public class StampedLongAdderLockManager {
    public static final long READ_LOCK_STAMP = Long.MIN_VALUE;
    private final StampedLock stampedLock = new StampedLock();
    private final LongAdder readersLocked = new LongAdder();
    private final LongAdder readersUnlocked = new LongAdder();
    private final int tryWriteLockMillis;
    private final int writePreference;

    public StampedLongAdderLockManager() {
        this(1, 100);
    }

    public StampedLongAdderLockManager(int writePreference, int tryWriteLockMillis) {
        this.writePreference = Math.max(1, writePreference);
        this.tryWriteLockMillis = Math.max(1, tryWriteLockMillis);
    }

    public boolean isWriterActive() {
        return this.stampedLock.isWriteLocked();
    }

    public boolean isReaderActive() {
        return this.readersUnlocked.sum() != this.readersLocked.sum();
    }

    public void waitForActiveWriter() throws InterruptedException {
        while (this.stampedLock.isWriteLocked() && !this.isReaderActive()) {
            this.spinWait();
        }
    }

    public void waitForActiveReaders() throws InterruptedException {
        while (this.isReaderActive()) {
            this.spinWait();
        }
    }

    public long readLock() throws InterruptedException {
        this.readersLocked.increment();
        while (this.stampedLock.isWriteLocked()) {
            try {
                this.spinWaitAtReadLock();
            }
            catch (InterruptedException e) {
                this.readersUnlocked.increment();
                throw e;
            }
        }
        return Long.MIN_VALUE;
    }

    public long tryReadLock() {
        this.readersLocked.increment();
        if (!this.stampedLock.isWriteLocked()) {
            return Long.MIN_VALUE;
        }
        this.readersUnlocked.increment();
        return 0L;
    }

    public void unlockRead(long stamp) {
        if (stamp != Long.MIN_VALUE) {
            throw new IllegalMonitorStateException("Trying to release a stamp that is not a read lock");
        }
        VarHandle.acquireFence();
        this.readersUnlocked.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeLock() throws InterruptedException {
        long writeStamp = this.writeLockInterruptibly();
        boolean lockAcquired = false;
        try {
            int attempts = 0;
            do {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (!this.hasActiveReaders()) {
                    lockAcquired = true;
                    break;
                }
                if (attempts++ > this.writePreference) {
                    attempts = 0;
                    this.stampedLock.unlockWrite(writeStamp);
                    writeStamp = 0L;
                    this.yieldWait();
                    writeStamp = this.writeLockInterruptibly();
                    continue;
                }
                this.spinWait();
            } while (!lockAcquired);
        }
        finally {
            if (!lockAcquired && writeStamp != 0L) {
                this.stampedLock.unlockWrite(writeStamp);
            }
        }
        VarHandle.releaseFence();
        return writeStamp;
    }

    public long tryWriteLock() {
        long writeStamp = this.stampedLock.tryWriteLock();
        if (writeStamp == 0L) {
            return 0L;
        }
        if (!this.hasActiveReaders()) {
            VarHandle.releaseFence();
            return writeStamp;
        }
        this.stampedLock.unlockWrite(writeStamp);
        return 0L;
    }

    public void unlockWrite(long stamp) {
        if (stamp == 0L) {
            throw new IllegalMonitorStateException("Trying to release a write lock that is not locked");
        }
        this.stampedLock.unlockWrite(stamp);
    }

    private boolean hasActiveReaders() {
        return this.readersUnlocked.sum() != this.readersLocked.sum();
    }

    private long writeLockInterruptibly() throws InterruptedException {
        long writeStamp;
        do {
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        } while ((writeStamp = this.stampedLock.tryWriteLock(this.tryWriteLockMillis, TimeUnit.MILLISECONDS)) == 0L);
        return writeStamp;
    }

    private void spinWait() throws InterruptedException {
        Thread.onSpinWait();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private void spinWaitAtReadLock() throws InterruptedException {
        Thread.onSpinWait();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private void yieldWait() throws InterruptedException {
        Thread.yield();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }
}

