/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene.impl;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.highlight.Highlighter;
import org.eclipse.rdf4j.sail.lucene.DocumentScore;
import org.eclipse.rdf4j.sail.lucene.impl.LuceneDocumentResult;
import org.eclipse.rdf4j.sail.lucene.impl.LuceneIndex;

public class LuceneDocumentScore
extends LuceneDocumentResult
implements DocumentScore {
    private final Highlighter highlighter;

    private static Set<String> requiredFields(boolean all) {
        return all ? null : Collections.singleton("uri");
    }

    public LuceneDocumentScore(ScoreDoc doc, Highlighter highlighter, LuceneIndex index) {
        super(doc, index, LuceneDocumentScore.requiredFields(highlighter != null));
        this.highlighter = highlighter;
    }

    @Override
    public float getScore() {
        return this.scoreDoc.score;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighter != null;
    }

    @Override
    public Iterable<String> getSnippets(String field) {
        List<String> values = this.getDocument().getProperty(field);
        if (values == null) {
            return null;
        }
        return Iterables.transform(values, text -> this.index.getSnippet(field, (String)text, this.highlighter));
    }
}

