/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.ui;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.AcceleoLogger;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.compatibility.model.mt.Resource;
import org.eclipse.acceleo.compatibility.model.mt.ResourceSet;
import org.eclipse.acceleo.compatibility.model.mt.core.Metamodel;
import org.eclipse.acceleo.compatibility.model.mt.core.Script;
import org.eclipse.acceleo.compatibility.model.mt.core.Template;
import org.eclipse.acceleo.ide.ui.popupMenus.AbstractMigrateProjectWizardAction;
import org.eclipse.acceleo.internal.compatibility.mtl.gen.Mt2mtl;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.core.ProjectParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.parser.AcceleoFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class AcceleoMigrateProjectWizardAction
extends AbstractMigrateProjectWizardAction {
    private ResourceSet root;

    protected void browseTemplates(IProject[] projects) throws CoreException {
        ArrayList problems = new ArrayList();
        this.root = ProjectParser.createModel((IProject[])projects, problems);
        if (problems.size() > 0) {
            StringBuffer message = new StringBuffer();
            for (TemplateSyntaxException templateSyntaxException : problems) {
                message.append(templateSyntaxException.toString());
                message.append("\n\n");
            }
            Status status = new Status(4, "org.eclipse.acceleo.common", message.toString());
            AcceleoLogger.log((IStatus)status);
        }
    }

    protected String computeMetamodelURIs() {
        StringBuffer metamodelURIs = new StringBuffer();
        for (Resource resource : this.root.getResources()) {
            if (!(resource instanceof Metamodel)) continue;
            if (metamodelURIs.length() > 0) {
                metamodelURIs.append(',');
            }
            metamodelURIs.append(resource.getName());
        }
        return metamodelURIs.toString();
    }

    protected void generateMTL(final IPath baseFolder, final IPath mainTemplate) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    AcceleoMigrateProjectWizardAction.this.generateMTLWithProgress(baseFolder, mainTemplate, monitor);
                }
                catch (CoreException e) {
                    AcceleoLogger.log((IStatus)e.getStatus());
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.acceleo.common", e.getMessage().toString(), (Throwable)e);
                    AcceleoLogger.log((IStatus)status);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, operation);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.acceleo.common", e.getMessage(), (Throwable)e);
            AcceleoCommonPlugin.getDefault().getLog().log((IStatus)status);
        }
        catch (InterruptedException e) {
            Status status = new Status(4, "org.eclipse.acceleo.common", e.getMessage(), (Throwable)e);
            AcceleoCommonPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    protected void generateMTLWithProgress(IPath baseFolder, IPath mainTemplate, IProgressMonitor monitor) throws IOException, CoreException {
        if (baseFolder.segmentCount() > 0 && ResourcesPlugin.getWorkspace().getRoot().getProject(baseFolder.segment(0)).isAccessible()) {
            IFile mainFile;
            IContainer targetContainer;
            IFile emtFile = ResourcesPlugin.getWorkspace().getRoot().getFile(mainTemplate.removeFileExtension().addFileExtension("emt"));
            IPath emtPath = emtFile.getLocation();
            ModelUtils.save((EObject)this.root, (String)emtPath.toString());
            if (baseFolder.segmentCount() > 1) {
                targetContainer = ResourcesPlugin.getWorkspace().getRoot().getProject(baseFolder.segment(0)).getFolder(baseFolder.segment(1));
                if (!targetContainer.exists()) {
                    targetContainer = emtFile.getParent();
                }
            } else {
                targetContainer = emtFile.getParent();
            }
            File targetFolder = targetContainer.getLocation().toFile();
            Mt2mtl mt2mtl = new Mt2mtl((EObject)this.root, targetFolder, new ArrayList());
            mt2mtl.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            if (targetContainer.isAccessible()) {
                targetContainer.refreshLocal(2, monitor);
            }
            if ((mainFile = ResourcesPlugin.getWorkspace().getRoot().getFile(mainTemplate)).exists()) {
                StringBuffer buffer = FileContent.getFileContent((File)mainFile.getLocation().toFile());
                int start = buffer.indexOf("[template");
                if (start == -1) {
                    start = 0;
                }
                int iImport = start;
                int end = buffer.indexOf("[/template]", start = buffer.indexOf("]", start) + 1);
                if (end == -1) {
                    end = buffer.length();
                }
                buffer.delete(start, end);
                StringBuffer newImportContent = new StringBuffer();
                StringBuffer newTemplateContent = new StringBuffer("\n\t");
                newTemplateContent.append("[");
                newTemplateContent.append("comment");
                newTemplateContent.append(" ");
                newTemplateContent.append("@main");
                newTemplateContent.append(" ");
                newTemplateContent.append("/");
                newTemplateContent.append("]");
                newTemplateContent.append('\n');
                for (Resource resource : this.root.getResources()) {
                    if (!(resource instanceof Template)) continue;
                    Template template = (Template)resource;
                    this.computeImportAndTemplateCall(template, newImportContent, newTemplateContent);
                }
                newImportContent.append('\n');
                newTemplateContent.append('\n');
                buffer.insert(start, newTemplateContent.toString());
                buffer.insert(iImport, newImportContent.toString());
                try {
                    ByteArrayInputStream javaStream = new ByteArrayInputStream(buffer.toString().getBytes("UTF8"));
                    mainFile.setContents((InputStream)javaStream, true, false, monitor);
                }
                catch (UnsupportedEncodingException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
                }
            }
        }
    }

    private void computeImportAndTemplateCall(Template template, StringBuffer newImportContent, StringBuffer newTemplateContent) {
        String fileTemplateName = null;
        for (Script script : template.getScripts()) {
            if (script.getDescriptor() == null || script.getDescriptor().getFile() == null || script.getDescriptor().getFile().getStatements().size() <= 0) continue;
            fileTemplateName = script.getDescriptor().getName();
            break;
        }
        if (fileTemplateName != null) {
            String shortName;
            String javaPackageName;
            newImportContent.append("[import ");
            int iDot = template.getName().lastIndexOf(46);
            if (iDot > -1) {
                javaPackageName = template.getName().substring(0, iDot);
                shortName = template.getName().substring(iDot + 1);
            } else {
                javaPackageName = "";
                shortName = template.getName();
            }
            newImportContent.append(AcceleoFile.javaPackageToFullModuleName((String)javaPackageName, (String)shortName));
            newImportContent.append(" /]\n");
            newTemplateContent.append("\n\t[comment Call the file block in '");
            newTemplateContent.append(shortName);
            newTemplateContent.append("' /]\n");
            newTemplateContent.append("\t[ ");
            newTemplateContent.append(fileTemplateName);
            newTemplateContent.append("() /]\n");
        }
    }
}

