/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.operation.ToolingApiJob;
import org.eclipse.buildship.core.internal.operation.ToolingApiJobResultHandler;
import org.eclipse.buildship.core.internal.operation.ToolingApiStatus;
import org.eclipse.buildship.core.internal.util.gradle.HierarchicalElementUtils;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.GradleBuild;
import org.eclipse.buildship.core.internal.workspace.ModelProvider;
import org.eclipse.buildship.ui.internal.view.task.TaskView;
import org.eclipse.buildship.ui.internal.view.task.TaskViewContent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.model.eclipse.EclipseProject;

final class ReloadTaskViewJob
extends ToolingApiJob<TaskViewContent> {
    private final TaskView taskView;
    private final FetchStrategy modelFetchStrategy;

    public ReloadTaskViewJob(TaskView taskView, FetchStrategy modelFetchStrategy) {
        super("Loading tasks of all Gradle projects");
        this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
        this.modelFetchStrategy = (FetchStrategy)Preconditions.checkNotNull((Object)modelFetchStrategy);
        this.setResultHandler(new ResultHandler());
    }

    public TaskViewContent runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
        return this.loadContent(tokenSource, monitor);
    }

    private TaskViewContent loadContent(CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        ArrayList projects = Lists.newArrayList();
        Map<String, IProject> faultyProjects = this.allGradleWorkspaceProjects();
        for (GradleBuild gradleBuild : CorePlugin.gradleWorkspaceManager().getGradleBuilds()) {
            try {
                Set<EclipseProject> eclipseProjects = this.fetchEclipseGradleProjects(gradleBuild.getModelProvider(), tokenSource, monitor);
                for (EclipseProject eclipseProject : eclipseProjects) {
                    faultyProjects.remove(eclipseProject.getName());
                }
                projects.addAll(eclipseProjects);
            }
            catch (RuntimeException e) {
                CorePlugin.logger().warn("Tasks can't be loaded for project located at " + gradleBuild.getBuildConfig().getRootProjectDirectory().getAbsolutePath(), (Throwable)e);
            }
        }
        return new TaskViewContent(projects, Lists.newArrayList(faultyProjects.values()));
    }

    private Map<String, IProject> allGradleWorkspaceProjects() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (IProject project : CorePlugin.workspaceOperations().getAllProjects()) {
            if (!GradleProjectNature.isPresentOn((IProject)project)) continue;
            result.put(project.getName(), project);
        }
        return result;
    }

    private Set<EclipseProject> fetchEclipseGradleProjects(ModelProvider modelProvider, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        Collection models = modelProvider.fetchModels(EclipseProject.class, this.modelFetchStrategy, tokenSource, monitor);
        LinkedHashSet projects = Sets.newLinkedHashSet();
        for (EclipseProject model : models) {
            projects.addAll(HierarchicalElementUtils.getAll((EclipseProject)model));
        }
        return projects;
    }

    private void refreshTaskView(final TaskViewContent content) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ReloadTaskViewJob.this.taskView.setContent(content);
            }
        });
    }

    public boolean shouldSchedule() {
        Job[] jobs;
        for (Job job : jobs = Job.getJobManager().find((Object)"org.eclipse.buildship.core.jobs")) {
            if (!(job instanceof ReloadTaskViewJob)) continue;
            return false;
        }
        return true;
    }

    private class ResultHandler
    implements ToolingApiJobResultHandler<TaskViewContent> {
        private ResultHandler() {
        }

        public void onSuccess(TaskViewContent content) {
            ReloadTaskViewJob.this.refreshTaskView(content);
        }

        public void onFailure(ToolingApiStatus status) {
            CorePlugin.getInstance().getLog().log((IStatus)status);
        }
    }
}

