/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.ui.internal.application;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.eclipse.cft.server.core.CFApplicationArchive;
import org.eclipse.cft.server.core.internal.CFConsoleHandler;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.application.ICloudFoundryArchiver;
import org.eclipse.cft.server.core.internal.application.ZipArchive;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.standalone.core.internal.application.DeploymentErrorHandler;
import org.eclipse.cft.server.standalone.core.internal.application.StandaloneConsole;
import org.eclipse.cft.server.standalone.ui.internal.Messages;
import org.eclipse.cft.server.standalone.ui.internal.application.JarArchivingUIHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleResource;

public class JavaCloudFoundryArchiver
implements ICloudFoundryArchiver {
    private static final String META_FOLDER_NAME = "META-INF";
    private static final String MANIFEST_FILE = "MANIFEST.MF";

    protected CFConsoleHandler getConsole() {
        return StandaloneConsole.getDefault();
    }

    protected DeploymentErrorHandler getErrorHandler(IModule actualModule, CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, CFConsoleHandler consoleHandler) {
        return new DeploymentErrorHandler(actualModule, appModule, cloudServer, consoleHandler);
    }

    protected JarArchivingUIHandler getArchivingHandler(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, CFConsoleHandler console, DeploymentErrorHandler errorHandler) {
        return new JarArchivingUIHandler(appModule, cloudServer, console, errorHandler);
    }

    /*
     * Unable to fully structure code
     */
    public CFApplicationArchive getApplicationArchive(IModule module, IServer server, IModuleResource[] resources, IProgressMonitor monitor) throws CoreException {
        block31: {
            cloudServer = CloudServerUtil.getCloudServer((IServer)server);
            Assert.isNotNull((Object)module, (String)"Unable to package standalone application. No WTP module found for application. Refresh server and try again.");
            appModule = cloudServer.getExistingCloudModule(module);
            Assert.isNotNull((Object)appModule, (String)"Unable to package standalone application. No cloud application module found. Refresh server and try again.");
            this.refreshProject(module, appModule, cloudServer, monitor);
            project = this.getProject(appModule);
            projectName = project != null ? project.getName() : "UNKNOWN PROJECT";
            archive = null;
            console = this.getConsole();
            errorHandler = this.getErrorHandler(module, appModule, cloudServer, console);
            archivingHandler = this.getArchivingHandler(appModule, cloudServer, console, errorHandler);
            packagedFile = null;
            javaProject = CloudFoundryProjectUtil.getJavaProject((CloudFoundryApplicationModule)appModule);
            if (javaProject == null) {
                errorHandler.handleApplicationDeploymentFailure(Messages.JavaCloudFoundryArchiver_ERROR_NO_JAVA_PROJ_RESOLVED);
            }
            if ((mainType = (rootResolver = archivingHandler.getPackageFragmentRootHandler(javaProject, monitor)).getMainType(monitor)) != null) {
                console.printToConsole(module, cloudServer, NLS.bind((String)Messages.JavaCloudFoundryArchiver_PACKAGING_MAIN_TYPE, (Object)mainType.getFullyQualifiedName()));
            }
            if ((roots = rootResolver.getPackageFragmentRoots(monitor)) == null || roots.length == 0) {
                errorHandler.handleApplicationDeploymentFailure(Messages.JavaCloudFoundryArchiver_ERROR_NO_PACKAGE_FRAG_ROOTS);
            }
            jarPackageData = archivingHandler.getJarPackageData(roots, mainType, monitor);
            isBoot = CloudFoundryProjectUtil.isSpringBoot((CloudFoundryApplicationModule)appModule);
            metaFile = this.getManifest(roots, javaProject);
            if (!isBoot && metaFile != null) {
                jarPackageData.setJarBuilder(archivingHandler.getDefaultLibJarBuilder());
                jarPackageData.setManifestLocation(metaFile.getFullPath());
                jarPackageData.setSaveManifest(false);
                jarPackageData.setGenerateManifest(false);
                if (!jarPackageData.isManifestAccessible()) {
                    errorHandler.handleApplicationDeploymentFailure(NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_MANIFEST_NOT_ACCESSIBLE, (Object)metaFile.getLocation().toString()));
                }
                inputStream = null;
                try {
                    inputStream = new FileInputStream(metaFile.getLocation().toFile());
                    manifest = new Manifest(inputStream);
                    att = manifest.getMainAttributes();
                    if (att.getValue("Main-Class") == null) {
                        errorHandler.handleApplicationDeploymentFailure(Messages.JavaCloudFoundryArchiver_ERROR_NO_MAIN_CLASS_IN_MANIFEST);
                    }
                }
                catch (FileNotFoundException e) {
                    errorHandler.handleApplicationDeploymentFailure(NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_FAILED_READ_MANIFEST, (Object)e.getLocalizedMessage()));
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException v0) {}
                    }
                    break block31;
                }
                catch (IOException e) {
                    try {
                        errorHandler.handleApplicationDeploymentFailure(NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_FAILED_READ_MANIFEST, (Object)e.getLocalizedMessage()));
                        ** if (inputStream == null) goto lbl-1000
                    }
                    catch (Throwable var24_28) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException v2) {}
                        }
                        throw var24_28;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            inputStream.close();
                        }
                        catch (IOException v1) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block31;
                    }
                }
                ** if (inputStream == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        inputStream.close();
                    }
                    catch (IOException v3) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block31;
                }
            }
            jarPackageData.setGenerateManifest(true);
            jarPackageData.setExportOutputFolders(true);
        }
        try {
            console.printToConsole(module, cloudServer, NLS.bind((String)Messages.JavaCloudFoundryArchiver_PACKAGING_APPLICATION, (Object)projectName));
            packagedFile = archivingHandler.packageApplication(jarPackageData, monitor);
        }
        catch (CoreException e) {
            errorHandler.handleApplicationDeploymentFailure(NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_JAVA_APP_PACKAGE, (Object)e.getMessage()));
        }
        if (packagedFile == null || !packagedFile.exists()) {
            errorHandler.handleApplicationDeploymentFailure(Messages.JavaCloudFoundryArchiver_ERROR_NO_PACKAGED_FILE_CREATED);
        } else {
            console.printToConsole(module, cloudServer, NLS.bind((String)Messages.JavaCloudFoundryArchiver_PACKAGING_APPLICATION_COMPLETED, (Object)projectName, (Object)packagedFile.getAbsolutePath()));
        }
        if (isBoot) {
            console.printToConsole(module, cloudServer, Messages.JavaCloudFoundryArchiver_REPACKAGING_SPRING_BOOT_APP);
            archivingHandler.bootRepackage(roots, packagedFile);
        }
        try {
            archive = new ZipArchive(new ZipFile(packagedFile));
        }
        catch (IOException ioe) {
            errorHandler.handleApplicationDeploymentFailure(NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_CREATE_CF_ARCHIVE, (Object)ioe.getMessage()));
        }
        return archive;
    }

    protected IProject getProject(CloudFoundryApplicationModule appModule) {
        return CloudFoundryProjectUtil.getProject((CloudFoundryApplicationModule)appModule);
    }

    protected IFolder getMetaFolder(IResource resource) throws CoreException {
        if (!(resource instanceof IContainer)) {
            return null;
        }
        IContainer folder = (IContainer)resource;
        IResource[] members = folder.members();
        if (members != null) {
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource mem = iResourceArray[n2];
                if (META_FOLDER_NAME.equals(mem.getName()) && mem instanceof IFolder) {
                    return (IFolder)mem;
                }
                ++n2;
            }
        }
        return null;
    }

    protected IFile getManifest(IPackageFragmentRoot[] roots, IJavaProject javaProject) throws CoreException {
        IResource[] members;
        IFolder metaFolder = null;
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (!root.isArchive() && !root.isExternal() && (metaFolder = this.getMetaFolder(resource = root.getResource())) != null) break;
            ++n2;
        }
        if (metaFolder == null) {
            metaFolder = this.getMetaFolder((IResource)javaProject.getProject());
        }
        if (metaFolder != null && (members = metaFolder.members()) != null) {
            IResource[] iResourceArray = members;
            int n3 = members.length;
            n = 0;
            while (n < n3) {
                IResource mem = iResourceArray[n];
                if (MANIFEST_FILE.equals(mem.getName().toUpperCase()) && mem instanceof IFile) {
                    return (IFile)mem;
                }
                ++n;
            }
        }
        return null;
    }

    protected void refreshProject(IModule module, CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject(appModule);
        if (project != null && project.isAccessible()) {
            this.getConsole().printToConsole(module, cloudServer, NLS.bind((String)Messages.JavaCloudFoundryArchiver_REFRESHING_PROJECT, (Object)project.getName()));
            project.refreshLocal(2, monitor);
        }
    }
}

