/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.swt.fontprovider.IFontProvider;
import org.eclipse.emf.facet.util.swt.fontprovider.IFontProviderFactory;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Activator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public final class DefaultSizeUtils {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private static final int DEFAULT_WIDTH = 100;
    private static final int WIDTH_MARGIN = 0;
    private static final int DEFAULT_HEIGHT = 20;
    private static final int HEIGHT_MARGIN = 4;
    private static final int DEFAULT_HEADER_WIDTH = 20;
    private static final int DEFAULT_HEADER_WIDTH_PER_DIGIT = 8;
    private static final int HEADER_WIDTH_MARGIN = 4;
    private static final int DEFAULT_DPI = 96;
    private static Font headerFont = null;

    private DefaultSizeUtils() {
    }

    public static int getDefaultCellHeight() {
        return DefaultSizeUtils.getCellHeight(-1);
    }

    public static int getCellHeight(int storedHeight) {
        int height;
        if (storedHeight == -1) {
            height = (int)(20.0 * DefaultSizeUtils.getRatio()) + 4;
        } else {
            int basicHeight = Math.max(1, storedHeight) - 4;
            height = (int)((double)basicHeight * DefaultSizeUtils.getRatio() + 4.0);
        }
        if (DEBUG) {
            DebugUtils.debug((String)("height=" + height));
        }
        return height;
    }

    public static int getDefaultCellWidth() {
        return DefaultSizeUtils.getCellWidth(-1);
    }

    public static int getCellWidth(int storedWidth) {
        int width;
        if (storedWidth == -1) {
            width = (int)(100.0 * DefaultSizeUtils.getRatio()) + 0;
        } else {
            int basicWidth = Math.max(1, storedWidth) - 0;
            width = (int)((double)basicWidth * DefaultSizeUtils.getRatio() + 0.0);
        }
        if (DEBUG) {
            DebugUtils.debug((String)("width=" + width));
        }
        return width;
    }

    public static int getDefaultRowHeaderWidth() {
        int width = (int)(20.0 * DefaultSizeUtils.getRatio()) + 4;
        if (DEBUG) {
            DebugUtils.debug((String)("width=" + width));
        }
        return width;
    }

    public static int getRowHeaderWidth(int rowCount) {
        int nbDigits = String.valueOf(rowCount).length();
        int nbDigitsSensitiveWidth = 8 * nbDigits;
        int basicWidth = Math.max(20, nbDigitsSensitiveWidth);
        int width = (int)((double)basicWidth * DefaultSizeUtils.getRatio()) + 4;
        if (DEBUG) {
            DebugUtils.debug((String)("width=" + width));
        }
        return width;
    }

    public static Font getHeaderFont() {
        if (headerFont == null) {
            Font systemFont = Display.getDefault().getSystemFont();
            FontData[] fontData = systemFont.getFontData();
            FontData[] fd = (FontData[])fontData.clone();
            fd[0].setStyle(1);
            IFontProvider fontProvider = IFontProviderFactory.DEFAULT.getOrCreateIFontProvider((Device)Display.getDefault());
            headerFont = fontProvider.getFont(fd[0]);
        }
        return headerFont;
    }

    private static double getRatio() {
        int dpiX = Display.getDefault().getDPI().x;
        int dpiY = Display.getDefault().getDPI().y;
        if (DEBUG) {
            DebugUtils.debug((String)("dpi x=" + dpiX));
            DebugUtils.debug((String)("dpi y=" + dpiX));
        }
        return (double)dpiY / 96.0;
    }
}

