/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IWmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class ExtTextOut
implements IEmf2SvgConverter,
IWmf2SvgConverter {
    private static final int EMF_LOG_REF_POINT_OFFSET = 28;
    private static final int EMF_CHAR_COUNT_OFFSET = 36;
    private static final int EMF_STRING_OFFSET_OFFSET = 40;
    private static final int EMF_OPTIONS_OFFSET = 44;
    private static final int EMF_CLIP_RECT_OFFSET = 48;
    private static final int WMF_X_OFFSET = 2;
    private static final int WMF_Y_OFFSET = 0;
    private static final int WMF_COUNT_OFFSET = 4;
    private static final int WMF_FLAG_OFFSET = 6;
    private static final int WMF_CLIPRECT_OFFSET = 8;
    private static final int ETO_OPAQUE = 2;
    private static final int ETO_CLIPPED = 4;
    private boolean m_bWideCharVersion = true;
    private Point m_refPoint = null;
    private int m_options = 0;
    private Rectangle m_clipRect = null;
    private String m_text = null;

    public ExtTextOut(boolean bWideCharVersion) {
        this.m_bWideCharVersion = bWideCharVersion;
    }

    public void readWMFRecord(Record rec) throws IOException {
        short x = rec.getShortAt(2);
        short y = rec.getShortAt(0);
        short count = rec.getShortAt(4);
        short flag = rec.getShortAt(6);
        this.m_options = flag;
        this.m_refPoint = new Point(x, y);
        int offset = 8;
        if ((flag & 4) == 4) {
            this.m_clipRect = rec.getRectangeAt(8);
            offset += 8;
        } else {
            this.m_clipRect = new Rectangle();
        }
        this.m_text = new String(rec.getBytesAt(offset, count));
    }

    public void readEMFRecord(Record rec) throws IOException {
        this.m_refPoint = rec.getPointLAt(28);
        this.m_options = rec.getIntAt(44);
        this.m_clipRect = rec.getRectangleLAt(48);
        int count = rec.getIntAt(36);
        int offset = rec.getIntAt(40) - 8;
        this.m_text = this.m_bWideCharVersion ? new String(rec.getCharsAt(offset, count)) : new String(rec.getBytesAt(offset, count));
    }

    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        Rectangle2D rect;
        FontRenderContext fontRenderContext;
        Font font = context.getCurFont().getFont();
        g.setFont(font);
        Rectangle convertedClipRect = context.convertRectangleToSVGLogicalUnits(this.m_clipRect);
        Point convertedPos = context.convertPointToSVGLogicalUnits(this.m_refPoint);
        int textAlignment = context.getTextAlignment();
        if ((textAlignment & 0x18) != 24 && (textAlignment & 8) != 8) {
            convertedPos.y += font.getSize();
        }
        if ((textAlignment & 6) == 6) {
            fontRenderContext = g.getFontRenderContext();
            rect = font.getStringBounds(this.m_text, fontRenderContext);
            convertedPos.x = (int)((double)convertedPos.x - (double)((int)rect.getWidth()) / 2.0);
        } else if ((textAlignment & 2) == 2) {
            fontRenderContext = g.getFontRenderContext();
            rect = font.getStringBounds(this.m_text, fontRenderContext);
            convertedPos.x -= (int)rect.getWidth();
        }
        if ((this.m_options & 2) == 2) {
            g.setColor(context.getBackColor());
            g.fillRect(convertedClipRect.x, convertedClipRect.y, convertedClipRect.width, convertedClipRect.height);
        }
        Shape clip = null;
        if ((this.m_options & 4) == 4) {
            clip = g.getClip();
            g.clip(convertedClipRect);
        }
        g.setColor(context.getTextColor());
        int escapement = context.getCurFont().getEscapement();
        if (escapement != 0) {
            FontRenderContext fontRenderContext2 = g.getFontRenderContext();
            TextLayout layout = new TextLayout(this.m_text, font, fontRenderContext2);
            float height = (float)layout.getBounds().getHeight();
            AffineTransform rotatedText = new AffineTransform();
            rotatedText.translate(convertedPos.x, convertedPos.y);
            rotatedText.rotate(Math.toRadians(360 - escapement / 10));
            rotatedText.translate(0.0, height);
            Shape shape = layout.getOutline(rotatedText);
            GeneralPath generalPath = new GeneralPath(1);
            AffineTransform transform = new AffineTransform();
            generalPath.append(transform.createTransformedShape(shape), false);
            g.draw(shape);
        } else {
            g.drawString(this.m_text, convertedPos.x, convertedPos.y);
        }
        if ((this.m_options & 4) == 4) {
            g.setClip(clip);
        }
    }
}

