/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.linuxtools.internal.rpmstubby.AbstractGenerator;
import org.eclipse.linuxtools.internal.rpmstubby.model.EggModel;

public class StubbyEggGenerator
extends AbstractGenerator {
    private EggModel model;

    public StubbyEggGenerator(IFile eggFile) {
        this.parse(eggFile);
        this.specfileName = String.valueOf(this.model.getPackageName().toLowerCase()) + ".spec";
        this.projectName = eggFile.getProject().getName();
    }

    private void parse(IFile eggFile) {
        this.model = new EggModel(eggFile);
    }

    @Override
    public String generateSpecfile() {
        StringBuilder buffer = new StringBuilder();
        this.generateSiteLibSiteArch(buffer);
        String packageName = this.model.getPackageName();
        buffer.append("Name:           " + packageName.toLowerCase() + "\n");
        buffer.append("Version:        " + this.model.getVersion() + "\n");
        buffer.append("Release:        1%{?dist}\n");
        buffer.append("Summary:        " + this.model.getSummary() + "\n\n");
        buffer.append("Group:          Development/Libraries\n");
        buffer.append("License:        " + this.model.getLicense() + "\n");
        buffer.append("URL:            " + this.model.getURL() + "\n");
        buffer.append("Source0:        #FIXME\n\n");
        buffer.append("BuildArch:      noarch\n");
        this.generateRequires(buffer);
        buffer.append("\n%description\n" + this.model.getDescription() + "\n\n");
        this.generatePython3SubPackage(buffer);
        StubbyEggGenerator.generatePrepSection(buffer);
        StubbyEggGenerator.generateBuildSection(buffer);
        StubbyEggGenerator.generateInstallSection(buffer);
        this.generateFilesSections(buffer);
        StubbyEggGenerator.generateChangelog(buffer);
        return buffer.toString();
    }

    private void generateSiteLibSiteArch(StringBuilder buffer) {
        buffer.append("%if 0%{?fedora} > 12\n");
        buffer.append("%global with_python3 1\n");
        buffer.append("%else\n");
        buffer.append("%{!?python_sitelib: %global python_sitelib %(%{__python} -c \"from distutils.sysconfig import get_python_lib; print (get_python_lib())\")}\n");
        buffer.append("%endif\n\n");
        buffer.append("%global srcname " + this.model.getSimplePackageName().toLowerCase() + "\n\n");
    }

    private void generateRequires(StringBuilder buffer) {
        buffer.append("BuildRequires:  python2-devel\n");
        buffer.append("%if 0%{?with_python3}\n");
        buffer.append("BuildRequires:  python3-devel\n");
        buffer.append("%endif # if with_python3\n\n");
        List<String> requireList = this.model.getInstallRequiresList();
        for (String require : requireList) {
            buffer.append("Requires:       " + require + "\n");
        }
    }

    private void generatePython3SubPackage(StringBuilder buffer) {
        buffer.append("%if 0%{?with_python3}\n");
        buffer.append("%package -n python3-" + this.model.getPackageName().toLowerCase() + "\n\n");
        buffer.append("Summary:        " + this.model.getSummary() + "\n");
        buffer.append("Group:          Development/Libraries\n");
        buffer.append("\n%description -n python3-" + this.model.getPackageName().toLowerCase() + "\n" + this.model.getDescription() + "\n");
        buffer.append("%endif # with_python3\n\n");
    }

    private static void generatePrepSection(StringBuilder buffer) {
        buffer.append("\n%prep\n");
        buffer.append("%setup -q -n %{srcname}-%{version} #You may need to update this according to your Source0\n\n");
        buffer.append("%if 0%{?with_python3}\n");
        buffer.append("rm -rf %{py3dir}\n");
        buffer.append("cp -a . %{py3dir}\n");
        buffer.append("%endif # with_python3\n\n\n");
    }

    private static void generateBuildSection(StringBuilder buffer) {
        buffer.append("%build\n");
        buffer.append("%{__python} setup.py build\n\n");
        buffer.append("%if 0%{?with_python3}\n");
        buffer.append("pushd %{py3dir}\n");
        buffer.append("%{__python3} setup.py build\n");
        buffer.append("popd\n");
        buffer.append("%endif # with_python3\n\n\n");
    }

    private static void generateInstallSection(StringBuilder buffer) {
        buffer.append("%install\n");
        buffer.append("%if 0%{?with_python3}\n");
        buffer.append("pushd %{py3dir}\n");
        buffer.append("%{__python3} setup.py install --skip-build --root %{buildroot}\n");
        buffer.append("popd\n");
        buffer.append("%endif # with_python3\n\n");
        buffer.append("%{__python} setup.py install --skip-build --root %{buildroot}\n\n\n");
    }

    private void generateFilesSections(StringBuilder buffer) {
        buffer.append("%files\n");
        buffer.append("%{python_sitelib}/*\n\n");
        buffer.append("%if 0%{?with_python3}\n");
        buffer.append("%files -n python3-" + this.model.getPackageName().toLowerCase() + "\n");
        buffer.append("%{python3_sitelib}/*\n");
        buffer.append("%endif # with_python3\n\n\n");
    }
}

