/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationCompilationParticipant;
import org.eclipse.pde.ds.internal.annotations.Debug;

public class ComponentPropertyTester
extends PropertyTester {
    private static final String COMPONENT_ANNOTATION = "org.osgi.service.component.annotations.Component";
    private static final String COMPONENT_PACKAGE = DSAnnotationCompilationParticipant.ANNOTATIONS_PACKAGE;
    private static final String COMPONENT_NAME = "Component";
    private static final Debug debug = Debug.getDebug("component-property-tester");

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!"containsComponentWithImplicitName".equals(property)) {
            return false;
        }
        if (!(receiver instanceof IType) && !(receiver instanceof IPackageFragment)) {
            return false;
        }
        IJavaElement element = (IJavaElement)receiver;
        IJavaProject javaProject = element.getJavaProject();
        boolean enabled = Platform.getPreferencesService().getBoolean("org.eclipse.pde.ds.annotations", "enabled", false, new IScopeContext[]{new ProjectScope(javaProject.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE});
        if (!enabled) {
            return false;
        }
        try {
            return element.getElementType() == 7 ? this.containsImplicitName((IType)receiver) : this.containsImplicitName((IPackageFragment)receiver);
        }
        catch (JavaModelException e) {
            if (debug.isDebugging()) {
                debug.trace(String.format("Error searching for components with implicit names in element: %s", element), e);
            }
            return false;
        }
    }

    private boolean containsImplicitName(IPackageFragment fragment) throws JavaModelException {
        if (!fragment.containsJavaResources()) {
            return false;
        }
        ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            IType[] iTypeArray = cu.getAllTypes();
            int n3 = iTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IType type = iTypeArray[n4];
                if (ComponentPropertyTester.hasImplicitName(type)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private boolean containsImplicitName(IType type) throws JavaModelException {
        if (ComponentPropertyTester.hasImplicitName(type)) {
            return true;
        }
        IType[] iTypeArray = type.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType child = iTypeArray[n2];
            if (ComponentPropertyTester.hasImplicitName(child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasImplicitName(IType type) throws JavaModelException {
        IAnnotation[] annotations;
        IAnnotation[] iAnnotationArray = annotations = type.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            IMemberValuePair[] iMemberValuePairArray;
            String[][] resolved;
            IAnnotation annotation = iAnnotationArray[n2];
            boolean isComponent = COMPONENT_ANNOTATION.equals(annotation.getElementName());
            if (!isComponent && (resolved = type.resolveType(annotation.getElementName())) != null) {
                iMemberValuePairArray = resolved;
                n4 = resolved.length;
                n3 = 0;
                while (n3 < n4) {
                    IMemberValuePair pair = iMemberValuePairArray[n3];
                    if (((IMemberValuePair)pair).length == 2 && COMPONENT_PACKAGE.equals(pair[0]) && COMPONENT_NAME.equals(pair[1])) {
                        isComponent = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (isComponent) {
                IMemberValuePair[] attrs;
                iMemberValuePairArray = attrs = annotation.getMemberValuePairs();
                n4 = attrs.length;
                n3 = 0;
                while (n3 < n4) {
                    IMemberValuePair attr = iMemberValuePairArray[n3];
                    if ("name".equals(attr.getMemberName())) {
                        return false;
                    }
                    ++n3;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }
}

