/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;

public abstract class LaunchConfiguration {
    private static final Logger log = Logger.getLogger(LaunchConfiguration.class);
    private String type;

    public LaunchConfiguration(String category) {
        this.type = category;
    }

    public void apply() {
        log.info("Apply the launch configuration");
        PushButton button = new PushButton("Apply");
        button.click();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public void revert() {
        log.info("Revert the launch configuration");
        PushButton button = new PushButton("Revert");
        button.click();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public String getName() {
        return new LabeledText("Name:").getText();
    }

    public void setName(String name) {
        new LabeledText("Name:").setText(name);
    }

    public String getType() {
        return this.type;
    }
}

