/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ObservationPoint;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ConnectionAnchorOperation;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.ObservationPointSelectionPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceLaunchToolEditPolicy;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramBorderNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AirDefaultSizeNodeFigure;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.util.AnchorProvider;
import org.eclipse.sirius.viewpoint.DStylizable;

public class ObservationPointEditPart
extends DNodeEditPart {
    private DefaultSizeNodeFigure nodePlate;

    public ObservationPointEditPart(View view) {
        super(view);
    }

    public void addNotify() {
        SequenceEditPartsOperations.registerDiagramElement((IGraphicalEditPart)this, (EObject)this.resolveDiagramElement());
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        SequenceEditPartsOperations.unregisterDiagramElement((IGraphicalEditPart)this, (EObject)this.resolveDiagramElement());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return ConnectionAnchorOperation.safeCenterAnchor(super.getSourceConnectionAnchor(request));
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return ConnectionAnchorOperation.safeCenterAnchor(super.getTargetConnectionAnchor(request));
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        ObservationPointSelectionPolicy result = new ObservationPointSelectionPolicy();
        DDiagramElement dde = this.resolveDiagramElement();
        if (dde instanceof DNode) {
            DNode node = (DNode)dde;
            DiagramNodeEditPartOperation.updateResizeKind((ResizableEditPolicy)result, (DNode)node);
        }
        return result;
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        if ("PrimaryDrag Policy".equals(key)) {
            super.installEditPolicy(key, this.getPrimaryDragEditPolicy());
        } else {
            super.installEditPolicy(key, editPolicy);
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("launchTool", (EditPolicy)new SequenceLaunchToolEditPolicy());
    }

    public ObservationPoint getObservationPoint() {
        return (ObservationPoint)ISequenceElementAccessor.getObservationPoint((View)this.getNotationView()).get();
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        if (DiagramPackage.eINSTANCE.getDDiagramElement_GraphicalFilters().equals(notification.getFeature())) {
            DDiagramElement dde;
            boolean uncollapse;
            boolean collapse = notification.getNewValue() instanceof CollapseFilter && notification.getOldValue() == null;
            boolean bl = uncollapse = notification.getOldValue() instanceof CollapseFilter && notification.getNewValue() == null;
            if ((collapse || uncollapse) && (dde = this.resolveDiagramElement()) instanceof DNode) {
                DNode node = (DNode)dde;
                EditPolicy ep = this.getEditPolicy("PrimaryDrag Policy");
                if (ep instanceof ResizableEditPolicy) {
                    DiagramBorderNodeEditPartOperation.updateResizeKind((ResizableEditPolicy)((ResizableEditPolicy)ep), (DNode)node);
                }
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        DDiagramElement node = this.resolveDiagramElement();
        if (new DDiagramElementQuery(node).isCollapsed()) {
            int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Rectangle collpasedSize = new Rectangle(x, y, width, height);
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)collpasedSize);
        }
    }

    public void activate() {
        if (this.nodePlate instanceof AirDefaultSizeNodeFigure) {
            ((AirDefaultSizeNodeFigure)this.nodePlate).setZoomManager(this.getZoomManager());
        }
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
        if (this.nodePlate instanceof AirDefaultSizeNodeFigure) {
            ((AirDefaultSizeNodeFigure)this.nodePlate).setZoomManager(null);
        }
    }

    public IFigure getNodePlate() {
        return this.nodePlate;
    }

    protected NodeFigure createNodePlate() {
        ObservationPointFigure result = new ObservationPointFigure(10, 10, null);
        EObject eObj = this.resolveSemanticElement();
        if (eObj instanceof DStylizable && eObj instanceof DDiagramElement) {
            DStylizable viewNode = (DStylizable)eObj;
            StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(((DDiagramElement)eObj).getDiagramElementMapping(), viewNode.getStyle());
            AnchorProvider anchorProvider = styleConfiguration.getAnchorProvider();
            result = new ObservationPointFigure(this.getMapMode().DPtoLP(5), this.getMapMode().DPtoLP(5), anchorProvider);
            this.nodePlate = result;
        }
        return result;
    }

    private class ObservationPointFigure
    extends AirDefaultSizeNodeFigure {
        ObservationPointFigure(Dimension defSize, AnchorProvider anchorProvider) {
            super(defSize, anchorProvider);
        }

        ObservationPointFigure(int width, int height, AnchorProvider anchorProvider) {
            super(width, height, anchorProvider);
        }

        public Dimension getMinimumSize(int hint, int hint2) {
            return new Dimension(0, 0);
        }
    }
}

