/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.debug.variables.values;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIArrayEntryVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIFieldVariable;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.query.tooling.debug.common.ViatraQueryDebugValue;
import org.eclipse.viatra.query.tooling.debug.variables.ValueWrapper;

public class MatchParameterValue
extends ViatraQueryDebugValue {
    public MatchParameterValue(JDIDebugTarget debugTarget, ValueWrapper value, String ... additionalData) {
        super(debugTarget, value, additionalData);
    }

    @Override
    public String getLabel() {
        return this.additionalData[0];
    }

    @Override
    protected synchronized List<IJavaVariable> getVariablesList() throws DebugException {
        if (this.fVariables != null) {
            return this.fVariables;
        }
        if (this.fValue.isReference()) {
            this.fVariables = new ArrayList();
            if (this.fValue.isArray()) {
                int length = this.fValue.getArrayLength();
                int i = 0;
                while (i < length) {
                    this.fVariables.add(new JDIArrayEntryVariable(this.getJavaDebugTarget(), (ArrayReference)this.fValue.getValue(), i, this.fLogicalParent));
                    ++i;
                }
            } else {
                List<Field> fields = null;
                try {
                    ReferenceType refType = ((ObjectReference)this.fValue.getValue()).referenceType();
                    fields = refType.allFields();
                }
                catch (ObjectCollectedException e) {
                    ViatraQueryLoggingUtil.getLogger(MatchParameterValue.class).error((Object)"Couldn't retrieve the list of debug variables!", (Throwable)e);
                    return Collections.emptyList();
                }
                catch (RuntimeException e) {
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIValue_exception_retrieving_fields, e.toString()), e);
                    ViatraQueryLoggingUtil.getLogger(MatchParameterValue.class).error((Object)"Couldn't retrieve the list of debug variables!", (Throwable)e);
                    return Collections.emptyList();
                }
                for (Field field : fields) {
                    this.fVariables.add(new JDIFieldVariable((JDIDebugTarget)this.getDebugTarget(), field, (ObjectReference)this.fValue.getValue(), this.fLogicalParent));
                }
                Collections.sort(this.fVariables, (arg_0, arg_1) -> ((MatchParameterValue)this).sortChildren(arg_0, arg_1));
            }
            return this.fVariables;
        }
        return Collections.emptyList();
    }
}

