/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.model.IASTObjectInfo2;
import org.eclipse.wb.internal.core.databinding.ui.editor.ICompleteListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public final class BindingContentProvider
implements IUiContentProvider {
    private final Set<String> m_fields = Sets.newHashSet();
    private final IASTObjectInfo2 m_binding;
    private final JavaInfo m_javaInfoRoot;
    private ExpandableComposite m_expandableComposite;
    private Button m_assignButton;
    private Text m_fieldNameText;
    private String m_fieldName;
    private ICompleteListener m_listener;
    private String m_errorMessage;

    public BindingContentProvider(IASTObjectInfo2 binding, JavaInfo javaInfoRoot) {
        this.m_binding = binding;
        this.m_javaInfoRoot = javaInfoRoot;
        TypeDeclaration rootNode = JavaInfoUtils.getTypeDeclaration((JavaInfo)this.m_javaInfoRoot);
        FieldDeclaration[] fieldDeclarationArray = rootNode.getFields();
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration field = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : DomGenerics.fragments((FieldDeclaration)field)) {
                this.m_fields.add(fragment.getName().getIdentifier());
            }
            ++n2;
        }
    }

    public void setCompleteListener(ICompleteListener listener) {
        this.m_listener = listener;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void createContent(final Composite parent, int columns) {
        this.m_expandableComposite = new ExpandableComposite(parent, 0);
        this.m_expandableComposite.setText(Messages.BindingContentProvider_binding);
        this.m_expandableComposite.setExpanded(true);
        GridDataFactory.create((Control)this.m_expandableComposite).fillH().grabH().spanH(columns);
        this.m_expandableComposite.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (BindingContentProvider.this.m_expandableComposite.isExpanded()) {
                    BindingContentProvider.this.m_expandableComposite.setText(Messages.BindingContentProvider_bindingDots);
                } else {
                    BindingContentProvider.this.m_expandableComposite.setText(Messages.BindingContentProvider_binding);
                }
            }

            public void expansionStateChanged(ExpansionEvent e) {
                parent.layout();
            }
        });
        Composite clientComposite = new Composite((Composite)this.m_expandableComposite, 0);
        GridLayoutFactory.create((Composite)clientComposite).columns(2).noMargins();
        this.m_expandableComposite.setClient((Control)clientComposite);
        this.m_assignButton = new Button(clientComposite, 32);
        this.m_assignButton.setText(Messages.BindingContentProvider_assignButton);
        this.m_fieldNameText = new Text(clientComposite, 2052);
        GridDataFactory.create((Control)this.m_fieldNameText).fillH().grabH();
        this.m_fieldNameText.setEnabled(false);
        this.m_fieldNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BindingContentProvider.this.calculateAssignComplete();
            }
        });
        this.m_assignButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingContentProvider.this.m_fieldNameText.setEnabled(BindingContentProvider.this.m_assignButton.getSelection());
                if (BindingContentProvider.this.m_assignButton.getSelection()) {
                    BindingContentProvider.this.m_fieldNameText.setFocus();
                }
                BindingContentProvider.this.calculateAssignComplete();
            }
        });
    }

    private void calculateAssignComplete() {
        IStatus status;
        String fieldName;
        this.m_errorMessage = this.m_assignButton.getSelection() ? ((fieldName = this.m_fieldNameText.getText()).length() == 0 ? Messages.BindingContentProvider_validateEmptyFieldName : (fieldName.equals(this.m_fieldName) || !this.m_fields.contains(fieldName) ? ((status = JavaConventions.validateIdentifier((String)fieldName, null, null)).matches(4) ? status.getMessage() : null) : Messages.BindingContentProvider_validateExistingFieldName)) : null;
        this.m_listener.calculateFinish();
    }

    public void updateFromObject() throws Exception {
        this.m_fieldName = this.m_binding.getVariableIdentifier();
        if (this.m_binding.isField()) {
            this.m_expandableComposite.setExpanded(true);
            this.m_expandableComposite.setText(Messages.BindingContentProvider_binding);
            this.m_assignButton.setSelection(true);
            this.m_fieldNameText.setText(this.m_fieldName);
            this.m_fieldNameText.setEnabled(true);
        }
        this.calculateAssignComplete();
    }

    public void saveToObject() throws Exception {
        boolean field = this.m_assignButton.getSelection();
        this.m_binding.setVariableIdentifier(this.m_javaInfoRoot, field ? this.m_fieldNameText.getText() : null, field);
    }
}

