/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.ui.UiUtils;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.CheckboxTableViewerWrapper;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassAndPropertiesConfiguration;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassAndPropertiesRouter;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassAndPropertiesSupportListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ICheckboxViewerWrapper;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.PropertyAdapter;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.TreeTransfer;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChooseClassAndPropertiesUiContentProvider
extends ChooseClassUiContentProvider {
    protected final ChooseClassAndPropertiesConfiguration m_configuration;
    private ICheckboxViewerWrapper m_propertiesViewer;
    protected Label m_propertiesLabel;
    private Button m_selectAllButton;
    private Button m_deselectAllButton;
    private Button m_upButton;
    private Button m_downButton;
    private List<PropertyAdapter> m_properties = Collections.emptyList();
    protected Class<?> m_choosenClass;
    private PropertyAdapter m_dragObject;
    private PropertyAdapter m_defaultProperty;
    private ChooseClassAndPropertiesSupportListener m_supportListener;
    private ChooseClassAndPropertiesRouter m_router;

    public ChooseClassAndPropertiesUiContentProvider(ChooseClassAndPropertiesConfiguration configuration) {
        super(configuration);
        this.m_configuration = configuration;
    }

    public final ICheckboxViewerWrapper getPropertiesViewer() {
        return this.m_propertiesViewer;
    }

    public final void setSupportListener(ChooseClassAndPropertiesSupportListener supportListener) {
        this.m_supportListener = supportListener;
    }

    final void setRouter(ChooseClassAndPropertiesRouter router) {
        this.m_router = router;
    }

    protected void super_createContent(Composite parent, int columns) {
        super.createContent(parent, columns);
    }

    @Override
    public void createContent(Composite parent, int columns) {
        this.super_createContent(parent, columns);
        this.m_propertiesLabel = new Label(parent, 0);
        String propertiesLabelText = this.m_configuration.getPropertiesLabel();
        if (propertiesLabelText != null) {
            this.m_propertiesLabel.setText(propertiesLabelText);
        }
        Control viewers = this.createViewers(parent);
        this.m_propertiesViewer.getCheckable().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!ChooseClassAndPropertiesUiContentProvider.this.m_configuration.isPropertiesMultiChecked() && event.getChecked()) {
                    ChooseClassAndPropertiesUiContentProvider.this.m_propertiesViewer.setCheckedElements(new Object[]{event.getElement()});
                }
                ChooseClassAndPropertiesUiContentProvider.this.calculatePropertiesFinish();
            }
        });
        GridDataFactory.create((Control)viewers).fill().grab().spanH(columns - 1).minVC(5);
        if (this.m_configuration.isReorderMode()) {
            GridDataFactory.modify((Control)viewers).spanV(3);
            this.configureDND();
            this.m_propertiesViewer.getViewer().addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ChooseClassAndPropertiesUiContentProvider.this.calculateUpDowButtons();
                }
            });
            new Label(parent, 0);
            Composite buttonsComposite = new Composite(parent, 0);
            GridLayoutFactory.create((Composite)buttonsComposite).marginsH(0).spacingH(0);
            GridDataFactory.create((Control)buttonsComposite).alignHR().alignVM();
            if (this.m_configuration.isPropertiesMultiChecked() && this.m_configuration.isShowSelectionButtons()) {
                this.m_selectAllButton = new Button(buttonsComposite, 0);
                GridDataFactory.create((Control)this.m_selectAllButton).fillH();
                this.m_selectAllButton.setText(Messages.ChooseClassAndPropertiesUiContentProvider_selectAllButton);
                this.m_selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ChooseClassAndPropertiesUiContentProvider.this.handleAllSelection(true);
                    }
                });
                this.m_deselectAllButton = new Button(buttonsComposite, 0);
                GridDataFactory.create((Control)this.m_deselectAllButton).fillH();
                this.m_deselectAllButton.setText(Messages.ChooseClassAndPropertiesUiContentProvider_deselectAllButton);
                this.m_deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ChooseClassAndPropertiesUiContentProvider.this.handleAllSelection(false);
                    }
                });
            }
            this.m_upButton = new Button(buttonsComposite, 0);
            GridDataFactory.create((Control)this.m_upButton).fillH();
            this.m_upButton.setText(Messages.ChooseClassAndPropertiesUiContentProvider_upButton);
            this.m_upButton.setEnabled(false);
            this.m_upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChooseClassAndPropertiesUiContentProvider.this.handleMoveElement(true);
                }
            });
            this.m_downButton = new Button(buttonsComposite, 0);
            GridDataFactory.create((Control)this.m_downButton).fillH();
            this.m_downButton.setText(Messages.ChooseClassAndPropertiesUiContentProvider_downButton);
            this.m_downButton.setEnabled(false);
            this.m_downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChooseClassAndPropertiesUiContentProvider.this.handleMoveElement(false);
                }
            });
        }
    }

    protected Control createViewers(Composite parent) {
        this.setPropertiesViewer(this.createPropertiesViewer(parent));
        return this.m_propertiesViewer.getViewer().getControl();
    }

    protected final void setPropertiesViewer(ICheckboxViewerWrapper propertiesViewer) {
        this.m_propertiesViewer = propertiesViewer;
    }

    protected ICheckboxViewerWrapper createPropertiesViewer(Composite parent) {
        CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68352);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setLabelProvider(this.m_configuration.getPropertiesLabelProvider());
        return new CheckboxTableViewerWrapper(tableViewer);
    }

    protected void configureDND() {
        this.configureDND(this.m_propertiesViewer.getViewer(), this.m_properties);
    }

    protected final void configureDND(final StructuredViewer viewer, final List<PropertyAdapter> properties) {
        Transfer[] transfers = new Transfer[]{TreeTransfer.INSTANCE};
        viewer.addDragSupport(2, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                event.doit = properties.size() > 1;
                ChooseClassAndPropertiesUiContentProvider.this.m_dragObject = (PropertyAdapter)UiUtils.getSelection((Viewer)viewer).getFirstElement();
            }

            public void dragSetData(DragSourceEvent event) {
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        viewer.addDropSupport(2, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)viewer){

            protected int determineLocation(DropTargetEvent event) {
                return 3;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return ChooseClassAndPropertiesUiContentProvider.this.m_dragObject != target && target != null;
            }

            public boolean performDrop(Object data) {
                int sourceIndex = properties.indexOf(ChooseClassAndPropertiesUiContentProvider.this.m_dragObject);
                int targetIndex = properties.indexOf(this.getCurrentTarget());
                properties.remove(sourceIndex);
                properties.add(targetIndex, ChooseClassAndPropertiesUiContentProvider.this.m_dragObject);
                viewer.refresh();
                ChooseClassAndPropertiesUiContentProvider.this.calculateUpDowButtons();
                return true;
            }
        });
    }

    protected void calculateUpDowButtons() {
        this.calculateUpDowButtons(this.m_propertiesViewer.getViewer(), this.m_properties);
    }

    protected final void calculateUpDowButtons(StructuredViewer viewer, List<?> properties) {
        int lastIndex;
        IStructuredSelection selection = UiUtils.getSelection((Viewer)viewer);
        boolean up = false;
        boolean down = false;
        if (!UiUtils.isEmpty((ISelection)selection) && (lastIndex = properties.size() - 1) > 0) {
            int elementIndex = properties.indexOf(selection.getFirstElement());
            up = elementIndex > 0;
            down = elementIndex < lastIndex;
        }
        this.m_upButton.setEnabled(up);
        this.m_downButton.setEnabled(down);
    }

    protected void handleMoveElement(boolean up) {
        this.handleMoveElement(up, this.m_propertiesViewer.getViewer(), this.m_properties);
    }

    protected final void handleMoveElement(boolean up, StructuredViewer viewer, List<?> properties) {
        IStructuredSelection selection = UiUtils.getSelection((Viewer)viewer);
        int elementIndex = properties.indexOf(selection.getFirstElement());
        int newElementIndex = up ? elementIndex - 1 : elementIndex + 1;
        Collections.swap(properties, elementIndex, newElementIndex);
        viewer.refresh();
        this.calculateUpDowButtons();
    }

    private void handleAllSelection(boolean selection) {
        if (!this.m_properties.isEmpty()) {
            this.m_propertiesViewer.setAllChecked(selection);
            this.calculatePropertiesFinish();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void calculateFinish() {
        String className = this.getClassName();
        if (this.m_configuration.isDefaultString(className)) {
            this.m_choosenClass = null;
            this.m_properties = Lists.newArrayList();
            this.m_properties.add(this.m_defaultProperty);
            this.m_propertiesViewer.getViewer().setInput(this.m_properties);
            this.m_propertiesViewer.setCheckedElements(new Object[]{this.m_defaultProperty});
            this.setErrorMessage(null);
            if (this.m_router == null) return;
            this.m_router.handle();
            return;
        } else {
            super.calculateFinish();
            if (this.getErrorMessage() == null) {
                try {
                    try {
                        this.m_choosenClass = this.loadClass(className);
                        this.m_properties = this.getProperties(this.m_choosenClass);
                        this.m_properties = this.m_configuration.filterProperties(this.m_choosenClass, this.m_properties);
                        this.m_propertiesViewer.getViewer().setInput(this.m_properties);
                        if (!this.m_properties.isEmpty()) {
                            switch (this.m_configuration.getLoadedPropertiesCheckedStrategy()) {
                                case First: {
                                    this.m_propertiesViewer.setCheckedElements(new Object[]{this.m_properties.get(0)});
                                    break;
                                }
                                case Last: {
                                    this.m_propertiesViewer.setCheckedElements(new Object[]{this.m_properties.get(this.m_properties.size() - 1)});
                                    break;
                                }
                                case All: {
                                    this.m_propertiesViewer.setCheckedElements(this.m_properties.toArray());
                                    break;
                                }
                                case None: {
                                    this.m_propertiesViewer.setCheckedElements(ArrayUtils.EMPTY_OBJECT_ARRAY);
                                }
                            }
                        }
                        if (this.m_supportListener == null) return;
                        this.m_supportListener.loadProperties(true);
                        return;
                    }
                    catch (Throwable e) {
                        this.setEmptyProperties();
                        this.calculatePropertiesFinish();
                    }
                    return;
                }
                finally {
                    this.calculatePropertiesFinish();
                }
            } else {
                this.setEmptyProperties();
                if (this.m_router == null) return;
                this.m_router.handle();
            }
        }
    }

    private void setEmptyProperties() {
        this.m_choosenClass = null;
        this.m_properties = Collections.emptyList();
        this.m_propertiesViewer.getViewer().setInput(this.m_properties);
        this.m_propertiesViewer.setCheckedElements(ArrayUtils.EMPTY_OBJECT_ARRAY);
        if (this.m_supportListener != null) {
            this.m_supportListener.loadProperties(false);
        }
    }

    protected final void calculatePropertiesFinish() {
        Object[] checkedElements = this.m_propertiesViewer.getCheckedElements();
        if (checkedElements.length == 0) {
            this.setErrorMessage(this.m_configuration.getPropertiesErrorMessage());
        } else {
            this.setErrorMessage(null);
        }
        if (this.m_router != null) {
            this.m_router.handle();
        }
    }

    protected abstract List<PropertyAdapter> getProperties(Class<?> var1) throws Exception;

    @Override
    public Class<?> getChoosenClass() throws Exception {
        return this.m_choosenClass;
    }

    protected final void setClassNameAndProperty(String className, PropertyAdapter property, boolean loadClass) {
        if (!loadClass) {
            this.m_defaultProperty = property;
        }
        this.setClassName(className);
        if (loadClass) {
            if (property != null) {
                this.m_propertiesViewer.getCheckable().setChecked((Object)property, true);
            }
            this.calculatePropertiesFinish();
        }
    }

    protected final void setClassNameAndProperties(String className, List<PropertyAdapter> properties) {
        this.setClassName(className);
        for (PropertyAdapter property : properties) {
            this.m_propertiesViewer.getCheckable().setChecked((Object)property, true);
        }
        this.calculatePropertiesFinish();
    }

    List<PropertyAdapter> getChoosenProperties0() {
        ArrayList properties = Lists.newArrayList();
        CollectionUtils.addAll((Collection)properties, (Object[])this.m_propertiesViewer.getCheckedElements());
        return properties;
    }

    protected List<PropertyAdapter> getChoosenProperties() {
        return this.getChoosenProperties0();
    }

    @Override
    public final void saveToObject() throws Exception {
        this.saveToObject(this.m_choosenClass, this.getChoosenProperties());
    }

    protected abstract void saveToObject(Class<?> var1, List<PropertyAdapter> var2) throws Exception;
}

