/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public class WhileClosure<A>
implements Closure<A> {
    private final Predicate<? super A> predicate;
    private final Closure<? super A> closure;

    public WhileClosure(Predicate<? super A> predicate, Closure<? super A> closure) {
        if (predicate == null || closure == null) {
            throw new NullPointerException();
        }
        this.predicate = predicate;
        this.closure = closure;
    }

    @Override
    public void execute(A argument) {
        while (this.predicate.evaluate(argument)) {
            this.closure.execute(argument);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.predicate);
    }
}

