/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;

public class DependentJarExportMerger {
    protected Archive outgoingArchive;
    protected IProject project;
    protected List dependentArchives;
    protected boolean includeSource;

    public DependentJarExportMerger(Archive archive, IProject aProject, boolean includeSourceFiles) {
        this.outgoingArchive = archive;
        this.project = aProject;
        this.includeSource = includeSourceFiles;
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public void merge() {
        String[] cp = this.outgoingArchive.getManifest().getClassPathTokenized();
        this.dependentArchives = new ArrayList(cp.length);
        ArrayList<String> keepClassPaths = new ArrayList<String>();
        int i = 0;
        while (i < cp.length) {
            block7: {
                Archive dependentJar = null;
                IFile file = null;
                try {
                    file = this.project.getFile(cp[i]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    break block7;
                }
                if (file.exists() && cp[i].endsWith(".imported_classes.jar")) {
                    try {
                        dependentJar = this.getArchiveFactory().primOpenArchive(file.getLocation().toOSString());
                    }
                    catch (OpenFailureException ex) {
                        J2EEPlugin.logError(ex);
                        break block7;
                    }
                    this.dependentArchives.add(dependentJar);
                    this.mergeFiles(dependentJar);
                } else {
                    keepClassPaths.add(cp[i]);
                }
            }
            ++i;
        }
        this.resetClassPath(keepClassPaths);
    }

    protected void mergeFiles(Archive dependentJar) {
        EList files = dependentJar.getFiles();
        ArrayList<File> filesToAdd = new ArrayList<File>();
        int i = 0;
        while (i < files.size()) {
            File aFile = (File)files.get(i);
            if (this.shouldMerge(aFile)) {
                filesToAdd.add(aFile);
            }
            ++i;
        }
        try {
            this.outgoingArchive.addCopyFiles(filesToAdd);
        }
        catch (DuplicateObjectException duplicateObjectException) {}
    }

    public void release() {
        if (this.dependentArchives == null) {
            return;
        }
        int i = 0;
        while (i < this.dependentArchives.size()) {
            Archive anArchive = (Archive)this.dependentArchives.get(i);
            if (anArchive.isOpen()) {
                anArchive.close();
            }
            ++i;
        }
    }

    protected void resetClassPath(List cp) {
        ArchiveManifest mf = this.outgoingArchive.getManifest();
        if (cp.isEmpty()) {
            mf.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
        } else {
            mf.setClassPath("");
            int i = 0;
            while (i < cp.size()) {
                mf.appendClassPath((String)cp.get(i));
                ++i;
            }
        }
    }

    protected boolean shouldMerge(File aFile) {
        String uri = aFile.getURI();
        if (!uri.endsWith(".java") && !uri.endsWith(".class")) {
            return false;
        }
        if (!this.includeSource && uri.endsWith(".java")) {
            return false;
        }
        return !this.outgoingArchive.containsFile(uri) && !"META-INF/MANIFEST.MF".equals(uri);
    }
}

