/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.team.core.history.ITag;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;

public class CVSHistorySearchFilter
extends ViewerFilter {
    public String searchString;
    private int matchCounter;
    public ArrayList searchStrings;

    public CVSHistorySearchFilter(String searchStrings) {
        this.searchString = searchStrings;
    }

    public boolean select(Viewer aviewer, Object parentElement, Object element) {
        if (element instanceof AbstractHistoryCategory) {
            return true;
        }
        if (element instanceof CVSFileRevision) {
            boolean orSearch;
            StringTokenizer tokenizer = new StringTokenizer(this.searchString);
            this.searchStrings = new ArrayList();
            while (tokenizer.hasMoreElements()) {
                this.searchStrings.add(tokenizer.nextToken());
            }
            CVSFileRevision entry = (CVSFileRevision)element;
            boolean bl = orSearch = this.authorMatch(entry) || this.dateMatch(entry) || this.commentMatch(entry) || this.revisionMatch(entry) || this.tagMatch(entry) || this.branchNameMatch(entry);
            if (orSearch) {
                ++this.matchCounter;
            }
            return orSearch;
        }
        return false;
    }

    protected boolean authorMatch(CVSFileRevision revision) {
        String author = revision.getAuthor();
        if (author != null) {
            for (String nextString : this.searchStrings) {
                if (author.indexOf(nextString) == -1) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean commentMatch(CVSFileRevision revision) {
        String comment = revision.getComment().toLowerCase();
        if (comment != null) {
            Iterator iter = this.searchStrings.iterator();
            while (iter.hasNext()) {
                if (comment.indexOf(((String)iter.next()).toLowerCase()) == -1) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean dateMatch(CVSFileRevision revision) {
        return false;
    }

    protected boolean branchNameMatch(CVSFileRevision revision) {
        ITag[] branches = revision.getBranches();
        int i = 0;
        while (i < branches.length) {
            String tag = branches[i].getName().toLowerCase();
            Iterator iter = this.searchStrings.iterator();
            while (iter.hasNext()) {
                if (tag.indexOf(((String)iter.next()).toLowerCase()) == -1) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean tagMatch(CVSFileRevision revision) {
        ITag[] tags = revision.getTags();
        int i = 0;
        while (i < tags.length) {
            String tag = tags[i].getName().toLowerCase();
            Iterator iter = this.searchStrings.iterator();
            while (iter.hasNext()) {
                if (tag.indexOf(((String)iter.next()).toLowerCase()) == -1) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean revisionMatch(CVSFileRevision revision) {
        String rev = revision.getContentIdentifier();
        if (rev != null) {
            Iterator iter = this.searchStrings.iterator();
            while (iter.hasNext()) {
                if (rev.indexOf(((String)iter.next()).toLowerCase()) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public int getMatchCount() {
        return this.matchCounter;
    }
}

