/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.operations.DiffOperation;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.ui.IWorkbenchPart;

public class FileDiffOperation
extends DiffOperation {
    FileOutputStream os;
    PrintStream printStream;
    File file;
    File tempFile;

    public FileDiffOperation(IWorkbenchPart part, ResourceMapping[] mappings, Command.LocalOption[] options, File file, boolean isMultiPatch, boolean includeFullPathInformation, IPath patchRoot) {
        super(part, mappings, options, isMultiPatch, includeFullPathInformation, patchRoot, file.getAbsolutePath());
        IPath teamLocation = TeamPlugin.getPlugin().getStateLocation();
        IPath tempFilePath = teamLocation.append((IPath)new Path("/tempDiff" + System.currentTimeMillis()));
        this.tempFile = tempFilePath.toFile();
        this.file = file;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        super.execute(monitor);
        if (this.tempFile.length() == 0L) {
            this.tempFile.delete();
            this.reportEmptyDiff();
            return;
        }
        if (this.isMultiPatch && !this.patchHasContents && !this.patchHasNewFiles) {
            this.tempFile.delete();
            this.reportEmptyDiff();
            return;
        }
        this.copyFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void copyFile() throws CVSException {
        try {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try {
                    FileInputStream tempFileStream = new FileInputStream(this.tempFile);
                    try {
                        try (FileOutputStream fileStream = new FileOutputStream(this.file);){
                            FileChannel tempFileChannel = tempFileStream.getChannel();
                            FileChannel fileChannel = fileStream.getChannel();
                            long size = tempFileChannel.size();
                            long bytesTransferred = fileChannel.transferFrom(tempFileChannel, 0L, size);
                            while (bytesTransferred != size) {
                                bytesTransferred += fileChannel.transferFrom(tempFileChannel, bytesTransferred, size);
                            }
                        }
                        if (tempFileStream == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (tempFileStream == null) throw throwable;
                        tempFileStream.close();
                        throw throwable;
                    }
                    tempFileStream.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw CVSException.wrapException((Exception)e);
            }
        }
        finally {
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
        }
    }

    @Override
    protected PrintStream openStream() throws CVSException {
        try {
            this.os = new FileOutputStream(this.tempFile);
            return new PrintStream(this.os);
        }
        catch (FileNotFoundException e) {
            CVSStatus status = new CVSStatus(4, 4, CVSUIMessages.GenerateDiffFileOperation_0, (Throwable)e);
            throw new CVSException((IStatus)status);
        }
    }
}

