/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.wizards.ConfigurationWizardMainPage;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class NewLocationWizard
extends Wizard
implements INewWizard {
    protected ConfigurationWizardMainPage mainPage;
    protected Properties properties = null;
    private boolean switchPerspectives = true;

    public static IDialogSettings getLocationDialogSettings() {
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewLocationWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewLocationWizard");
        }
        return section;
    }

    public NewLocationWizard() {
        IDialogSettings section = NewLocationWizard.getLocationDialogSettings();
        this.setDialogSettings(section);
        this.setWindowTitle(CVSUIMessages.NewLocationWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public NewLocationWizard(Properties initialProperties) {
        this();
        this.properties = initialProperties;
    }

    public void addPages() {
        this.mainPage = this.createMainPage();
        if (this.properties != null) {
            this.mainPage.setProperties(this.properties);
        }
        this.mainPage.setShowValidate(true);
        this.mainPage.setDescription(CVSUIMessages.NewLocationWizard_description);
        this.mainPage.setDialogSettings(this.getDialogSettings());
        this.addPage((IWizardPage)this.mainPage);
    }

    protected ConfigurationWizardMainPage createMainPage() {
        return new ConfigurationWizardMainPage("repositoryPage1", CVSUIMessages.NewLocationWizard_heading, CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.png"));
    }

    public boolean performFinish() {
        boolean keepLocation;
        ICVSRepositoryLocation[] location;
        block17: {
            location = new ICVSRepositoryLocation[1];
            keepLocation = false;
            try {
                location[0] = this.mainPage.getLocation();
                location[0] = KnownRepositories.getInstance().addRepository(location[0], false);
                if (this.mainPage.getValidate()) {
                    try {
                        this.getContainer().run(true, true, monitor -> {
                            try {
                                location[0].validateConnection(monitor);
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        });
                        keepLocation = true;
                        break block17;
                    }
                    catch (InterruptedException interruptedException) {
                        break block17;
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (t instanceof TeamException) {
                            throw (TeamException)t;
                        }
                        if (t instanceof Exception) {
                            throw CVSException.wrapException((Exception)((Exception)t));
                        }
                        throw CVSException.wrapException((Exception)e);
                    }
                }
                keepLocation = true;
            }
            catch (TeamException e) {
                if (location[0] == null) {
                    CVSUIPlugin.openError(this.getContainer().getShell(), CVSUIMessages.NewLocationWizard_exception, null, e);
                    return false;
                }
                IStatus error = e.getStatus();
                if (error.isMultiStatus() && error.getChildren().length == 1) {
                    error = error.getChildren()[0];
                }
                if (error.isMultiStatus()) {
                    CVSUIPlugin.openError(this.getContainer().getShell(), CVSUIMessages.NewLocationWizard_validationFailedTitle, null, e);
                }
                keepLocation = MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)CVSUIMessages.NewLocationWizard_validationFailedTitle, (String)NLS.bind((String)CVSUIMessages.NewLocationWizard_validationFailedText, (Object[])new Object[]{error.getMessage()}));
            }
        }
        if (keepLocation) {
            KnownRepositories.getInstance().addRepository(location[0], true);
            if (this.switchPerspectives) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                String defaultPerspectiveID = this.promptForPerspectiveSwitch();
                if (defaultPerspectiveID != null) {
                    try {
                        workbench.showPerspective(defaultPerspectiveID, window);
                    }
                    catch (WorkbenchException e) {
                        Utils.handleError((Shell)window.getShell(), (Exception)((Object)e), (String)CVSUIMessages.ShowAnnotationOperation_0, (String)e.getMessage());
                    }
                }
            }
        } else {
            KnownRepositories.getInstance().disposeRepository(location[0]);
        }
        return keepLocation;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setSwitchPerspectives(boolean switchPerspectives) {
        this.switchPerspectives = switchPerspectives;
    }

    private String promptForPerspectiveSwitch() {
        IPerspectiveDescriptor current;
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        String option = store.getString("pref_change_perspective_on_new_location");
        if (option.equals("always")) {
            return "org.eclipse.team.cvs.ui.cvsPerspective";
        }
        if (option.equals("never")) {
            return null;
        }
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor desired = registry.findPerspectiveWithId("org.eclipse.team.cvs.ui.cvsPerspective");
        IWorkbenchPage page = CVSUIPlugin.getActivePage();
        if (page != null && (current = page.getPerspective()) != null && current.getId().equals("org.eclipse.team.cvs.ui.cvsPerspective")) {
            return null;
        }
        if (desired != null) {
            String desc = desired.getDescription();
            String message = desc == null ? NLS.bind((String)CVSUIMessages.NewLocationWizard_2, (Object[])new String[]{desired.getLabel()}) : NLS.bind((String)CVSUIMessages.NewLocationWizard_3, (Object[])new String[]{desired.getLabel(), desc});
            MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)Utils.getShell(null), (String)CVSUIMessages.NewLocationWizard_1, (String)message, (String)CVSUIMessages.NewLocationWizard_4, (boolean)false, (IPreferenceStore)store, (String)"pref_change_perspective_on_new_location");
            int result = m.getReturnCode();
            switch (result) {
                case 0: 
                case 2: {
                    return "org.eclipse.team.cvs.ui.cvsPerspective";
                }
                case 3: {
                    return null;
                }
            }
        }
        return null;
    }
}

