/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.AbstractBranchPointActionProvider;
import org.eclipse.emf.cdo.internal.ui.actions.CreateBranchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IWorkbenchPage;

public class SwitchToActionProvider
extends AbstractBranchPointActionProvider {
    private static final String ID = SwitchToActionProvider.class.getName();

    public SwitchToActionProvider() {
        super(ID, "Switch To");
    }

    protected void fillSubMenu(IWorkbenchPage page, IMenuManager subMenu, CDOCheckout checkout) {
        if ("online-transactional".equals(checkout.getType())) {
            subMenu.add((IAction)new SwitchToNewBranchAction(page, checkout));
        }
        super.fillSubMenu(page, subMenu, checkout);
    }

    protected void fillHistorizedAction(IWorkbenchPage page, IMenuManager subMenu, CDOCheckout checkout, CDOBranchPoint branchPoint) {
        if (checkout.isReadOnly() || branchPoint.getTimeStamp() == 0L) {
            super.fillHistorizedAction(page, subMenu, checkout, branchPoint);
        }
    }

    protected void fillOtherBranchAction(IWorkbenchPage page, IMenuManager subMenu, CDOCheckout checkout) {
        if (!checkout.isReadOnly()) {
            super.fillOtherBranchAction(page, subMenu, checkout);
        }
    }

    protected void fillOtherBranchPointAction(IWorkbenchPage page, IMenuManager subMenu, CDOCheckout checkout) {
        if (checkout.isReadOnly()) {
            super.fillOtherBranchPointAction(page, subMenu, checkout);
        }
    }

    protected void fillCommitAction(IWorkbenchPage page, IMenuManager subMenu, CDOCheckout checkout) {
        if (checkout.isReadOnly()) {
            super.fillCommitAction(page, subMenu, checkout);
        }
    }

    protected void fillOtherCheckoutAction(IWorkbenchPage page, IMenuManager subMenu, CDOCheckout checkout, CDOCheckout otherCheckout) {
        if (checkout.isReadOnly() == otherCheckout.isReadOnly()) {
            super.fillOtherCheckoutAction(page, subMenu, checkout, otherCheckout);
        }
    }

    protected String getHistorizedBranchPointToolTip(boolean allowTimeStamp) {
        return allowTimeStamp ? "Switch to this branch point" : "Switch to this branch";
    }

    protected String getOtherBranchPointToolTip(boolean allowTimeStamp) {
        return allowTimeStamp ? "Select a branch point and switch to it" : "Select a branch and switch to it";
    }

    protected String getCommitBranchPointToolTip() {
        return "Select a commit and switch to it";
    }

    protected String getOtherCheckoutToolTip() {
        return "Switch to the branch point of this checkout";
    }

    protected void execute(CDOCheckout checkout, CDOBranchPoint branchPoint) throws Exception {
        SwitchToActionProvider.switchTo(checkout, branchPoint);
    }

    public static void switchTo(CDOCheckout checkout, CDOBranchPoint branchPoint) {
        checkout.setBranchPoint(branchPoint);
    }

    private static class SwitchToNewBranchAction
    extends CreateBranchAction {
        private static final String ID = "org.eclipse.emf.cdo.explorer.ui.SwitchToNewBranchAction";
        private final CDOCheckout checkout;

        public SwitchToNewBranchAction(IWorkbenchPage page, CDOCheckout checkout) {
            super(page, (CDOBranchPoint)checkout.getView());
            this.checkout = checkout;
            this.setId(ID);
            this.setText("New Branch...");
            this.setImageDescriptor(OM.getImageDescriptor("icons/branch.gif"));
            this.setToolTipText("Create a new branch and switch this checkout to it");
        }

        protected void doRun(IProgressMonitor progressMonitor) throws Exception {
            super.doRun(progressMonitor);
            CDOBranchPoint base = this.getBase();
            CDOBranch newBranch = base.getBranch().getBranch(this.getName());
            this.checkout.setBranchPoint(newBranch.getHead());
        }
    }
}

