/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.discovery;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.Messages;
import org.eclipse.epp.internal.mpc.ui.discovery.CollectMissingNaturesVisitor;
import org.eclipse.epp.internal.mpc.ui.discovery.DiscoverNatureSupportJob;
import org.eclipse.epp.internal.mpc.ui.discovery.ShowNatureProposalsJob;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IStartup;

public class MissingNatureDetector
implements IStartup,
IPropertyChangeListener {
    public static final String ENABLEMENT_PROPERTY = "org.eclipse.epp.mpc.naturelookup";
    private JobGroup allJobs;
    private final Set<String> detectedNatures = new HashSet<String>();
    private final Set<DiscoverNatureSupportJob> lookupJobs = new HashSet<DiscoverNatureSupportJob>();
    private final IResourceChangeListener projectOpenListener = event -> {
        if (event.getDelta() == null) {
            return;
        }
        try {
            CollectMissingNaturesVisitor visitor = new CollectMissingNaturesVisitor();
            event.getDelta().accept((IResourceDeltaVisitor)visitor);
            for (String natureId : visitor.getMissingNatures()) {
                this.triggerNatureLookup(natureId);
            }
            if (!visitor.getMissingNatures().isEmpty()) {
                this.showProposalsIfReady();
            }
        }
        catch (CoreException e) {
            MarketplaceClientUiPlugin.getInstance().getLog().log((IStatus)new Status(4, MarketplaceClientUiPlugin.getInstance().getBundle().getSymbolicName(), e.getLocalizedMessage(), (Throwable)e));
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerNatureLookup(String natureId) {
        Set<DiscoverNatureSupportJob> set = this.lookupJobs;
        synchronized (set) {
            if (this.detectedNatures.contains(natureId)) {
                return;
            }
            DiscoverNatureSupportJob mpcJob = new DiscoverNatureSupportJob(natureId);
            mpcJob.setSystem(false);
            mpcJob.setUser(false);
            mpcJob.setJobGroup(this.allJobs);
            mpcJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    MissingNatureDetector.this.showProposalsIfReady();
                }
            });
            this.lookupJobs.add(mpcJob);
            mpcJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showProposalsIfReady() {
        HashMap<String, Collection<INode>> candidates;
        Set<DiscoverNatureSupportJob> set = this.lookupJobs;
        synchronized (set) {
            if (!this.allJobs.getActiveJobs().isEmpty()) {
                return;
            }
            candidates = new HashMap<String, Collection<INode>>();
            for (DiscoverNatureSupportJob lookupJob : this.lookupJobs) {
                Collection<INode> entryCandidates = lookupJob.getCandidates();
                if (entryCandidates == null || entryCandidates.isEmpty()) continue;
                candidates.put(lookupJob.getNatureId(), entryCandidates);
            }
            this.lookupJobs.clear();
        }
        if (!candidates.isEmpty()) {
            new ShowNatureProposalsJob(candidates).schedule();
        }
    }

    public void earlyStartup() {
        this.allJobs = new JobGroup(Messages.MissingNatureDetector_Title, 3, 0);
        IPreferenceStore preferenceStore = MarketplaceClientUiPlugin.getInstance().getPreferenceStore();
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        boolean preferenceValue = preferenceStore.getBoolean(ENABLEMENT_PROPERTY);
        if (preferenceValue) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projectOpenListener);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (ENABLEMENT_PROPERTY.equals(event.getProperty())) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            boolean enabled = event.getNewValue() instanceof String ? Boolean.parseBoolean((String)event.getNewValue()) : Boolean.TRUE.equals(event.getNewValue());
            if (enabled) {
                workspace.addResourceChangeListener(this.projectOpenListener);
            } else {
                workspace.removeResourceChangeListener(this.projectOpenListener);
            }
        }
    }
}

