/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.editor.formatter;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.editor.formatter.AtlCodeFormatterPreferences;
import org.eclipse.m2m.atl.adt.ui.editor.formatter.InvalidFragmentException;
import org.eclipse.m2m.atl.adt.ui.editor.formatter.objects.CodeFragment;
import org.eclipse.m2m.atl.adt.ui.editor.formatter.objects.FormattedObject;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlCodeFormatterProfileManager;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlCodeFormatterPropertyPage;
import org.eclipse.m2m.atl.adt.ui.preferences.PreferencesAccess;
import org.eclipse.m2m.atl.adt.ui.preferences.ProfileManager;
import org.eclipse.m2m.atl.adt.ui.preferences.ProfileStore;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionDataSource;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionHelper;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlModelAnalyser;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlCodeFormatter {
    private AtlModelAnalyser modelAnalyser;
    private HashMap<String, String> stringExp;
    private AtlCodeFormatterPreferences preferences;
    private FormattedObject formattedRoot;

    public void format(AtlEditor editor) throws BadLocationException {
        ISelection selection = editor.getSelectionProvider().getSelection();
        editor.getSourceManager().updateDataSource(editor.getViewer().getDocument().get());
        this.modelAnalyser = new AtlModelAnalyser(new AtlCompletionHelper(editor.getDocumentProviderContent()), editor.getSourceManager().getModel(), 0, AtlCompletionDataSource.getATLFileContext(editor.getSourceManager()));
        this.applyProfileToEditor(editor);
        this.format(editor.getViewer().getDocument());
        editor.getSelectionProvider().setSelection(selection);
    }

    public void format(IDocument document, Map<String, String> options, AtlModelAnalyser modelAnalyser) throws BadLocationException {
        this.modelAnalyser = modelAnalyser;
        this.preferences = options != null ? new AtlCodeFormatterPreferences(options) : new AtlCodeFormatterPreferences();
        this.format(document);
    }

    public String format(InputStream is) throws IOException, BadLocationException {
        int size;
        InputStreamReader isr = new InputStreamReader(is);
        StringBuffer s = new StringBuffer();
        char[] buffer = new char[10000];
        while ((size = isr.read(buffer)) > 0) {
            s.append(buffer, 0, size);
        }
        Document document = new Document();
        document.set(s.toString());
        AtlSourceManager sourceManager = new AtlSourceManager();
        sourceManager.updateDataSource(document.get());
        this.modelAnalyser = new AtlModelAnalyser(new AtlCompletionHelper(document.get()), sourceManager.getModel(), 0, AtlCompletionDataSource.getATLFileContext(sourceManager));
        this.format((IDocument)document, AtlCodeFormatterPreferences.getDefaultOptions(), this.modelAnalyser);
        if (this.formattedRoot == null) {
            return s.toString();
        }
        return this.formattedRoot.getText();
    }

    private void format(IDocument document) throws BadLocationException {
        FormattedObject.resetCounter();
        this.stringExp = new HashMap();
        EObject root = this.modelAnalyser.getRoot();
        if (root == null) {
            return;
        }
        this.formattedRoot = new FormattedObject(root, document.get());
        this.initialize(this.formattedRoot);
        this.format(this.formattedRoot);
        this.finalize(this.formattedRoot);
        if (!this.formattedRoot.getText().equals(document.get())) {
            document.set(this.formattedRoot.getText());
        }
    }

    public void applyProfileToEditor(AtlEditor editor) {
        IEditorPart editorPart = editor.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart != null) {
            IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
            IFile file = input.getFile();
            IProject activeProject = file.getProject();
            PreferencesAccess access = PreferencesAccess.getOriginalPreferences();
            ProfileStore profileStore = new ProfileStore(AtlCodeFormatterPropertyPage.PROFILES_KEY);
            IScopeContext scope = access.getInstanceScope();
            IScopeContext projectScope = access.getProjectScope(activeProject);
            IEclipsePreferences node = projectScope.getNode(AtlUIPlugin.getPluginId());
            String profileId = node.get(AtlCodeFormatterPropertyPage.CURRENT_PROFILE_KEY, null);
            AtlCodeFormatterProfileManager manager = AtlCodeFormatterProfileManager.getCurrentProfileManager(scope, access, profileStore);
            ProfileManager.Profile projectProfile = manager.getProfile(profileId);
            if (projectProfile == null || !this.isProjectSpecificSettingsEnabled(access.getProjectScope(activeProject))) {
                this.preferences = editor.getSourceViewerConf().getPreferenceStore() != null ? new AtlCodeFormatterPreferences(editor.getSourceViewerConf().getPreferenceStore()) : new AtlCodeFormatterPreferences();
                return;
            }
            manager.setSelected(projectProfile);
            this.preferences = projectProfile.getSettings() != null ? new AtlCodeFormatterPreferences(projectProfile.getSettings()) : new AtlCodeFormatterPreferences();
        }
    }

    public boolean isProjectSpecificSettingsEnabled(IScopeContext context) {
        return context.getNode(AtlUIPlugin.getPluginId()).getBoolean(AtlCodeFormatterPropertyPage.PROJECT_SPECIFIC_SETTINGS_ENABLED, false);
    }

    private void format(FormattedObject parent) throws BadLocationException {
        this.correctIndentationLevel(parent);
        EObject eObject = parent.getEObject();
        for (EObject child : eObject.eContents()) {
            String childText = this.modelAnalyser.getText(child);
            FormattedObject formattedChild = new FormattedObject(child, childText, parent.getIndentationLevel() + 1);
            this.treatStrings(formattedChild);
            CodeFragment fragment = this.initializeCodeFragment(parent.getText(), childText);
            parent.addChildren(formattedChild);
            if (parent.getType() == 4) {
                formattedChild.setIndentationLevel(formattedChild.getIndentationLevel() - 1);
            }
            this.format(formattedChild);
            if (formattedChild.getType() != -1) {
                fragment.setReplacementCodeFragment(formattedChild.getReplacement());
            } else {
                parent.getChildren().addAll(formattedChild.getChildren());
                fragment.setReplacementCodeFragment(formattedChild.getText());
            }
            try {
                AtlCodeFormatter.replaceFragment(parent, fragment);
            }
            catch (InvalidFragmentException invalidFragmentException) {}
        }
        if (eObject.eContents().isEmpty() && ("OutPattern".equals(eObject.eClass().getName()) || "InPattern".equals(eObject.eClass().getName()))) {
            return;
        }
        this.formatParent(parent);
    }

    private void treatStrings(FormattedObject parent) {
        if (parent.getType() == 16 && parent.getText().startsWith("'") && parent.getText().endsWith("'")) {
            this.stringExp.put(String.valueOf(this.stringExp.keySet().size() + 1), parent.getText());
            parent.setText("'{" + this.stringExp.size() + "}'");
            return;
        }
    }

    private void formatParent(FormattedObject parent) throws BadLocationException {
        String result;
        this.treatComments(parent);
        String save = result = parent.getText();
        switch (parent.getType()) {
            case 0: {
                result = this.formatModule(parent);
                break;
            }
            case 1: {
                result = this.formatOclModel(parent);
                break;
            }
            case 2: {
                result = this.formatHelper(parent);
                break;
            }
            case 3: 
            case 19: 
            case 20: {
                result = this.formatRule(parent);
                break;
            }
            case 23: {
                result = this.formatCalledRule(parent);
                break;
            }
            case 4: {
                result = this.formatOperatorCallExp(parent);
                break;
            }
            case 5: {
                result = this.formatParameter(parent);
                break;
            }
            case 6: {
                result = this.formatBinding(parent);
                break;
            }
            case 7: {
                result = this.formatInPattern(parent);
                break;
            }
            case 24: {
                result = this.formatRuleVariableDeclaration(parent);
                break;
            }
            case 8: {
                result = this.formatOutPattern(parent);
                break;
            }
            case 9: {
                result = this.formatCollectionType(parent);
                break;
            }
            case 10: {
                result = this.formatOperation(parent);
                break;
            }
            case 11: {
                result = this.formatAttribute(parent);
                break;
            }
            case 12: {
                result = this.formatTupleExp(parent);
                break;
            }
            case 13: {
                result = this.formatCollectionExp(parent);
                break;
            }
            case 14: 
            case 25: {
                result = this.formatCollectionOperationCallExp(parent);
                break;
            }
            case 15: {
                result = this.formatNavigationOrAttributeCallExp(parent);
                break;
            }
            case 17: {
                result = this.formatLibrary(parent);
                break;
            }
            case 18: {
                result = this.formatQuery(parent);
                break;
            }
            case 21: 
            case 22: {
                result = this.formatIteratorExp(parent);
                break;
            }
            case 26: {
                result = this.formatIfExp(parent);
                break;
            }
            case 27: {
                result = this.formatForExp(parent);
                break;
            }
            case 28: {
                result = this.formatActionBlock(parent);
                break;
            }
            case 29: {
                result = this.formatOclModelElement(parent);
                break;
            }
            case 30: {
                result = this.formatSimpleInPattern(parent);
                break;
            }
            case 32: {
                result = this.formatLetExp(parent);
                break;
            }
            case 33: {
                result = this.formatSimpleOutPatternElement(parent);
                break;
            }
            case 34: {
                result = this.formatForEachOutPatternElement(parent);
                break;
            }
            case 35: {
                result = "OclUndefined";
                break;
            }
        }
        if (result.trim().equals("")) {
            parent.setText(save);
        } else {
            parent.setText(result);
        }
    }

    private void treatComments(FormattedObject fo) throws BadLocationException {
        String text = fo.getText();
        while (AtlCodeFormatter.hasComment(text) && !fo.getEObject().equals(this.modelAnalyser.getRoot())) {
            int beginOffset = text.indexOf("--");
            int endOffset = beginOffset + this.getNextNoneCommentOffset(text.substring(beginOffset));
            int allTrimmedEndOffset = beginOffset + this.getNextNoneCommentAllTrimmedOffset(text.substring(beginOffset, endOffset));
            String comment = text.substring(beginOffset, allTrimmedEndOffset);
            boolean end = true;
            int childNum = -1;
            String regex = "(?:\\(\\s*)?OBJECT\\{(\\d+)\\}(?:\\s*\\))?\\s*" + Pattern.quote(comment);
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(text.substring(0, endOffset));
            while (m.find()) {
                childNum = Integer.parseInt(m.group(1));
            }
            if (childNum == -1) {
                end = false;
                regex = String.valueOf(Pattern.quote(comment)) + "\\s*" + "(?:\\(\\s*)?OBJECT\\{(\\d+)\\}(?:\\s*\\))?";
                p = Pattern.compile(regex);
                m = p.matcher(text.substring(beginOffset));
                while (m.find()) {
                    childNum = Integer.parseInt(m.group(1));
                }
            }
            if (childNum == -1) {
                return;
            }
            comment = String.valueOf(comment) + "\n" + AtlCodeFormatterPreferences.getChars(fo.getIndentationLevel() + 1, '\t');
            text = String.valueOf(text.substring(0, beginOffset)) + " " + text.substring(endOffset);
            this.addCommentToChild(fo, childNum, comment, end);
            fo.setText(text);
        }
    }

    private void addCommentToChild(FormattedObject parent, int childNum, String comment, boolean end) {
        for (FormattedObject child : parent.getChildren()) {
            if (child.getNumber() != childNum) continue;
            if (end) {
                child.setText(String.valueOf(child.getText()) + " " + comment);
            } else {
                child.setText(String.valueOf(comment) + child.getText());
            }
            return;
        }
    }

    private int getNextNoneCommentAllTrimmedOffset(String text) {
        String regex = "\\S\\s*\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        int offset = text.length();
        while (m.find()) {
            offset = m.start() + 1;
        }
        return offset;
    }

    private int getNextNoneCommentOffset(String text) {
        String regex = "\\A((?:--[^\n]*\\s*)*)";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        int offset = text.indexOf("\n");
        while (m.find()) {
            offset = m.group(1).length();
        }
        return offset;
    }

    private void correctIndentationLevel(FormattedObject parent) {
        int indentationLevel = parent.getIndentationLevel();
        if (this.isRuleType(parent.getType())) {
            indentationLevel = 0;
        }
        if (parent.getType() == 2) {
            indentationLevel = -2;
        }
        parent.setIndentationLevel(indentationLevel);
    }

    private boolean isRuleType(int type) {
        return type == 3 || type == 19 || type == 20 || type == 23;
    }

    private String cutLines(String text) {
        if (this.preferences.getLineMaxLength() == -1) {
            return text;
        }
        String result = "";
        String[] stringArray = text.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isStringOpened;
            String line = stringArray[n2];
            boolean bl = isStringOpened = AtlCodeFormatter.getLineType(line) == 3;
            if (this.calculateSize(line) > this.preferences.getLineMaxLength() && AtlCodeFormatter.isToBeCut(line)) {
                String splitLine = new String(line);
                String oldSplitLine = "";
                while (this.calculateSize(splitLine) > this.preferences.getLineMaxLength() && !splitLine.equals(oldSplitLine) && this.canBeSplit(splitLine)) {
                    int offset;
                    oldSplitLine = splitLine;
                    int endOffset = offset = this.lastOffsetToMaxLength(splitLine);
                    if (splitLine.charAt(offset) == ' ') {
                        endOffset = offset + 1;
                    }
                    String endLine = "";
                    String beginNewLine = AtlCodeFormatter.getTabs(line);
                    int lineType = AtlCodeFormatter.getLineType(splitLine.substring(0, offset));
                    if (!isStringOpened && lineType == 3) {
                        endLine = "'";
                        beginNewLine = String.valueOf(beginNewLine) + "+ '";
                        --endOffset;
                    } else if (lineType == 1) {
                        beginNewLine = "---" + this.preferences.getSpacesAfterComment();
                    } else if (lineType == 2) {
                        beginNewLine = String.valueOf(beginNewLine) + "--" + this.preferences.getSpacesAfterComment();
                    }
                    result = String.valueOf(result) + splitLine.substring(0, offset) + endLine + "\n";
                    splitLine = String.valueOf(beginNewLine) + splitLine.substring(endOffset);
                }
                result = String.valueOf(result) + splitLine;
            } else {
                result = String.valueOf(result) + line;
            }
            result = String.valueOf(result) + "\n";
            ++n2;
        }
        return result;
    }

    private boolean canBeSplit(String line) {
        return !line.trim().equals("") && line.indexOf(32) != -1;
    }

    private String replaceStrings(String line) {
        int partialLineType = AtlCodeFormatter.getLineType(line.substring(0, line.indexOf("'{") == -1 ? line.length() : line.indexOf("'{")));
        String regex = "'\\{(\\d+)\\}'";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(line);
        while (m.find()) {
            if (partialLineType != 2 && partialLineType != 1) {
                String stringKey = m.group(1);
                String replacement = this.stringExp.get(stringKey).replace("\\", "\\\\").replace("$", "\\$");
                line = line.replaceFirst(Pattern.quote(m.group()), replacement);
            }
            partialLineType = AtlCodeFormatter.getLineType(line.substring(0, line.indexOf("'{") == -1 ? line.length() : line.indexOf("'{")));
        }
        return line;
    }

    private static int getLineType(String line) {
        boolean stringFlag = false;
        int commentFlag = 0;
        int prevChar = 0;
        int i = 0;
        while (i < line.length()) {
            char currChar = line.charAt(i);
            if (currChar == '\'' && prevChar != 92 && commentFlag < 2) {
                stringFlag = !stringFlag;
            } else if ((currChar == '-' && commentFlag < 2 || currChar == '-' && prevChar == 45) && !stringFlag) {
                ++commentFlag;
            }
            if (currChar != '-' && commentFlag < 2 || currChar == '\n') {
                commentFlag = 0;
            }
            prevChar = currChar;
            ++i;
        }
        if (stringFlag) {
            return 3;
        }
        if (commentFlag == 2) {
            return 2;
        }
        if (commentFlag > 2) {
            return 1;
        }
        return 0;
    }

    private static boolean hasComment(String text) {
        String[] stringArray = text.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (AtlCodeFormatter.getLineType(line) == 2 || AtlCodeFormatter.getLineType(line) == 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isToBeCut(String line) {
        if (line.matches("\\A[-]{2,}\\s*@[^$]*")) {
            return false;
        }
        return !line.matches(".*[-]{2,}\\s*\\[NOCUT\\].*");
    }

    private int calculateSize(String line) {
        int size = line.length();
        return size += AtlCodeFormatter.tabsCount(line) * (this.preferences.getTabSpaces() - 1);
    }

    private static int tabsCount(String line) {
        int tabsCount = 0;
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) == '\t') {
                ++tabsCount;
            }
            ++i;
        }
        return tabsCount;
    }

    private int lastOffsetToMaxLength(String line) {
        int offsetTemp;
        int correctedLineMaxLength = this.preferences.getLineMaxLength();
        int tabsCountLine = AtlCodeFormatter.tabsCount(line);
        if ((correctedLineMaxLength -= tabsCountLine * (this.preferences.getTabSpaces() - 1)) < 0) {
            correctedLineMaxLength = 0;
        }
        int offset = line.substring(0, correctedLineMaxLength).lastIndexOf(32);
        if (AtlCodeFormatter.getLineType(line) == 0) {
            int offsetPoint;
            int afterPoint = 1;
            if (!this.preferences.isCutAfterPoint()) {
                afterPoint = 0;
            }
            if ((offsetPoint = line.substring(0, correctedLineMaxLength).lastIndexOf(46) + afterPoint) > offset) {
                offset = offsetPoint;
            }
        }
        if (offset <= tabsCountLine + 2 && (offsetTemp = line.substring(correctedLineMaxLength).indexOf(32)) > 0) {
            offset = correctedLineMaxLength + offsetTemp;
        }
        if (offset <= tabsCountLine + 2) {
            offset = line.length() - 1;
        }
        return offset;
    }

    private static String getTabs(String line) {
        String result = "\t\t";
        int offset = 0;
        while (line.charAt(offset) == '\t') {
            result = String.valueOf(result) + "\t";
            ++offset;
        }
        return result;
    }

    private void initialize(FormattedObject parent) throws BadLocationException {
        this.removeExtraSpace(parent);
    }

    private void finalize(FormattedObject parent) {
        parent.setText(this.formatSpecialComments(parent));
        parent.setText(parent.getText());
        this.getBackCode(parent);
        String documentText = parent.getText();
        documentText = documentText.replaceAll("([-]{2,})[\\s&&[^$]]*(^[-@])", "$1" + this.preferences.getSpacesAfterComment() + "$2");
        documentText = documentText.replaceAll("(\\S+)\\s*\\z", "$1\n");
        documentText = documentText.replaceAll("\\A\\s*(\\S+)", "$1");
        String text = "";
        String[] stringArray = documentText.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            text = String.valueOf(text) + this.replaceStrings(line) + "\n";
            ++n2;
        }
        documentText = this.cutLines(text);
        parent.setText(documentText);
    }

    private void getBackCode(FormattedObject parent) {
        String text = parent.getText();
        for (FormattedObject fo : parent.getChildren()) {
            this.getBackCode(fo);
            text = text.replace(fo.getReplacement(), fo.getText());
        }
        parent.setText(text);
    }

    private void removeExtraSpace(FormattedObject parent) throws BadLocationException {
        String parentText = parent.getText();
        if (parent.getEObject().equals(this.modelAnalyser.getRoot())) {
            int i = parent.getEObject().eContents().size() - 1;
            while (i >= 0) {
                EObject previousElt;
                FormattedObject child = parent.getChild(i);
                if ((child.getType() == 2 || child.getType() == 18 || child.getType() == 17 || this.isRuleType(child.getType())) && (previousElt = this.modelAnalyser.getPreviousElement(child.getEObject())) != null && (FormattedObject.typeOf(previousElt) == 2 || this.isRuleType(FormattedObject.typeOf(previousElt)))) {
                    int[] offsets = this.getElementOffset(child.getEObject());
                    int[] offsetsPreviousElt = this.getElementOffset(previousElt);
                    String trimedString = parentText.substring(offsetsPreviousElt[1], offsets[0]);
                    trimedString = trimedString.replaceAll("\\s*\n+\\s*(\\S+)", String.valueOf(this.preferences.getLinesSpaces()) + "\n$1");
                    trimedString = trimedString.replaceAll("(\\S+)\n+\\s*(\\S+)", "$1\n$2");
                    trimedString = trimedString.replaceAll("(\\S*)\\s+\\z", "$1\n");
                    if ((trimedString = trimedString.replaceAll("\\A\\p{Blank}*([^\n]+)", " $1" + this.preferences.getLinesSpaces())).trim().equals("")) {
                        trimedString = "\n";
                        trimedString = String.valueOf(trimedString) + this.preferences.getLinesSpaces();
                    }
                    parentText = String.valueOf(parentText.substring(0, offsetsPreviousElt[1])) + trimedString + parentText.substring(offsets[0], parentText.length());
                }
                --i;
            }
        }
        parent.setText(parentText);
    }

    private CodeFragment initializeCodeFragment(String parentText, String childText) throws BadLocationException {
        int startOffset = parentText.indexOf(childText);
        String regex = "\\b" + Pattern.quote(childText) + "\\b";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(parentText);
        boolean goAhead = true;
        while (m.find() && goAhead) {
            if (AtlCodeFormatter.isAStringOffset(m.start(), parentText)) continue;
            startOffset = m.start();
            goAhead = false;
        }
        return new CodeFragment(childText, startOffset);
    }

    private static boolean isAStringOffset(int offset, String text) {
        String lineOfOffset = text.substring(0, offset);
        return AtlCodeFormatter.getLineType(lineOfOffset) == 3;
    }

    private static void replaceFragment(FormattedObject parent, CodeFragment fragment) throws InvalidFragmentException {
        if (fragment.getInitialStart() == -1) {
            throw new InvalidFragmentException();
        }
        String result = parent.getText().substring(0, fragment.getReplacementStart());
        result = String.valueOf(result) + fragment.getReplacementCodeFragment();
        result = String.valueOf(result) + parent.getText().substring(fragment.getInitialEnd(), parent.getText().length());
        parent.setText(result);
    }

    private int[] getElementOffset(EObject obj) throws BadLocationException {
        return this.modelAnalyser.getHelper().getElementOffsets(obj, 0);
    }

    private String formatModule(FormattedObject parent) {
        String text = this.formatModuleString(parent);
        parent.setText(text);
        text = this.formatCreate(parent);
        parent.setText(text);
        text = this.formatFrom(parent);
        return text;
    }

    private String formatSpecialComments(FormattedObject parent) {
        String text = parent.getText();
        text = text.replaceAll("(\n|\r\n)?\\s*--\\s*\\@(\\w+)\\s+(\\w+)\\s*=\\s*([^\n|^\r\n]*)\\s*", "$1-- @$2 $3=$4\n");
        text = text.replaceAll("(\n|\r\n)?\\s*--\\s*\\@([^\n|^\r\n]*)\\s*", "$1-- @$2\n");
        int max = text.length();
        String endSpecialCommentsRegex = "(\n|\r\n)?\\s*module|(\n|\r\n)?\\s*query|(\n|\r\n)?\\s*library";
        String[] split = text.split(endSpecialCommentsRegex);
        if (split != null && split.length > 0) {
            max = split[0].length();
        }
        String regex = "\\s*--\\s*\\@([^\n|^\r\n]*)\\s*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text.subSequence(0, max));
        String result = text;
        while (m.find()) {
            result = text.substring(0, m.end());
            result = String.valueOf(result) + this.preferences.getLinesAfterSpecialTags();
            result = String.valueOf(result) + text.substring(m.end());
        }
        return result;
    }

    private String formatModuleString(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\s*module\\s+(\\w+)\\s*;\\s*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        String result = text;
        if (m.find()) {
            result = text.substring(0, m.start()).trim();
            if (!result.trim().equals("")) {
                result = String.valueOf(result) + "\n\n";
            }
            result = String.valueOf(result) + "module " + m.group(1) + this.preferences.getEndingSemicolon();
            result = String.valueOf(result) + text.substring(m.end(), text.length());
        }
        return result;
    }

    private String formatCreate(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\s*create\\s+((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?(?:\\s*,\\s*(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)*)\\s+(from|refining)";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        String result = text;
        while (m.find()) {
            result = text.substring(0, m.start());
            result = String.valueOf(result) + this.preferences.getLinesAfterModule();
            String outModels = m.group(1);
            outModels = outModels.replaceAll("\\s*([.]*)\\s*,", "$1,");
            outModels = outModels.replaceAll(",\\s*([.]*)\\s*", String.valueOf(this.preferences.getComa()) + "$1");
            outModels = outModels.replaceAll("\\s*\\z", "");
            result = String.valueOf(result) + "\ncreate " + outModels + " " + m.group(2);
            result = String.valueOf(result) + text.substring(m.end(), text.length());
        }
        return result;
    }

    private String formatFrom(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\s*(from|refining)\\s+((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?\\s*(?:,\\s*(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?\\s*)*)\\s*;\\s*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        String result = text;
        while (m.find()) {
            result = text.substring(0, m.start());
            String inModels = m.group(2);
            inModels = inModels.replaceAll("\\s*([.]*)\\s*,", "$1,");
            inModels = inModels.replaceAll(",\\s*([.]*)\\s*", String.valueOf(this.preferences.getComa()) + "$1");
            inModels = inModels.replaceAll("\\s*\\z", "");
            result = String.valueOf(result) + " " + m.group(1) + " " + inModels + this.preferences.getEndingSemicolon() + "\n";
            result = String.valueOf(result) + this.preferences.getLinesAfterCreateFrom();
            result = String.valueOf(result) + text.substring(m.end(), text.length());
        }
        return result;
    }

    private String formatOclModel(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A(\\w+)\\s*\\:\\s*(\\w+)\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = String.valueOf(m.group(1)) + this.preferences.getColon() + m.group(2);
        }
        return text;
    }

    private String formatHelper(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\Ahelper(?:\\s+context\\s+(\\S+))?\\s+def\\s*\\:\\s*(\\p{ASCII}*\\S+)\\s*;\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            String body = m.group(2);
            if (AtlCodeFormatter.getLineType(body) == 2 || AtlCodeFormatter.getLineType(body) == 1) {
                body = String.valueOf(body) + "\n\t";
            }
            text = m.group(1) != null ? "helper context " + m.group(1) + " def" + this.preferences.getColon() + body + this.preferences.getEndingSemicolon() : "helper def" + this.preferences.getColon() + body + this.preferences.getEndingSemicolon();
        }
        return text;
    }

    private String formatRule(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A(lazy|abstract)?\\s*rule\\s+(\\w+)\\s*\\{\\s*(\\p{ASCII}*)\\s*\\}\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            String body = "";
            String regex2 = "\\A((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*(?:using\\s*\\{(\\s*(?:\\s*(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)*\\s*)\\})?\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)?\\s*\\z";
            Pattern p2 = Pattern.compile(regex2);
            Matcher m2 = p2.matcher(m.group(3));
            while (m2.find()) {
                body = String.valueOf(body) + m2.group(1) + "\n\t";
                if (m2.group(2) != null) {
                    body = String.valueOf(body) + "using" + this.preferences.getRuleBrace(parent.getIndentationLevel() + 1);
                    String usings = m2.group(2).replaceAll("\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*", "\n\t\t$1");
                    body = String.valueOf(body) + usings + "\n\t}\n\t";
                }
                if (m2.group(3) != null) {
                    body = String.valueOf(body) + m2.group(3);
                }
                if (m2.group(4) == null) continue;
                body = String.valueOf(body) + "\n\t" + m2.group(4);
            }
            text = m.group(1) == null ? "rule " + m.group(2) + this.preferences.getRuleBrace(parent.getIndentationLevel()) + "\n\t" + body + "\n}" : String.valueOf(m.group(1)) + " rule " + m.group(2) + this.preferences.getRuleBrace(parent.getIndentationLevel()) + "\n\t" + body + "\n}";
        }
        return text;
    }

    private String formatCalledRule(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\Aentrypoint\\s+rule\\s+(\\w+)\\s*(\\([\\p{ASCII}]*\\))\\s*\\{\\s*([\\p{ASCII}[\\S]]*)\\s*\\}\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            String body = "";
            String regex2 = "(?:using\\s*\\{(\\s*(?:\\s*(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)*\\s*)\\})?\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)?\\s*\\z";
            Pattern p2 = Pattern.compile(regex2);
            Matcher m2 = p2.matcher(m.group(3));
            while (m2.find()) {
                if (m2.group(1) != null) {
                    body = String.valueOf(body) + "using" + this.preferences.getRuleBrace(parent.getIndentationLevel() + 1);
                    String usings = m2.group(1).replaceAll("\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*", "\n\t\t$1");
                    body = String.valueOf(body) + usings + "\n\t}\n\t";
                }
                if (m2.group(2) != null) {
                    body = String.valueOf(body) + m2.group(2);
                }
                if (m2.group(3) == null) continue;
                body = String.valueOf(body) + "\n\t" + m2.group(3);
            }
            text = "entrypoint rule " + m.group(1) + this.formatOperationParameters(m.group(2)) + this.preferences.getRuleBrace(parent.getIndentationLevel()) + "\n\t" + body + "\n}";
        }
        return text;
    }

    private String formatOperatorCallExp(FormattedObject parent) {
        String text = parent.getText();
        String operators = "\\=|\\+|\\*|/|<=|>=|<>|<|-|>";
        String andOr = "and|or";
        String not = "not";
        text = text.replaceAll("\\A((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*(" + operators + ")\\s*(" + "(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?" + ")\\z", "$1" + this.preferences.getBeforeOperator(parent.getIndentationLevel() + 1) + "$2" + this.preferences.getAfterOperator(parent.getIndentationLevel()) + "$3");
        text = text.replaceAll("\\A((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s+(" + andOr + ")\\s+(" + "(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?" + ")\\z", "$1 $2 $3");
        text = text.replaceAll("\\A(" + not + ")\\s+(" + "(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?" + ")\\z", "$1 $2");
        return text;
    }

    private String formatParameter(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A([\\w]+)\\s*\\:\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = String.valueOf(m.group(1)) + this.preferences.getColon() + m.group(2);
        }
        return text;
    }

    private String formatBinding(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A([\\w]+)\\s*<-\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = String.valueOf(m.group(1)) + this.preferences.getBindingArrow() + m.group(2);
        }
        return text;
    }

    private String formatInPattern(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\Afrom\\s+((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*(?:\\(\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*\\))?\\s*\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = "from\n\t\t" + m.group(1);
            if (m.group(2) == null) continue;
            text = String.valueOf(text) + " (\n\t\t\t" + m.group(2) + "\n\t\t)";
        }
        return text;
    }

    private String formatRuleVariableDeclaration(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A([\\w]+)\\s*\\:\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*=\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*;\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = String.valueOf(m.group(1)) + this.preferences.getColon() + m.group(2) + this.preferences.getEqual() + m.group(3) + this.preferences.getEndingSemicolon();
        }
        return text;
    }

    private String formatOutPattern(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        String result = "to\n\t\t";
        int i = 0;
        while (m.find()) {
            if (i++ > 0) {
                result = String.valueOf(result) + this.preferences.getEndingComa(2);
            }
            result = String.valueOf(result) + m.group(1);
        }
        return result;
    }

    private String formatCollectionType(FormattedObject parent) {
        String text = parent.getText();
        String collections = "Sequence|TupleType|Set|Bag|OrderedSet|Map|Collection";
        String regex = "\\A(" + collections + ")\\s*\\(\\s*([\\p{ASCII}]*\\S+)\\s*\\)\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = String.valueOf(m.group(1)) + this.formatOperationParameters("(" + m.group(2) + ")");
        }
        return text;
    }

    private String formatOperation(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A(\\w+)\\s*(\\([\\p{ASCII}]*\\))\\s*\\:\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*\\=\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = String.valueOf(m.group(1)) + this.formatOperationParameters(m.group(2)) + this.preferences.getColon() + m.group(3) + this.preferences.getEndingEqual() + "\n\t" + m.group(4);
        }
        return text;
    }

    private String formatAttribute(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A(\\w+)\\s*\\:\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*\\=\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = String.valueOf(m.group(1)) + this.preferences.getColon() + m.group(2) + this.preferences.getEndingEqual() + "\n\t" + m.group(3);
        }
        return text;
    }

    private String formatTupleExp(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\s*(\\w+)(?:\\s*\\:\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?))?\\s*(?:\\=\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?))";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        int i = 0;
        String result = "Tuple" + this.preferences.getOpeningCollectionBrace();
        while (m.find()) {
            if (i++ > 0) {
                result = String.valueOf(result) + this.preferences.getComa();
            }
            result = String.valueOf(result) + m.group(1);
            if (m.group(2) != null) {
                result = String.valueOf(result) + this.preferences.getColon() + m.group(2);
            }
            if (m.group(3) == null) continue;
            result = String.valueOf(result) + this.preferences.getEqual() + m.group(3);
        }
        result = String.valueOf(result) + this.preferences.getClosingCollectionBrace();
        return result;
    }

    private String formatCollectionExp(FormattedObject parent) {
        String text = parent.getText();
        String collections = "Sequence|Set|Bag|OrderedSet|Map|Collection";
        String regex = "\\A(" + collections + ")\\s*\\{\\s*([\\p{ASCII}]*\\S+)\\s*\\}\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            String structs = m.group(2);
            structs = structs.replaceAll("\\s*([.]*)\\s*,", "$1,");
            structs = structs.replaceAll(",\\s*([.]*)\\s*", String.valueOf(this.preferences.getEndingComa(parent.getIndentationLevel() + 2)) + "$1");
            structs = structs.replaceAll("\\s*\\z", "");
            text = String.valueOf(m.group(1)) + this.preferences.getOpeningCollectionBrace() + structs + this.preferences.getClosingCollectionBrace();
        }
        return text;
    }

    private String formatCollectionOperationCallExp(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*(->|\\.)\\s*(\\w+)\\s*([\\p{ASCII}]+)\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            String callingObject = this.preferences.getPoint();
            if (m.group(2).equals("->")) {
                callingObject = this.preferences.getCallingArrow();
            }
            text = String.valueOf(m.group(1)) + callingObject + m.group(3) + this.formatOperationParameters(m.group(4));
        }
        return text;
    }

    private String formatNavigationOrAttributeCallExp(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*\\.\\s*(\\S+[\\p{ASCII}]*)\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = String.valueOf(m.group(1)) + this.preferences.getPoint() + m.group(2);
        }
        return text;
    }

    private String formatLibrary(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\s*library\\s+(\\w+)\\s*;\\s*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = m.replaceAll("\n\nlibrary " + m.group(1) + this.preferences.getEndingSemicolon() + "\n");
        }
        return text;
    }

    private String formatQuery(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\s*query\\s+(\\w+)\\s*\\=\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*;\\s*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = m.replaceAll("\n\nquery " + m.group(1) + this.preferences.getEqual() + m.group(2) + this.preferences.getEndingSemicolon() + "\n");
        }
        return text;
    }

    private String formatIteratorExp(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*->\\s*(\\w+)\\s*\\(\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*(?:;\\s*(\\w+)\\s*\\:\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*=\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?))?\\s*\\|\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*\\)\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = m.group(4) != null ? String.valueOf(m.group(1)) + this.preferences.getCallingArrow() + m.group(2) + this.preferences.getOpeningBracket() + m.group(3) + this.preferences.getSemicolon() + m.group(4) + this.preferences.getColon() + m.group(5) + this.preferences.getEqual() + m.group(6) + this.preferences.getPipe() + m.group(7) + this.preferences.getClosingBracket() : String.valueOf(m.group(1)) + this.preferences.getCallingArrow() + m.group(2) + this.preferences.getOpeningBracket() + m.group(3) + this.preferences.getPipe() + m.group(7) + this.preferences.getClosingBracket();
        }
        return text;
    }

    private String formatIfExp(FormattedObject parent) {
        String text = parent.getText();
        int indentationLevel = parent.getIndentationLevel();
        String regex = "\\Aif\\s*(\\(\\s*)?((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)(\\s*\\))?\\s*then\\s*(\\(\\s*)?((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)(\\s*\\))?\\s*else\\s*(\\(\\s*)?((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)(\\s*\\))?\\s*endif\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = "if " + this.getBracket(m.group(1)) + m.group(2) + this.getBracket(m.group(3)) + " then\n\t" + AtlCodeFormatterPreferences.getChars(indentationLevel, '\t') + this.getBracket(m.group(4)) + m.group(5) + this.getBracket(m.group(6)) + "\n" + AtlCodeFormatterPreferences.getChars(indentationLevel, '\t') + "else\n\t" + AtlCodeFormatterPreferences.getChars(indentationLevel, '\t') + this.getBracket(m.group(7)) + m.group(8) + this.getBracket(m.group(9)) + "\n" + AtlCodeFormatterPreferences.getChars(indentationLevel, '\t') + "endif";
        }
        return text;
    }

    private String formatForExp(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\Afor\\s*\\(\\s*(OBJECT\\{\\d+\\})\\s*in\\s*(OBJECT\\{\\d+\\})\\)\\s*\\{\\s*(OBJECT\\{\\d+\\})?\\s*\\}\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            String body = m.group(3);
            if (body == null) {
                body = "";
            }
            text = "for" + this.preferences.getOpeningBracket() + m.group(1) + " in " + m.group(2) + this.preferences.getClosingBracket() + this.preferences.getRuleBrace(parent.getIndentationLevel()) + "\n" + AtlCodeFormatterPreferences.getChars(parent.getIndentationLevel() + 1, '\t') + body + "\n" + AtlCodeFormatterPreferences.getChars(parent.getIndentationLevel(), '\t') + "}";
        }
        return text;
    }

    private String formatActionBlock(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\Ado\\s*\\{\\s*(\\s*[(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?\\s*(?:;)?]*)\\s*\\}\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = "do" + this.preferences.getRuleBrace(parent.getIndentationLevel());
            String regex2 = "\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*(;)?\\s*";
            Pattern p2 = Pattern.compile(regex2);
            Matcher m2 = p2.matcher(m.group(1));
            while (m2.find()) {
                text = String.valueOf(text) + "\n" + AtlCodeFormatterPreferences.getChars(parent.getIndentationLevel() + 1, '\t') + m2.group(1);
                if (m2.group(2) == null) continue;
                text = String.valueOf(text) + this.preferences.getSemicolon();
            }
            text = String.valueOf(text) + "\n\t}";
        }
        return text;
    }

    private String formatOclModelElement(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A(\\w+)\\s*!\\s*(\\w+)\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = String.valueOf(m.group(1)) + this.preferences.getExclamation() + m.group(2);
        }
        return text;
    }

    private String formatSimpleInPattern(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A(\\w+)\\s*\\:\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*(?:in\\s+(\\w+))?\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = String.valueOf(m.group(1)) + this.preferences.getColon() + m.group(2);
            if (m.group(3) == null) continue;
            text = String.valueOf(text) + " in " + m.group(3);
        }
        return text;
    }

    private String formatLetExp(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\Alet\\s*(\\w+)\\s*\\:\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*=\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*in\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = "let " + m.group(1) + this.preferences.getColon() + m.group(2) + this.preferences.getEndingEqual() + "\n" + AtlCodeFormatterPreferences.getChars(parent.getIndentationLevel() + 1, '\t') + m.group(3) + "\n" + AtlCodeFormatterPreferences.getChars(parent.getIndentationLevel(), '\t') + "in\n" + AtlCodeFormatterPreferences.getChars(parent.getIndentationLevel() + 1, '\t') + m.group(4);
        }
        return text;
    }

    private String formatSimpleOutPatternElement(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A(\\w+)\\s*\\:\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*(?:in\\s+(\\w+))?\\s*(?:mapsTo\\s+(\\w+))?\\s*(\\(\\s*(?:(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?(?:\\s*,\\s*(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)*)\\s*\\)|\\(\\s*\\)|\\((\\s*--[\\p{ASCII}]*\\s*)\\))?\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        String result = "";
        while (m.find()) {
            result = String.valueOf(result) + m.group(1) + this.preferences.getColon() + m.group(2);
            if (m.group(3) != null) {
                result = String.valueOf(result) + " in " + m.group(3);
            }
            if (m.group(4) != null) {
                result = String.valueOf(result) + " mapsTo " + m.group(4);
            }
            if (m.group(5) == null) continue;
            result = String.valueOf(result) + this.formatBindingsOutPatterns(m.group(5), 3);
        }
        return result;
    }

    private String formatForEachOutPatternElement(FormattedObject parent) {
        String text = parent.getText();
        String regex = "\\A(\\w+)\\s*\\:\\s*distinct\\s+((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s+foreach\\s*\\(\\s*((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s+in\\s+((?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)\\s*\\)\\s*\\(\\s*((?:(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)(\\s*,\\s*(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?)*)?\\s*\\)\\z";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        String result = text;
        while (m.find()) {
            result = String.valueOf(m.group(1)) + this.preferences.getColon() + "distinct " + m.group(2) + " foreach" + this.preferences.getOpeningBracket() + m.group(3) + " in " + m.group(4) + this.preferences.getClosingBracket() + " (\n";
            if (m.group(5) != null) {
                result = String.valueOf(result) + AtlCodeFormatterPreferences.getChars(parent.getIndentationLevel() + 1, '\t') + this.formatBindingsOutPatterns(m.group(5), parent.getIndentationLevel() + 1);
            }
            result = String.valueOf(result) + "\n" + AtlCodeFormatterPreferences.getChars(parent.getIndentationLevel(), '\t') + ")";
        }
        return result;
    }

    private String formatOperationParameters(String text) {
        String parameters = text.replaceAll("\\s*([.]*)\\s*,", "$1,");
        parameters = parameters.replaceAll("\\A\\(\\s*", this.preferences.getOpeningBracket());
        parameters = parameters.replaceAll("\\s*\\)\\z", this.preferences.getClosingBracket());
        parameters = parameters.replaceAll(",\\s*([.]*)\\s*", String.valueOf(this.preferences.getComa()) + "$1");
        return parameters;
    }

    private String formatBindingsOutPatterns(String text, int tab) {
        String parameters = text.replaceAll("\\s*([.]*)\\s*,", "$1,");
        parameters = parameters.replaceAll("\\A\\(\\s*", " (\n" + AtlCodeFormatterPreferences.getChars(tab, '\t'));
        parameters = parameters.replaceAll("\\s*\\)\\z", "\n" + AtlCodeFormatterPreferences.getChars(tab - 1, '\t') + ")");
        parameters = parameters.replaceAll(",\\s*([.]*)\\s*", String.valueOf(this.preferences.getEndingComa(tab)) + "$1");
        return parameters;
    }

    private String getBracket(String bracket) {
        if (bracket == null) {
            return "";
        }
        if (bracket.trim().equals("(")) {
            return this.preferences.getOpeningBracket();
        }
        if (bracket.trim().equals(")")) {
            return this.preferences.getClosingBracket();
        }
        return "";
    }

    public static Object eGet(EObject self, String featureName) {
        if (self == null) {
            return null;
        }
        EStructuralFeature feature = self.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            return self.eGet(feature);
        }
        return null;
    }
}

