/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.agent;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class DumpAgent {
    public static final String SEPARATOR = "+";
    public static final String SYSTEM = "system";
    public static final String HEAP = "heap";
    public static final String JAVA = "java";
    public static final String HPROF = "hprof";
    public static final String INFO_SEPARATOR = File.pathSeparator;

    public static void agentmain(String arg) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, MalformedObjectNameException, InstanceNotFoundException, ReflectionException, MBeanException {
        Class<?> dumpcls;
        String[] args0 = arg.split(INFO_SEPARATOR, 3);
        String[] args = args0[0].split(Pattern.quote(SEPARATOR));
        boolean live = Boolean.parseBoolean(args0[1]);
        String filename = args0[2];
        try {
            dumpcls = Class.forName("com.ibm.jvm.Dump");
            if (live) {
                System.gc();
            }
        }
        catch (ClassNotFoundException e) {
            try {
                dumpcls = Class.forName("sun.management.HotSpotDiagnostic");
            }
            catch (ClassNotFoundException e2) {
                dumpcls = null;
                args = new String[]{HPROF};
            }
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Method m;
            Method m2;
            String a = stringArray[n2];
            if (JAVA.equals(a)) {
                try {
                    m2 = dumpcls.getMethod("javaDumpToFile", String.class);
                    m2.invoke(null, filename);
                }
                catch (NoSuchMethodException e) {
                    m = dumpcls.getMethod("JavaDump", new Class[0]);
                    m.invoke(null, new Object[0]);
                }
            } else if (HEAP.equals(a)) {
                try {
                    m2 = dumpcls.getMethod("heapDumpToFile", String.class);
                    m2.invoke(null, filename);
                }
                catch (NoSuchMethodException e) {
                    m = dumpcls.getMethod("HeapDump", new Class[0]);
                    m.invoke(null, new Object[0]);
                }
            } else if (SYSTEM.equals(a)) {
                try {
                    m2 = dumpcls.getMethod("systemDumpToFile", String.class);
                    m2.invoke(null, filename);
                }
                catch (NoSuchMethodException e) {
                    m = dumpcls.getMethod("SystemDump", new Class[0]);
                    m.invoke(null, new Object[0]);
                }
            } else if (HPROF.equals(a)) {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
                ObjectName objn = new ObjectName(HOTSPOT_BEAN_NAME);
                server.invoke(objn, "dumpHeap", new Object[]{filename, live}, new String[]{"java.lang.String", "boolean"});
            } else if (HPROF.equals(a)) {
                Object hsd = dumpcls.newInstance();
                m = dumpcls.getMethod("dumpHeap", String.class, Boolean.TYPE);
                m.invoke(hsd, filename, live);
            }
            ++n2;
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, MalformedObjectNameException, InstanceNotFoundException, ReflectionException, MBeanException {
        System.out.println("Test generating dumps");
        DumpAgent.agentmain(args.length > 0 ? args[0] : "");
    }
}

