/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.launching;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardSourcePathProvider;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.VMHelper;

public class PDESourcePathProvider
extends StandardSourcePathProvider {
    public static final String ID = "org.eclipse.pde.ui.workbenchClasspathProvider";

    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        IProject[] projects;
        ArrayList<IRuntimeClasspathEntry> sourcePath = new ArrayList<IRuntimeClasspathEntry>();
        sourcePath.add(VMHelper.getJREEntry(configuration));
        IProject[] iProjectArray = projects = this.getJavaProjects(configuration);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            sourcePath.add(JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)JavaCore.create((IProject)project)));
            ++n2;
        }
        return sourcePath.toArray(new IRuntimeClasspathEntry[sourcePath.size()]);
    }

    private IProject[] getJavaProjects(ILaunchConfiguration configuration) throws CoreException {
        IProject[] projects = LaunchPluginValidator.getAffectedProjects(configuration, false);
        return PDELaunchingPlugin.getWorkspace().computeProjectOrder((IProject[])projects).projects;
    }

    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> all = new ArrayList<IRuntimeClasspathEntry>(entries.length);
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entrie = iRuntimeClasspathEntryArray[n2];
            if (entrie.getType() == 1) {
                all.add(entrie);
                IResource resource = entrie.getResource();
                if (resource instanceof IProject) {
                    this.addBinaryPackageFragmentRoots(JavaCore.create((IProject)((IProject)resource)), all);
                }
            } else {
                IRuntimeClasspathEntry[] resolved;
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = resolved = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entrie, (ILaunchConfiguration)configuration);
                int n3 = resolved.length;
                int n4 = 0;
                while (n4 < n3) {
                    IRuntimeClasspathEntry element = iRuntimeClasspathEntryArray2[n4];
                    all.add(element);
                    ++n4;
                }
            }
            ++n2;
        }
        return all.toArray(new IRuntimeClasspathEntry[all.size()]);
    }

    private void addBinaryPackageFragmentRoots(IJavaProject jProject, List<IRuntimeClasspathEntry> all) throws CoreException {
        IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
        int j = 0;
        while (j < roots.length) {
            if (roots[j].getKind() == 2 && !PDEJavaHelper.isJRELibrary((IPackageFragmentRoot)roots[j])) {
                IRuntimeClasspathEntry rte = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)roots[j].getPath());
                IPath path = roots[j].getSourceAttachmentPath();
                if (path != null) {
                    rte.setSourceAttachmentPath(path);
                    rte.setSourceAttachmentRootPath(roots[j].getSourceAttachmentRootPath());
                }
                if (!all.contains(rte)) {
                    all.add(rte);
                }
            }
            ++j;
        }
    }
}

