/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.form;

import java.util.List;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Transposer;
import org.eclipse.wb.internal.core.gef.policy.snapping.IFeedbackProxy;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPoint;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormLayoutVisualDataProvider;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PercentageSnapPoint<C extends IControlInfo>
extends SnapPoint {
    private final int m_percent;
    private Dimension m_containerSize;
    private final boolean m_hasGap;
    private final FormLayoutVisualDataProvider<C> m_visualDataProvider;
    private int m_gap;

    public PercentageSnapPoint(FormLayoutVisualDataProvider<C> visualDataProvider, int side, int percent, boolean hasGap) {
        super(visualDataProvider, side, side == 1 || side == 8 ? 0 : 1);
        this.m_visualDataProvider = visualDataProvider;
        this.m_percent = percent;
        this.m_hasGap = hasGap;
    }

    public PercentageSnapPoint(FormLayoutVisualDataProvider<C> visualDataProvider, int side, int percent) {
        this(visualDataProvider, side, percent, false);
    }

    protected void calculateSnapPoint(List<? extends IAbstractComponentInfo> beingSnappedList) {
        super.calculateSnapPoint(beingSnappedList);
        this.m_containerSize = this.m_visualDataProvider.getContainerSize();
        Transposer t = new Transposer(!this.isHorizontal());
        this.m_gap = 0;
        if (this.m_hasGap) {
            this.m_gap = this.m_visualDataProvider.getPercentsGap(this.isHorizontal());
        }
        this.m_snapPoint = t.t((Dimension)this.m_containerSize).width * this.m_percent / 100 - this.getSign() * this.m_gap;
    }

    private int getSign() {
        return PlacementUtils.isLeadingSide((int)this.m_side) ? -1 : 1;
    }

    public void addFeedback(Rectangle snappedBounds, IFeedbackProxy feedbackProxy, List<Figure> feedbacks) {
        if (this.isHorizontal()) {
            if (this.m_hasGap) {
                feedbacks.add(feedbackProxy.addVerticalFeedbackLine(this.m_snapPoint + this.getSign() * this.m_gap, 0, this.m_containerSize.height));
            }
            feedbacks.add(feedbackProxy.addVerticalFeedbackLine(this.m_snapPoint, 0, this.m_containerSize.height));
        } else {
            if (this.m_hasGap) {
                feedbacks.add(feedbackProxy.addHorizontalFeedbackLine(this.m_snapPoint + this.getSign() * this.m_gap, 0, this.m_containerSize.width));
            }
            feedbacks.add(feedbackProxy.addHorizontalFeedbackLine(this.m_snapPoint, 0, this.m_containerSize.width));
        }
    }

    public int getPercent() {
        return this.m_percent;
    }

    public int getGap() {
        return this.m_gap;
    }
}

