/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateProposalProvider;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class CompletionProposalComputer
implements IUnitOfWork<ICompletionProposal[], XtextResource>,
ICompletionProposalAcceptor,
ITemplateAcceptor {
    private final int offset;
    private final ITextViewer viewer;
    private final State state;
    private final Collection<ICompletionProposal> proposals = new LinkedHashSet<ICompletionProposal>(30);

    public CompletionProposalComputer(State state, ITextViewer viewer, int offset) {
        this.state = state;
        this.viewer = viewer;
        this.offset = offset;
    }

    public ICompletionProposal[] exec(XtextResource resource) throws Exception {
        ContentAssistContext[] contexts;
        ICompletionProposalAcceptor proposalAcceptor = this.state.decorateAcceptor(this);
        ContentAssistContext[] contentAssistContextArray = contexts = this.createContentAssistContexts(resource);
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            ContentAssistContext context = contentAssistContextArray[n2];
            if (proposalAcceptor.canAcceptMoreProposals()) {
                this.state.getContentProposalProvider().createProposals(context, proposalAcceptor);
            }
            ++n2;
        }
        ITemplateAcceptor templateAcceptor = this.state.decorateAcceptor(this);
        ContentAssistContext[] contentAssistContextArray2 = contexts;
        int n3 = contexts.length;
        n = 0;
        while (n < n3) {
            ContentAssistContext context = contentAssistContextArray2[n];
            if (templateAcceptor.canAcceptMoreTemplates() && context.getReplaceRegion().getOffset() >= 0) {
                this.state.getTemplateProposalProvider().createTemplates(context, templateAcceptor);
            }
            ++n;
        }
        return this.proposals.toArray(new ICompletionProposal[this.proposals.size()]);
    }

    protected ContentAssistContext[] createContentAssistContexts(XtextResource resource) {
        return this.state.getContextFactory().create(this.viewer, this.offset, resource);
    }

    @Override
    public void accept(ICompletionProposal proposal) {
        if (proposal == null) {
            throw new NullPointerException("proposal may not be null");
        }
        this.proposals.add(proposal);
    }

    @Override
    public boolean canAcceptMoreProposals() {
        return true;
    }

    @Override
    public void accept(TemplateProposal template) {
        if (template == null) {
            throw new NullPointerException("template may not be null");
        }
        this.proposals.add((ICompletionProposal)template);
    }

    @Override
    public boolean canAcceptMoreTemplates() {
        return true;
    }

    public static interface State {
        public ITemplateProposalProvider getTemplateProposalProvider();

        public IContentProposalProvider getContentProposalProvider();

        public ContentAssistContext.Factory getContextFactory();

        public ICompletionProposalAcceptor decorateAcceptor(ICompletionProposalAcceptor var1);

        public ITemplateAcceptor decorateAcceptor(ITemplateAcceptor var1);
    }
}

