/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;

public final class CompositeModelQuery<T, U>
implements BuildAction<Collection<T>> {
    private static final long serialVersionUID = 1L;
    private final Class<T> modelType;
    private final Action<? super U> parameter;
    private Class<U> parameterType;

    public CompositeModelQuery(Class<T> modelType) {
        this(modelType, null, null);
    }

    public CompositeModelQuery(Class<T> modelType, Class<U> parameterType, Action<? super U> parameter) {
        this.modelType = modelType;
        this.parameterType = parameterType;
        this.parameter = parameter;
    }

    public Collection<T> execute(BuildController controller) {
        ArrayList models = new ArrayList();
        this.collectRootModels(controller, controller.getBuildModel(), models);
        return models;
    }

    private void collectRootModels(BuildController controller, GradleBuild build, Collection<T> models) {
        if (this.parameter != null) {
            models.add(controller.getModel((Model)build.getRootProject(), this.modelType, this.parameterType, this.parameter));
        } else {
            models.add(controller.getModel((Model)build.getRootProject(), this.modelType));
        }
        for (GradleBuild includedBuild : build.getIncludedBuilds()) {
            this.collectRootModels(controller, includedBuild, models);
        }
    }

    public int hashCode() {
        return Objects.hash(this.modelType, this.parameter);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeModelQuery other = (CompositeModelQuery)obj;
        return Objects.equals(this.modelType, other.modelType) && Objects.equals(this.parameter, other.parameter);
    }
}

