/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.AbstractExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;

public final class CharacterStringExpressionConverter
extends AbstractExpressionConverter<String> {
    private static final ExpressionConverter<String> INSTANCE = new CharacterStringExpressionConverter();

    public static ExpressionConverter<String> instance() {
        return INSTANCE;
    }

    private CharacterStringExpressionConverter() {
    }

    protected CharacterLiteral convertObject(String string, AST ast) {
        CharacterLiteral characterLiteral = ast.newCharacterLiteral();
        characterLiteral.setCharValue(string.charAt(0));
        return characterLiteral;
    }

    @Override
    protected String convertExpression(Expression expression) {
        Object value = expression.resolveConstantExpressionValue();
        return value instanceof Character ? ((Character)value).toString() : null;
    }
}

